/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class SinceTagChecker
extends ASTVisitor {
    private static final int ABORT = 1;
    private static final int MISSING = 2;
    private static final int HAS_JAVA_DOC = 4;
    private static final int HAS_NO_COMMENT = 16;
    private int nameStart;
    int bits;
    private String sinceVersion;

    public SinceTagChecker(int nameStart) {
        this.nameStart = nameStart;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if ((this.bits & 1) != 0) {
            return false;
        }
        if (node.getName().getStartPosition() == this.nameStart) {
            this.bits |= 1;
            ASTNode parent = node.getParent();
            if (parent.getNodeType() == 23) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)parent;
                this.processJavadoc((BodyDeclaration)fieldDeclaration);
            }
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(TypeDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(RecordDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    private boolean visitAbstractTypeDeclaration(AbstractTypeDeclaration declaration) {
        if ((this.bits & 1) != 0) {
            return false;
        }
        if (declaration.getName().getStartPosition() == this.nameStart) {
            this.bits |= 1;
            this.processJavadoc((BodyDeclaration)declaration);
        }
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this.visitAbstractTypeDeclaration((AbstractTypeDeclaration)node);
    }

    public boolean visit(MethodDeclaration node) {
        if ((this.bits & 1) != 0) {
            return false;
        }
        if (node.getName().getStartPosition() == this.nameStart) {
            this.bits |= 1;
            this.processJavadoc((BodyDeclaration)node);
        }
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if ((this.bits & 1) != 0) {
            return false;
        }
        if (node.getName().getStartPosition() == this.nameStart) {
            this.bits |= 1;
            this.processJavadoc((BodyDeclaration)node);
        }
        return false;
    }

    public boolean visit(Initializer node) {
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if ((this.bits & 1) != 0) {
            return false;
        }
        if (node.getName().getStartPosition() == this.nameStart) {
            this.bits |= 1;
            this.processJavadoc((BodyDeclaration)node);
        }
        return false;
    }

    private void processJavadoc(BodyDeclaration bodyDeclaration) {
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        boolean found = false;
        if (javadoc != null) {
            this.bits |= 4;
            List tags = javadoc.tags();
            for (TagElement element : tags) {
                String tagName = element.getTagName();
                if (!"@since".equals(tagName)) continue;
                found = true;
                List fragments = element.fragments();
                if (fragments.size() >= 1) {
                    ASTNode fragment = (ASTNode)fragments.get(0);
                    if (fragment.getNodeType() != 66) break;
                    this.sinceVersion = ((TextElement)fragment).getText();
                    break;
                }
                this.sinceVersion = "";
                break;
            }
            if (!found) {
                this.bits |= 2;
            }
        } else {
            this.bits |= 0x10;
        }
    }

    public boolean isMissing() {
        return (this.bits & 2) != 0;
    }

    public boolean hasNoComment() {
        return (this.bits & 0x10) != 0;
    }

    public boolean hasJavadocComment() {
        return (this.bits & 4) != 0;
    }

    public String getSinceVersion() {
        if (this.sinceVersion != null) {
            return this.sinceVersion.trim();
        }
        return null;
    }
}

