/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.impl.list.immutable.ImmutableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableListIterator<T>
extends ImmutableIterator<T>
implements ListIterator<T> {
    public ImmutableListIterator(List<T> list, int index) {
        super(list);
        this.currentIndex = index;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentIndex != 0;
    }

    @Override
    public T previous() {
        try {
            int i = this.currentIndex - 1;
            Object previous = this.list.get(i);
            this.currentIndex = i;
            return (T)previous;
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int nextIndex() {
        return this.currentIndex;
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void set(T o) {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public void add(T o) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }
}

