/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.LongDoublePair;

public class LongDoublePairImpl
implements LongDoublePair {
    private static final long serialVersionUID = 1L;
    private final long one;
    private final double two;

    LongDoublePairImpl(long newOne, double newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public long getOne() {
        return this.one;
    }

    @Override
    public double getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongDoublePair)) {
            return false;
        }
        LongDoublePair that = (LongDoublePair)o;
        return this.one == that.getOne() && Double.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * (int)(this.one ^ this.one >>> 32) + (int)(Double.doubleToLongBits(this.two) ^ Double.doubleToLongBits(this.two) >>> 32);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(LongDoublePair that) {
        int i;
        int n = this.one < that.getOne() ? -1 : (i = this.one > that.getOne() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        return Double.compare(this.two, that.getTwo());
    }
}

