/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableDoubleSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import org.eclipse.collections.impl.set.primitive.AbstractDoubleSet;

public final class DoubleHashSet
extends AbstractDoubleSet
implements MutableDoubleSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final double EMPTY = 0.0;
    private static final double REMOVED = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private double[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public DoubleHashSet() {
        this.allocateTable(16);
    }

    public DoubleHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public DoubleHashSet(double ... elements) {
        this();
        this.addAll(elements);
    }

    public DoubleHashSet(DoubleHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static DoubleHashSet newSet(DoubleIterable source) {
        if (source instanceof DoubleHashSet) {
            return new DoubleHashSet((DoubleHashSet)source);
        }
        return DoubleHashSet.newSetWith(source.toArray());
    }

    public static DoubleHashSet newSetWith(double ... source) {
        return new DoubleHashSet(source);
    }

    private static boolean isBetweenZeroAndThirtyOne(double value) {
        return Double.compare(value, 0.0) >= 0 && Double.compare(value, 31.0) <= 0 && Double.compare(value, Math.floor(value)) == 0;
    }

    @Override
    public int hashCode() {
        double value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (int)(Double.doubleToLongBits(value) ^ Double.doubleToLongBits(value) >>> 32);
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!DoubleHashSet.isNonSentinel(this.table[i])) continue;
                result += (int)(Double.doubleToLongBits(this.table[i]) ^ Double.doubleToLongBits(this.table[i]) >>> 32);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            double value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(double element) {
        if (DoubleHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << (int)element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (Double.compare(this.table[index], element) == 0) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (Double.compare(this.table[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    @Override
    public boolean addAll(double ... source) {
        int oldSize = this.size();
        for (double item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(DoubleIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof DoubleHashSet) {
            DoubleHashSet hashSet = (DoubleHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (double item : hashSet.table) {
                if (!DoubleHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                double item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(double value) {
        if (DoubleHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << (int)value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (Double.compare(this.table[index], value) == 0) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(DoubleIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof DoubleHashSet) {
            DoubleHashSet hashSet = (DoubleHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (double item : hashSet.table) {
                if (!DoubleHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                double item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(double ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (double item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(DoubleIterable source) {
        int oldSize = this.size();
        DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
        DoubleHashSet retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(double ... source) {
        return this.retainAll(DoubleHashSet.newSetWith(source));
    }

    @Override
    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new double[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0.0);
        }
    }

    @Override
    public DoubleHashSet with(double element) {
        this.add(element);
        return this;
    }

    @Override
    public DoubleHashSet without(double element) {
        this.remove(element);
        return this;
    }

    @Override
    public DoubleHashSet withAll(DoubleIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    @Override
    public DoubleHashSet withoutAll(DoubleIterable elements) {
        this.removeAll(elements);
        return this;
    }

    @Override
    public MutableDoubleSet asUnmodifiable() {
        return new UnmodifiableDoubleSet(this);
    }

    @Override
    public MutableDoubleSet asSynchronized() {
        return new SynchronizedDoubleSet(this);
    }

    @Override
    public ImmutableDoubleSet toImmutable() {
        if (this.size() == 0) {
            return DoubleSets.immutable.with();
        }
        if (this.size() == 1) {
            return DoubleSets.immutable.with(this.doubleIterator().next());
        }
        DoubleHashSet mutableSet = DoubleHashSet.newSetWith(this.toArray());
        return new ImmutableDoubleHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    @Override
    public double[] toArray() {
        double value;
        double[] array = new double[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (double)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!DoubleHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public boolean contains(double value) {
        if (DoubleHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> (int)value & 1) != 0;
        }
        return Double.compare(this.table[this.probe(value)], value) == 0;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    @Override
    public DoubleHashSet select(DoublePredicate predicate) {
        return this.select(predicate, new DoubleHashSet());
    }

    @Override
    public <R extends MutableDoubleCollection> R select(DoublePredicate predicate, R target) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            target.add(value);
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public DoubleHashSet reject(DoublePredicate predicate) {
        return this.reject(predicate, new DoubleHashSet());
    }

    @Override
    public <R extends MutableDoubleCollection> R reject(DoublePredicate predicate, R target) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            target.add(value);
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.collect(function, UnifiedSet.newSet(this.size()));
    }

    @Override
    public <V, R extends Collection<V>> R collect(DoubleToObjectFunction<? extends V> function, R target) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    @Override
    public int count(DoublePredicate predicate) {
        double value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        double value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public double sum() {
        double value;
        double result = 0.0;
        double compensation = 0.0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            double adjustedValue = value - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2)) continue;
            double adjustedValue = value2 - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    @Override
    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (double value : this.table) {
            if (!DoubleHashSet.isNonSentinel(value) || isMaxSet && Double.compare(max, value) >= 0) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        double min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (double value : this.table) {
            if (!DoubleHashSet.isNonSentinel(value) || isMinSet && Double.compare(value, min) >= 0) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    @Override
    public DoubleSet freeze() {
        if (this.size() == 0) {
            return DoubleSets.immutable.with();
        }
        if (this.size() == 1) {
            return DoubleSets.immutable.with(this.doubleIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableDoubleHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        double value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeDouble(value);
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2)) continue;
            out.writeDouble(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readDouble());
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        double value;
        T result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (double value2 : this.table) {
            if (!DoubleHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        double[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new double[sizeToAllocate];
    }

    int probe(double element) {
        int index = this.spreadAndMask(element);
        double valueAtIndex = this.table[index];
        if (Double.compare(valueAtIndex, element) == 0 || Double.compare(valueAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(valueAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            valueAtIndex = this.table[nextIndex];
            if (Double.compare(valueAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(valueAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            double valueAtIndex = this.table[nextIndex];
            if (Double.compare(valueAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(valueAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)Long.reverse(SpreadFunctions.doubleSpreadOne(element));
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double valueAtIndex;
        while (Double.compare(valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Double.compare(valueAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        double[] copy = new double[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, this.table.length);
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(double value) {
        return Double.compare(value, 0.0) != 0 && Double.compare(value, 1.0) != 0;
    }

    private static final class ImmutableDoubleHashSet
    extends AbstractImmutableDoubleSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableDoubleHashSet(double[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use DoubleSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableDoubleSet newSetWith(double ... elements) {
            return DoubleHashSet.newSetWith(elements).toImmutable();
        }

        @Override
        public int hashCode() {
            double value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (int)(Double.doubleToLongBits(value) ^ Double.doubleToLongBits(value) >>> 32);
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!DoubleHashSet.isNonSentinel(this.table[i])) continue;
                    result += (int)(Double.doubleToLongBits(this.table[i]) ^ Double.doubleToLongBits(this.table[i]) >>> 32);
                }
            }
            return result;
        }

        @Override
        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                double value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (double value2 : this.table) {
                    if (!DoubleHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public DoubleIterator doubleIterator() {
            return new InternalDoubleIterator();
        }

        @Override
        public double[] toArray() {
            double value;
            double[] array = new double[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (double)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!DoubleHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public boolean contains(double value) {
            if (DoubleHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> (int)value & 1) != 0;
            }
            return Double.compare(this.table[this.probe(value)], value) == 0;
        }

        @Override
        public void forEach(DoubleProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(DoubleProcedure procedure) {
            double value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        @Override
        public ImmutableDoubleSet select(DoublePredicate predicate) {
            return this.select(predicate, new DoubleHashSet()).toImmutable();
        }

        @Override
        public ImmutableDoubleSet reject(DoublePredicate predicate) {
            return this.reject(predicate, new DoubleHashSet()).toImmutable();
        }

        @Override
        public <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet set = this.collect(function, UnifiedSet.newSet(this.size()));
            return set.toImmutable();
        }

        @Override
        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            double value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        @Override
        public int count(DoublePredicate predicate) {
            double value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(DoublePredicate predicate) {
            double value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(DoublePredicate predicate) {
            double value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(DoublePredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public double sum() {
            double value;
            double result = 0.0;
            double compensation = 0.0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                double adjustedValue = value - compensation;
                double nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2)) continue;
                double adjustedValue = value2 - compensation;
                double nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            return result;
        }

        @Override
        public double max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (double value : this.table) {
                if (!DoubleHashSet.isNonSentinel(value) || isMaxSet && Double.compare(max, value) >= 0) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        @Override
        public double min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (double value : this.table) {
                if (!DoubleHashSet.isNonSentinel(value) || isMinSet && Double.compare(value, min) >= 0) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            double value;
            T result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (double value2 : this.table) {
                if (!DoubleHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        private Object writeReplace() {
            return new ImmutableDoubleSetSerializationProxy(this);
        }

        int probe(double element) {
            int index = this.spreadAndMask(element);
            double valueAtIndex = this.table[index];
            if (Double.compare(valueAtIndex, element) == 0 || Double.compare(valueAtIndex, 0.0) == 0) {
                return index;
            }
            int removedIndex = Double.compare(valueAtIndex, 1.0) == 0 ? index : -1;
            for (int i = 1; i < 4; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                valueAtIndex = this.table[nextIndex];
                if (Double.compare(valueAtIndex, element) == 0) {
                    return nextIndex;
                }
                if (Double.compare(valueAtIndex, 0.0) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeTwo(element, removedIndex);
        }

        int probeTwo(double element, int removedIndex) {
            int index = this.spreadTwoAndMask(element);
            for (int i = 0; i < 4; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                double valueAtIndex = this.table[nextIndex];
                if (Double.compare(valueAtIndex, element) == 0) {
                    return nextIndex;
                }
                if (Double.compare(valueAtIndex, 0.0) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeThree(element, removedIndex);
        }

        int probeThree(double element, int removedIndex) {
            int nextIndex = (int)Long.reverse(SpreadFunctions.doubleSpreadOne(element));
            int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
            double valueAtIndex;
            while (Double.compare(valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
                if (Double.compare(valueAtIndex, 0.0) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Double.compare(valueAtIndex, 1.0) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return nextIndex;
        }

        int spreadAndMask(double element) {
            long code = SpreadFunctions.doubleSpreadOne(element);
            return this.mask((int)code);
        }

        int spreadTwoAndMask(double element) {
            long code = SpreadFunctions.doubleSpreadTwo(element);
            return this.mask((int)code);
        }

        private int mask(int spread) {
            return spread & this.table.length - 1;
        }

        private class InternalDoubleIterator
        implements DoubleIterator {
            private int count;
            private int position;
            private double zeroToThirtyOne;

            private InternalDoubleIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.count < ImmutableDoubleHashSet.this.size();
            }

            @Override
            public double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32.0) {
                    if (ImmutableDoubleHashSet.this.contains(this.zeroToThirtyOne)) {
                        double result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne += 1.0;
                        return result;
                    }
                    this.zeroToThirtyOne += 1.0;
                }
                double[] table = ImmutableDoubleHashSet.this.table;
                while (!DoubleHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                double result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double zeroToThirtyOne;

        private InternalDoubleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < DoubleHashSet.this.size();
        }

        @Override
        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32.0) {
                if (DoubleHashSet.this.contains(this.zeroToThirtyOne)) {
                    double result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne += 1.0;
                    return result;
                }
                this.zeroToThirtyOne += 1.0;
            }
            double[] table = DoubleHashSet.this.table;
            while (!DoubleHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            double result = table[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            double removeValue;
            if (this.count == 0) {
                throw new IllegalStateException();
            }
            if (this.zeroToThirtyOne <= 32.0 && this.position == 0) {
                if (DoubleHashSet.this.zeroToThirtyOne != (DoubleHashSet.this.zeroToThirtyOne | 1 << (int)this.zeroToThirtyOne - 1)) {
                    throw new IllegalStateException();
                }
                removeValue = this.zeroToThirtyOne - 1.0;
            } else {
                if (Double.compare(DoubleHashSet.this.table[this.position - 1], 1.0) == 0) {
                    throw new IllegalStateException();
                }
                removeValue = DoubleHashSet.this.table[this.position - 1];
            }
            DoubleHashSet.this.remove(removeValue);
            --this.count;
        }
    }
}

