/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.stack;

import java.util.Collection;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.partition.stack.PartitionMutableStack;
import org.eclipse.collections.api.stack.StackIterable;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.api.stack.primitive.MutableCharStack;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.api.stack.primitive.MutableShortStack;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableStack<T>
extends StackIterable<T> {
    public void push(T var1);

    public T pop();

    public ListIterable<T> pop(int var1);

    public <R extends Collection<T>> R pop(int var1, R var2);

    public <R extends MutableStack<T>> R pop(int var1, R var2);

    public void clear();

    @Override
    public MutableStack<T> takeWhile(Predicate<? super T> var1);

    @Override
    public MutableStack<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionMutableStack<T> partitionWhile(Predicate<? super T> var1);

    @Override
    public MutableStack<T> distinct();

    public MutableStack<T> asUnmodifiable();

    public MutableStack<T> asSynchronized();

    @Override
    public MutableStack<T> tap(Procedure<? super T> var1);

    @Override
    public MutableStack<T> select(Predicate<? super T> var1);

    @Override
    public <P> MutableStack<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public MutableStack<T> reject(Predicate<? super T> var1);

    @Override
    public <P> MutableStack<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> MutableStack<S> selectInstancesOf(Class<S> var1);

    @Override
    public PartitionMutableStack<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionMutableStack<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> MutableStack<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public MutableBooleanStack collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public MutableByteStack collectByte(ByteFunction<? super T> var1);

    @Override
    public MutableCharStack collectChar(CharFunction<? super T> var1);

    @Override
    public MutableDoubleStack collectDouble(DoubleFunction<? super T> var1);

    @Override
    public MutableFloatStack collectFloat(FloatFunction<? super T> var1);

    @Override
    public MutableIntStack collectInt(IntFunction<? super T> var1);

    @Override
    public MutableLongStack collectLong(LongFunction<? super T> var1);

    @Override
    public MutableShortStack collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> MutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> MutableStack<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    default public <V> MutableStack<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    @Override
    public <V> MutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> var1, IntFunction<? super T> var2);

    @Override
    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> var1, FloatFunction<? super T> var2);

    @Override
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> var1, LongFunction<? super T> var2);

    @Override
    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> var1, DoubleFunction<? super T> var2);

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    default public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag();
    }

    @Override
    default public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag();
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> var1);

    @Override
    public <S> MutableStack<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public MutableStack<Pair<T, Integer>> zipWithIndex();

    @Override
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Procedure2<? super V, ? super T> var3);

    @Override
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Function2<? super V, ? super T, ? extends V> var3);
}

