/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.stack.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.ordered.primitive.OrderedByteIterable;
import org.eclipse.collections.api.stack.StackIterable;

/**
 * This file was automatically generated from template file primitiveStack.stg.
 *
 * @since 3.0.
 */
public interface ByteStack extends OrderedByteIterable
{
    /**
     * Returns the top of the stack.
     */
    byte peek();

    /**
     * Returns ByteList of the number of elements specified by the count, beginning with the top of the stack.
     */
    ByteList peek(int count);

    /**
     * Returns the element at the specified index.
     *
     * @param index the location to peek into
     */
    byte peekAt(int index);

    @Override
    ByteStack select(BytePredicate predicate);

    @Override
    ByteStack reject(BytePredicate predicate);

    @Override
    <V> StackIterable<V> collect(ByteToObjectFunction<? extends V> function);

    /**
     * Follows the same general contract as {@link StackIterable#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link StackIterable#hashCode()}.
     */
    @Override
    int hashCode();

    ImmutableByteStack toImmutable();
}
