/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortList extends ImmutableShortCollection, ShortList
{
    @Override
    ImmutableShortList select(ShortPredicate predicate);

    @Override
    ImmutableShortList reject(ShortPredicate predicate);

    @Override
    <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function);

    @Override
    ImmutableShortList newWith(short element);

    @Override
    ImmutableShortList newWithout(short element);

    @Override
    ImmutableShortList newWithAll(ShortIterable elements);

    @Override
    ImmutableShortList newWithoutAll(ShortIterable elements);

    @Override
    ImmutableShortList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableShortList distinct();

    @Override
    ImmutableShortList subList(int fromIndex, int toIndex);
}
