/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.factory.bag.primitive.MutableCharBagFactory;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableCharBagFactoryImpl
implements MutableCharBagFactory {
    public static final MutableCharBagFactory INSTANCE = new MutableCharBagFactoryImpl();

    @Override
    public MutableCharBag empty() {
        return new CharHashBag();
    }

    @Override
    public MutableCharBag of() {
        return this.empty();
    }

    @Override
    public MutableCharBag with() {
        return this.empty();
    }

    @Override
    public MutableCharBag of(char ... items) {
        return this.with(items);
    }

    @Override
    public MutableCharBag with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return CharHashBag.newBagWith(items);
    }

    @Override
    public MutableCharBag ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableCharBag withAll(CharIterable items) {
        return CharHashBag.newBag(items);
    }

    @Override
    public MutableCharBag ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableCharBag withAll(Iterable<Character> iterable) {
        return Iterate.collectChar(iterable, Character::charValue, CharBags.mutable.empty());
    }
}

