/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableMapIterable<K, V>
extends MapIterable<K, V>,
Map<K, V> {
    default public V putPair(Pair<? extends K, ? extends V> keyValuePair) {
        return this.put(keyValuePair.getOne(), keyValuePair.getTwo());
    }

    default public V add(Pair<? extends K, ? extends V> keyValuePair) {
        return this.putPair(keyValuePair);
    }

    public V removeKey(K var1);

    default public boolean removeAllKeys(Set<? extends K> keys) {
        Objects.requireNonNull(keys);
        int previousSize = this.size();
        keys.forEach(this::removeKey);
        return previousSize != this.size();
    }

    default public boolean removeIf(Predicate2<? super K, ? super V> predicate) {
        return this.entrySet().removeIf((? super E entry) -> predicate.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    @Override
    default public V getOrDefault(Object key, V defaultValue) {
        return this.getIfAbsentValue(key, defaultValue);
    }

    public V getIfAbsentPut(K var1, Function0<? extends V> var2);

    public V getIfAbsentPut(K var1, V var2);

    public V getIfAbsentPutWithKey(K var1, Function<? super K, ? extends V> var2);

    public <P> V getIfAbsentPutWith(K var1, Function<? super P, ? extends V> var2, P var3);

    public V updateValue(K var1, Function0<? extends V> var2, Function<? super V, ? extends V> var3);

    public <P> V updateValueWith(K var1, Function0<? extends V> var2, Function2<? super V, ? super P, ? extends V> var3, P var4);

    public MutableMapIterable<K, V> withKeyValue(K var1, V var2);

    default public MutableMapIterable<K, V> withMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
        return this;
    }

    default public MutableMapIterable<K, V> withMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        this.putAllMapIterable(mapIterable);
        return this;
    }

    default public void putAllMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        mapIterable.forEachKeyValue(this::put);
    }

    public MutableMapIterable<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> var1);

    public MutableMapIterable<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... var1);

    public MutableMapIterable<K, V> withoutKey(K var1);

    public MutableMapIterable<K, V> withoutAllKeys(Iterable<? extends K> var1);

    public MutableMapIterable<K, V> newEmpty();

    public MutableMapIterable<K, V> asUnmodifiable();

    public MutableMapIterable<K, V> asSynchronized();

    @Override
    public ImmutableMapIterable<K, V> toImmutable();

    @Override
    public MutableMapIterable<K, V> tap(Procedure<? super V> var1);

    @Override
    public MutableMapIterable<V, K> flipUniqueValues();

    @Override
    public MutableMultimap<V, K> flip();

    @Override
    public MutableMapIterable<K, V> select(Predicate2<? super K, ? super V> var1);

    @Override
    public MutableMapIterable<K, V> reject(Predicate2<? super K, ? super V> var1);

    @Override
    public <K2, V2> MutableMapIterable<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public <R> MutableMapIterable<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    @Override
    public MutableCollection<V> select(Predicate<? super V> var1);

    @Override
    public <P> MutableCollection<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public MutableCollection<V> reject(Predicate<? super V> var1);

    @Override
    public <P> MutableCollection<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public PartitionMutableCollection<V> partition(Predicate<? super V> var1);

    @Override
    public <S> MutableCollection<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> var1, IntFunction<? super V> var2);

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> var1, FloatFunction<? super V> var2);

    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> var1, LongFunction<? super V> var2);

    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> var1, DoubleFunction<? super V> var2);

    @Override
    default public <V1> MutableBag<V1> countBy(Function<? super V, ? extends V1> function) {
        return this.asLazy().collect(function).toBag();
    }

    @Override
    default public <V1, P> MutableBag<V1> countByWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return this.asLazy().collectWith(function, (Object)parameter).toBag();
    }

    @Override
    default public <V1> MutableBag<V1> countByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.asLazy().flatCollect(function).toBag();
    }

    @Override
    public <V1> MutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> var1);

    @Override
    public <V1> MutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> var1);

    @Override
    public <V1> MutableMapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> var1);

    @Override
    public <S> MutableCollection<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    public MutableCollection<Pair<V, Integer>> zipWithIndex();

    @Override
    default public <KK, VV> MutableMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf((Object)each);
            Function0 value = map.getIfAbsentPut((Object)key, (Object)zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map;
    }

    @Override
    default public <KK, VV> MutableMapIterable<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator, Maps.mutable.empty());
    }

    @Override
    default public <K1, V1, V2> MutableMapIterable<K1, V2> aggregateBy(Function<? super K, ? extends K1> keyFunction, Function<? super V, ? extends V1> valueFunction, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V1, ? extends V2> nonMutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEachKeyValue((key, value) -> map.updateValueWith(keyFunction.valueOf((Object)key), zeroValueFactory, nonMutatingAggregator, valueFunction.valueOf((Object)value)));
        return map;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        MapIterable.super.forEach(action);
    }
}

