/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.statebased;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFExtractor;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;
import org.eclipse.papyrus.MARTE.MARTEPackage;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.sysml.SysmlPackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.chessmlprofilePackage;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.statebased.DEEMClient;
import org.polarsys.chess.statebased.PeriodicExecutionDialog;
import org.polarsys.chess.statebased.daemon.ParameterList;

public class StateBasedWithParametersCommand
extends AbstractHandler
implements Runnable {
    private static final String PLUGIN_PATH = "platform:/plugin/org.polarsys.chess.statebased";
    private static final String sysmlPath = "http://www.eclipse.org/papyrus/0.7.0/SysML";
    private static final String martePath = "http://www.eclipse.org/papyrus/MARTE/1";
    private static final String chessPath = "ttp://CHESS";
    private static final String umlPath = "http://www.eclipse.org/uml2/4.0.0/UML";
    private static final String imPath = "platform:/plugin/org.polarsys.chess.statebased/metamodels/IM2.ecore";
    private static final String pnmlPath = "platform:/plugin/org.polarsys.chess.statebased/metamodels/placeTransition.ecore";
    private static final String STEP1_PATH = "platform:/plugin/org.polarsys.chess.statebased/transformations/CHESS2IM.asm";
    private static final String STEP2_PATH = "platform:/plugin/org.polarsys.chess.statebased/transformations/IDM2PNML.asm";
    private static final String STEP3_PATH = "platform:/plugin/org.polarsys.chess.statebased/transformations/PNML2DEEM.asm";
    public static final String COMMAND_ID = "org.chess.stateBasedTransformationCommandID";
    private static final String SBANALYSIS_DIR = "StateBasedAnalysis";
    private static final String UML = ".uml";
    private static final String IM = ".idm";
    private static final String PNML = ".pnml";
    private static final String DEEM = ".deem";
    private static IInjector injector;
    private static IExtractor extractor;
    private static IReferenceModel sysmlMetamodel;
    private static IReferenceModel marteMetamodel;
    private static IReferenceModel chessMetamodel;
    private static IReferenceModel umlMetamodel;
    private static IReferenceModel imMetamodel;
    private static IReferenceModel pnmlMetamodel;
    private static String chessModelPath;
    private static String imModelPath;
    private static String pnmlModelPath;
    private static String resultName;
    private static final String NETNAME = "NET_NAME";
    private static final String MEASURE = " ->";
    private static final String CHESS_QN = "CHESS::Core::CHESS";
    private static final String STATEBASED_ANALYSIS_QN = "CHESS::Dependability::StateBased::StateBasedAnalysis::StateBasedAnalysis";
    private static final String RESULT = "measureEvaluationResult";
    private static Shell shell;
    private static final String ERROR_MSG = "Problems while perfoming State-Based Analysis: ";
    static PapyrusMultiDiagramEditor editor;
    static ParameterList params;
    static PeriodicExecutionDialog periodicDialog;
    static IFile inputFile;
    static String paramFilePath;
    static String resultsFilePath;
    static IFolder folder;
    static DateFormat dateFormatter;

    static {
        shell = new Shell();
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StateBasedWithParametersCommand.acquireModel();
        periodicDialog = new PeriodicExecutionDialog(shell);
        periodicDialog.open();
        return null;
    }

    public String runStateBased(String modelPath, String parametersFilePath, String resultAnalysisPathFile) throws IOException {
        IProgressMonitor monitor = null;
        if (periodicDialog != null) {
            monitor = periodicDialog.getMonitor();
        }
        InputStream is = StateBasedWithParametersCommand.RunTransformations(modelPath, parametersFilePath, monitor);
        byte[] buffer = new byte[is.available()];
        is.read(buffer);
        File targetFile = new File(resultAnalysisPathFile);
        FileOutputStream outStream = new FileOutputStream(targetFile);
        ((OutputStream)outStream).write(buffer);
        ((OutputStream)outStream).close();
        System.out.println("Connecting to DEEM server...");
        String res = StateBasedWithParametersCommand.connectToDeem(targetFile.getAbsolutePath(), targetFile.getParent(), monitor);
        return res;
    }

    protected void setEditor(PapyrusMultiDiagramEditor ed) {
        editor = ed;
    }

    protected void setParameters(ParameterList p) {
        params = p;
    }

    protected static void runStateBased() {
        IFile inputCopy;
        try {
            inputCopy = CHESSProjectSupport.copyFile((IFile)inputFile, (String)SBANALYSIS_DIR, (String)inputFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return;
        }
        InputStream is = StateBasedWithParametersCommand.RunTransformations(inputCopy.getLocation().toString(), paramFilePath, periodicDialog.getMonitor());
        resultName = StateBasedWithParametersCommand.changeSuffix(inputFile.getName(), UML, DEEM);
        IFile resultFile = folder.getFile(resultName);
        try {
            resultFile.delete(true, null);
            resultFile.create(is, 1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return;
        }
        String res = StateBasedWithParametersCommand.connectToDeem(resultFile.getLocation().toString(), resultFile.getParent().getLocation().toString(), periodicDialog.getMonitor());
        if (res != null && !res.isEmpty()) {
            StateBasedWithParametersCommand.backPropagation(res, editor);
        }
        periodicDialog.stopMonitor();
    }

    protected static void acquireModel() {
        try {
            editor = CHESSEditorUtils.getCHESSEditor();
            params = DEEMClient.getParameters();
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            IFile file = input.getFile();
            IProject project = file.getProject();
            folder = project.getFolder(SBANALYSIS_DIR);
            CHESSProjectSupport.createFolder((IFolder)folder);
            Resource inResource = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
            inputFile = CHESSProjectSupport.resourceToFile((Resource)inResource);
        }
        catch (CoreException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
        }
    }

    protected static void setParamsFilePath(String path) {
        paramFilePath = path;
    }

    protected static void setResultsFilePath(String path) {
        resultsFilePath = path;
    }

    private static InputStream RunTransformations(String chessModelFullPath, String parametersFilePath, IProgressMonitor monitor) {
        try {
            block25: {
                String sModelContent;
                File fCHESSModel;
                HashMap<String, String> mapParameters;
                block23: {
                    String s;
                    block21: {
                        chessModelPath = chessModelFullPath;
                        File fParams = new File(parametersFilePath);
                        mapParameters = new HashMap<String, String>();
                        FileReader fr = new FileReader(fParams);
                        try {
                            try {
                                BufferedReader br = new BufferedReader(fr);
                                while ((s = br.readLine()) != null) {
                                    String[] sSplit = s.split("\\s+");
                                    mapParameters.put(sSplit[0], sSplit[1]);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.out.println(e.getMessage());
                                fr.close();
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            fr.close();
                            throw throwable;
                        }
                        fr.close();
                    }
                    fCHESSModel = new File(chessModelFullPath);
                    FileReader frModel = new FileReader(fCHESSModel);
                    sModelContent = "";
                    try {
                        try {
                            BufferedReader brModel = new BufferedReader(frModel);
                            while ((s = brModel.readLine()) != null) {
                                sModelContent = String.valueOf(sModelContent) + s + "\r\n";
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e.getMessage());
                            frModel.close();
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        frModel.close();
                        throw throwable;
                    }
                    frModel.close();
                }
                Iterator itParams = mapParameters.keySet().iterator();
                String sCurrentKey = null;
                while (itParams.hasNext()) {
                    sCurrentKey = (String)itParams.next();
                    sModelContent = sModelContent.replaceAll("\\" + sCurrentKey, (String)mapParameters.get(sCurrentKey));
                }
                FileWriter fwModel = new FileWriter(fCHESSModel);
                try {
                    try {
                        fwModel.write(sModelContent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println(e.getMessage());
                        fwModel.close();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    fwModel.close();
                    throw throwable;
                }
                fwModel.close();
            }
            CoreService.registerLauncher((String)"EMF-specific VM", EMFVMLauncher.class);
            CoreService.registerFactory((String)"EMF", EMFModelFactory.class);
            CoreService.registerExtractor((String)"EMF", EMFExtractor.class);
            CoreService.registerInjector((String)"EMF", EMFInjector.class);
            injector = CoreService.getInjector((String)"EMF");
            extractor = CoreService.getExtractor((String)"EMF");
            ModelFactory factory = CoreService.getModelFactory((String)"EMF");
            sysmlMetamodel = factory.newReferenceModel();
            marteMetamodel = factory.newReferenceModel();
            chessMetamodel = factory.newReferenceModel();
            umlMetamodel = factory.newReferenceModel();
            imMetamodel = factory.newReferenceModel();
            EPackage.Registry.INSTANCE.put((Object)sysmlPath, (Object)SysmlPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)martePath, (Object)MARTEPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)chessPath, (Object)chessmlprofilePackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)umlPath, (Object)UMLPackage.eINSTANCE);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            injector.inject((IModel)sysmlMetamodel, sysmlPath);
            injector.inject((IModel)marteMetamodel, martePath);
            injector.inject((IModel)chessMetamodel, chessPath);
            injector.inject((IModel)umlMetamodel, umlPath);
            injector.inject((IModel)imMetamodel, imPath);
            IModel sysmlModel = factory.newModel(sysmlMetamodel);
            IModel marteModel = factory.newModel(marteMetamodel);
            IModel chessModel = factory.newModel(chessMetamodel);
            IModel umlModel = factory.newModel(umlMetamodel);
            IModel imModel = factory.newModel(imMetamodel);
            chessModelPath = "file:///" + chessModelPath;
            injector.inject(sysmlModel, chessModelPath);
            injector.inject(marteModel, chessModelPath);
            injector.inject(chessModel, chessModelPath);
            injector.inject(umlModel, chessModelPath);
            EMFVMLauncher launcher = null;
            launcher = (EMFVMLauncher)CoreService.getLauncher((String)"EMF-specific VM");
            launcher.initialize(Collections.emptyMap());
            launcher.addInModel(chessModel, "IN1", "CHESS");
            launcher.addInModel(chessModel, "IN2", "UML");
            launcher.addInModel(marteModel, "IN3", "MARTE");
            launcher.addInModel(sysmlModel, "IN4", "SYSML");
            launcher.addOutModel(imModel, "OUT", "IM");
            URL asmTransformation = new URL(STEP1_PATH);
            Object loadedModule = launcher.loadModule(asmTransformation.openStream());
            launcher.launch("run", (IProgressMonitor)new NullProgressMonitor(), Collections.emptyMap(), new Object[]{loadedModule});
            imModelPath = StateBasedWithParametersCommand.changeSuffix(chessModelPath, UML, IM);
            extractor.extract(imModel, imModelPath);
            System.out.println("CHESS -> IM ... DONE!");
            StateBasedWithParametersCommand.progress(1);
            pnmlMetamodel = factory.newReferenceModel();
            injector.inject((IModel)pnmlMetamodel, pnmlPath);
            IModel pnmlModel = factory.newModel(pnmlMetamodel);
            launcher = null;
            launcher = (EMFVMLauncher)CoreService.getLauncher((String)"EMF-specific VM");
            launcher.initialize(Collections.emptyMap());
            launcher.addInModel(imModel, "IN", "IDM");
            launcher.addOutModel(pnmlModel, "OUT", "PNML");
            asmTransformation = new URL(STEP2_PATH);
            loadedModule = launcher.loadModule(asmTransformation.openStream());
            launcher.launch("run", (IProgressMonitor)new NullProgressMonitor(), Collections.emptyMap(), new Object[]{loadedModule});
            pnmlModelPath = StateBasedWithParametersCommand.changeSuffix(chessModelPath, UML, PNML);
            extractor.extract(pnmlModel, pnmlModelPath);
            System.out.println("IM -> PNML ... DONE!");
            StateBasedWithParametersCommand.progress(1);
            launcher = null;
            launcher = (EMFVMLauncher)CoreService.getLauncher((String)"EMF-specific VM");
            launcher.initialize(Collections.emptyMap());
            launcher.addInModel(pnmlModel, "IN", "PNML");
            asmTransformation = new URL(STEP3_PATH);
            loadedModule = launcher.loadModule(asmTransformation.openStream());
            Object result = launcher.launch("run", (IProgressMonitor)new NullProgressMonitor(), Collections.emptyMap(), new Object[]{loadedModule});
            String stResult = result.toString();
            stResult = stResult.substring(1, stResult.lastIndexOf(93));
            ByteArrayInputStream is = new ByteArrayInputStream(stResult.getBytes("UTF-8"));
            System.out.println("PNML -> DEEM ... DONE!");
            StateBasedWithParametersCommand.progress(1);
            return is;
        }
        catch (ATLCoreException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
    }

    private static String connectToDeem(String modelPath, String modelFolderPath, IProgressMonitor monitor) {
        try {
            DEEMClient c = new DEEMClient();
            c.setProgressMonitor(monitor);
            String res = c.sendAndReceiveFile(modelPath, modelFolderPath);
            return res;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
            return null;
        }
    }

    private static void backPropagation(String analysis, PapyrusMultiDiagramEditor editor) {
        try {
            String line;
            String name = null;
            String value = null;
            FileInputStream fstream = new FileInputStream(analysis);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            HashMap<String, String> results = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(MEASURE)) continue;
                String[] lineSplit = line.split("\\s+");
                name = lineSplit[2];
                value = lineSplit[3];
                if (lineSplit[4].equals("(*)")) {
                    value = String.valueOf(value) + " " + lineSplit[4];
                }
                results.put(name, value);
            }
            in.close();
            if (results.size() > 0) {
                Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                Model umlModel = ResourceUtils.getModel((Resource)res);
                CHESS chess = (CHESS)umlModel.getStereotypeApplication(umlModel.getAppliedStereotype(CHESS_QN));
                Package depView = chess.getAnalysisView().getDepanalysisview().getBase_Package();
                EList packList = depView.getPackagedElements();
                Component comp = null;
                Iterator it = results.keySet().iterator();
                String key = null;
                File fResults = new File(resultsFilePath);
                FileWriter fwModel = new FileWriter(fResults);
                dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                while (it.hasNext()) {
                    key = (String)it.next();
                    int i = 0;
                    while (i < packList.size()) {
                        if (((PackageableElement)packList.get(i)).getName().equals(key)) {
                            comp = (Component)packList.get(i);
                        }
                        ++i;
                    }
                    final String finalValue = (String)results.get(key);
                    final Component com = comp;
                    final Stereotype stereotype = comp.getAppliedStereotype(STATEBASED_ANALYSIS_QN);
                    TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)editor.getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            com.setValue(stereotype, StateBasedWithParametersCommand.RESULT, (Object)finalValue);
                        }
                    });
                    fwModel.write(finalValue);
                    fwModel.write("\t");
                    fwModel.write(key);
                    fwModel.write("\t");
                    fwModel.write(dateFormatter.format(new Date()));
                    fwModel.write("\r\n");
                }
                fwModel.close();
            } else {
                System.out.println("Error: Unable to retrieve results from DEEM server.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            CHESSProjectSupport.printlnToCHESSConsole((String)e.toString());
            StateBasedWithParametersCommand.displayMessage(shell, ERROR_MSG + e.toString(), 1);
        }
    }

    private static String changeSuffix(String str, String oldsfx, String newsfx) {
        if (str.endsWith(oldsfx)) {
            str = str.substring(0, str.lastIndexOf("."));
            str = String.valueOf(str) + newsfx;
        }
        return str;
    }

    public static void displayMessage(final Shell parent, final String message, final int kind) {
        parent.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)kind, (Shell)parent, (String)"State-Based Analysis", (String)message, (int)0);
            }
        });
    }

    @Override
    public void run() {
        StateBasedWithParametersCommand.runStateBased();
    }

    public static String getModelPath() {
        return inputFile.getFullPath().toString();
    }

    private static void progress(int work) {
        if (periodicDialog != null) {
            periodicDialog.progress(work);
        }
    }
}

