/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.profile.chesscontract.util;

import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.contracts.profile.chesscontract.Contract;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class ContractEntityUtil {
    public static final String CONTRACT = "CHESSContract::Contract";
    public static final String CONTRACT_PROP = "CHESSContract::ContractProperty";
    public static final String CONTRACT_REFINEMENT = "CHESSContract::ContractRefinement";
    private static ContractEntityUtil contractEntityUtilInstance;
    private EntityUtil entityUtil = EntityUtil.getInstance();
    private static final Logger logger;

    static {
        logger = Logger.getLogger(ContractEntityUtil.class);
    }

    public static ContractEntityUtil getInstance() {
        if (contractEntityUtilInstance == null) {
            contractEntityUtilInstance = new ContractEntityUtil();
        }
        return contractEntityUtilInstance;
    }

    public DataType getOrCreateContractRefinement(Class owner, String componentInstanceName, String[] componentInstanceRange, String componentInstanceIndex, String contractName, Stereotype contractRefinementStereotype) {
        logger.debug((Object)("\n\n\n Creating contract refinement for componentName = " + componentInstanceName + " of contract " + contractName));
        logger.debug((Object)"\n\n\n");
        Property refiningComponentInstance = this.entityUtil.getUmlComponentInstance(owner, componentInstanceName);
        Class refiningComponent = (Class)refiningComponentInstance.getType();
        Property umlContractProperty = this.getPropertyOfUmlComponentWithContractPropertyType(refiningComponent, contractName);
        ContractProperty refiningContractProperty = this.getContractProperty(umlContractProperty);
        String refinementNameOptSuffix = "";
        if (!StringArrayUtil.isUndefined((String[])componentInstanceRange)) {
            logger.debug((Object)("!isUndefined" + componentInstanceRange[0] + " - " + componentInstanceRange[1]));
            refinementNameOptSuffix = refinementNameOptSuffix.concat("." + componentInstanceRange[0] + "." + componentInstanceRange[1]);
        } else if (componentInstanceIndex != null) {
            logger.debug((Object)("componentInstanceIndex: " + componentInstanceIndex));
            refinementNameOptSuffix = refinementNameOptSuffix.concat("." + componentInstanceIndex);
        }
        String refinementName = String.valueOf(componentInstanceName) + "." + umlContractProperty.getName() + refinementNameOptSuffix;
        DataType umlRefinement = this.getExistingUmlContractRefinement(owner, refinementName);
        if (umlRefinement != null) {
            return umlRefinement;
        }
        logger.debug((Object)("\n\n Creating contract refinement " + refinementName + " for owner " + owner.getName()));
        logger.debug((Object)"\n\n");
        return this.createContractRefinement(refinementName, refiningComponentInstance, componentInstanceRange, componentInstanceIndex, refiningContractProperty, owner, contractRefinementStereotype);
    }

    public Class createContract(Class owner, String contractName, Stereotype contractStereotype) {
        logger.debug((Object)("\n\n\n Creating contract " + contractName + " for owner " + owner));
        logger.debug((Object)"\n\n\n");
        Class newUmlClass = UMLFactory.eINSTANCE.createClass();
        Classifier newClass = owner.createNestedClassifier(contractName, newUmlClass.eClass());
        newClass.applyStereotype(contractStereotype);
        logger.debug((Object)("\n\nCreated " + contractName + " Property\n\n"));
        return (Class)newClass;
    }

    public Property createContractProperty(Class owner, String elementName, Type elementType, Stereotype contractPropertyStereotype) {
        logger.debug((Object)("\n\n\n Creating contract property " + elementName + " for owner " + owner + " with type " + elementType));
        logger.debug((Object)"\n\n\n");
        Property newUMLProperty = owner.createOwnedAttribute(elementName, elementType);
        newUMLProperty.applyStereotype(contractPropertyStereotype);
        logger.debug((Object)("\n\nCreated " + elementName + " Property\n\n"));
        return newUMLProperty;
    }

    private DataType createContractRefinement(String refinementName, Property refiningComponentInstance, String[] refiningComponentInstanceRange, String refiningComponentInstanceIndex, ContractProperty refiningContractProperty, Class owner, Stereotype contractRefinementStereotype) {
        DataType newUmlDataType = UMLFactory.eINSTANCE.createDataType();
        Classifier newClass = owner.createNestedClassifier(refinementName, newUmlDataType.eClass());
        newClass.applyStereotype(contractRefinementStereotype);
        ContractRefinement contractRefinement = (ContractRefinement)newClass.getStereotypeApplication(contractRefinementStereotype);
        contractRefinement.setInstance(refiningComponentInstance);
        contractRefinement.setContract(refiningContractProperty);
        if (refiningComponentInstanceRange != null) {
            contractRefinement.setLowerIndexOfInstance(refiningComponentInstanceRange[0]);
            contractRefinement.setUpperIndexOfInstance(refiningComponentInstanceRange[1]);
        } else if (refiningComponentInstanceIndex != null) {
            contractRefinement.setLowerIndexOfInstance(refiningComponentInstanceIndex);
            contractRefinement.setUpperIndexOfInstance(refiningComponentInstanceIndex);
        }
        logger.debug((Object)("\n\nCreated " + refinementName + " Contract Refinement\n\n"));
        return (DataType)newClass;
    }

    public String convertContractPropertyInStr(Property contractProperty) throws Exception {
        Property baseProperty = contractProperty;
        String basePropertyName = baseProperty.getName();
        Class umlContract = (Class)baseProperty.getType();
        if (umlContract == null) {
            throw new Exception("The contract instance '" + basePropertyName + "' of '" + ((Class)this.entityUtil.getOwner((Element)baseProperty)).getName() + "' does not have a contract.");
        }
        String contractName = umlContract.getName();
        if (contractName.contains(" ")) {
            throw new Exception("The name of the contract '" + contractName + "' of '" + ((Class)this.entityUtil.getOwner((Element)baseProperty)).getName() + "' has empty spaces. Please remove them from the name.");
        }
        String assume = this.getAssumeFormalPropertyStrFromUmlContract(umlContract);
        String guarantee = this.getGuaranteeFormalPropertyStrFromUmlContract(umlContract);
        String contractBody = "CONTRACT " + contractName + " assume : " + assume + " ; guarantee : " + guarantee + " ;";
        return contractBody;
    }

    public FormalProperty getAssumeFromUmlContract(Class umlContract) {
        Stereotype contractStereotype = UMLUtil.getAppliedStereotype((Element)umlContract, (String)CONTRACT, (boolean)false);
        return (FormalProperty)umlContract.getValue(contractStereotype, "Assume");
    }

    public FormalProperty getGuaranteeFromUmlContract(Class umlContract) {
        Stereotype contractStereotype = UMLUtil.getAppliedStereotype((Element)umlContract, (String)CONTRACT, (boolean)false);
        return (FormalProperty)umlContract.getValue(contractStereotype, "Guarantee");
    }

    public Contract getContract(Class umlContract) {
        Stereotype contractStereotype = UMLUtil.getAppliedStereotype((Element)umlContract, (String)CONTRACT, (boolean)false);
        return (Contract)umlContract.getStereotypeApplication(contractStereotype);
    }

    public String getContractQualifiedName(Class contract) {
        if (contract != null) {
            return contract.getQualifiedName();
        }
        return null;
    }

    public String getAssumeStrFromUmlContract(Class umlContract) {
        FormalProperty assumeFormalProperty = this.getAssumeFromUmlContract(umlContract);
        return this.entityUtil.getFormalPropertyStr(assumeFormalProperty, null);
    }

    public String getAssumeFormalPropertyStrFromUmlContract(Class umlContract) {
        FormalProperty assumeFormalProperty = this.getAssumeFromUmlContract(umlContract);
        if (assumeFormalProperty == null) {
            return null;
        }
        if (assumeFormalProperty.getBase_Constraint().getOwner() == umlContract) {
            return this.entityUtil.getFormalPropertyStr(assumeFormalProperty, null);
        }
        return assumeFormalProperty.getBase_Constraint().getName();
    }

    public String getGuaranteeStrFromUmlContract(Class umlContract) {
        FormalProperty guaranteeFormalProperty = this.getGuaranteeFromUmlContract(umlContract);
        return this.entityUtil.getFormalPropertyStr(guaranteeFormalProperty, null);
    }

    public String getGuaranteeFormalPropertyStrFromUmlContract(Class umlContract) {
        FormalProperty guaranteeFormalProperty = this.getGuaranteeFromUmlContract(umlContract);
        if (guaranteeFormalProperty == null) {
            return null;
        }
        if (guaranteeFormalProperty.getBase_Constraint().getOwner() == umlContract) {
            return this.entityUtil.getFormalPropertyStr(guaranteeFormalProperty, null);
        }
        return guaranteeFormalProperty.getBase_Constraint().getName();
    }

    public boolean isContract(Element umlElement) {
        return umlElement instanceof Class && umlElement.getAppliedStereotype(CONTRACT) != null;
    }

    public void applyContractStereotype(Class umlElement) {
        UMLUtils.applyStereotype((Element)umlElement, (String)CONTRACT);
    }

    public void createAssumptionToUmlContract(Class umlContract) {
        if (this.entityUtil.getOwner((Element)umlContract) != null) {
            Constraint assumeFormalProperty = this.createFormalPropertyInContract("Assumption", umlContract);
            Contract contract = this.getContract(umlContract);
            contract.setAssume(this.entityUtil.getFormalProperty(assumeFormalProperty));
        }
    }

    private Constraint createFormalPropertyInContract(String formalPropertyType, Class umlContract) {
        String propertyName = String.valueOf(formalPropertyType) + "_" + umlContract.getName();
        Constraint assumeFormalProperty = this.entityUtil.createFormalProperty((Namespace)umlContract, propertyName);
        LiteralString newLs = UMLFactory.eINSTANCE.createLiteralString();
        ValueSpecification vs = assumeFormalProperty.createSpecification("ConstraintSpec", null, newLs.eClass());
        ((LiteralString)vs).setValue("TRUE");
        assumeFormalProperty.setSpecification(vs);
        return assumeFormalProperty;
    }

    public void createGuaranteeToUmlContract(Class umlContract) {
        if (this.entityUtil.getOwner((Element)umlContract) != null) {
            Constraint guaranteeFormalProperty = this.createFormalPropertyInContract("Guarantee", umlContract);
            Contract contract = this.getContract(umlContract);
            contract.setGuarantee(this.entityUtil.getFormalProperty(guaranteeFormalProperty));
        }
    }

    public void createContractPropertyToUmlComponent(Class umlComponent, String propertyName) {
        Property newUmlProperty = umlComponent.createOwnedAttribute(propertyName, null);
        UMLUtils.applyStereotype((Element)newUmlProperty, (String)CONTRACT_PROP);
    }

    public Class getUmlContract(Class umlComponent, String extContractPropertyName) {
        String[] splittedPropertyName = extContractPropertyName.split(":");
        String contractPropertyName = splittedPropertyName[0].trim();
        return (Class)this.getUmlContractPropertyOfUmlComponent(umlComponent, contractPropertyName).getType();
    }

    public Property getPropertyOfUmlComponentWithContractPropertyType(Class umlComponent, String contractPropertyType) {
        EList attributes = umlComponent.getAttributes();
        Iterator itAttributes = attributes.iterator();
        Property umlContractProperty = null;
        boolean found = false;
        while (itAttributes.hasNext() && !found) {
            Property umlProperty = (Property)itAttributes.next();
            if (umlProperty.getType() == null || !umlProperty.getType().getName().equals(contractPropertyType) || umlProperty.getAppliedStereotype(CONTRACT_PROP) == null) continue;
            found = true;
            umlContractProperty = umlProperty;
        }
        if (umlContractProperty == null) {
            return null;
        }
        return umlContractProperty;
    }

    public ContractProperty getUmlContractPropertyOfUmlComponentFromContractPropertyType(Class umlComponent, String contractPropertyType) {
        Property umlProperty = this.getPropertyOfUmlComponentWithContractPropertyType(umlComponent, contractPropertyType);
        return this.getContractProperty(umlProperty);
    }

    public Property getUmlContractPropertyOfUmlComponent(Class umlComponent, String contractPropertyName) {
        EList attributes = umlComponent.getAttributes();
        Iterator itAttributes = attributes.iterator();
        Property umlContractProperty = null;
        boolean found = false;
        while (itAttributes.hasNext() && !found) {
            Property umlProperty = (Property)itAttributes.next();
            if (!umlProperty.getName().equals(contractPropertyName) || umlProperty.getAppliedStereotype(CONTRACT_PROP) == null) continue;
            found = true;
            umlContractProperty = umlProperty;
        }
        if (umlContractProperty == null) {
            return null;
        }
        return umlContractProperty;
    }

    public void assignUmlConstraintAssumptionToUmlContract(Constraint umlAssumeConstraint, Class umlContract) {
        FormalProperty assumeFormalProperty = this.entityUtil.getFormalProperty(umlAssumeConstraint);
        Contract contract = this.getContract(umlContract);
        contract.setAssume(assumeFormalProperty);
    }

    public void assignUmlConstraintGuaranteeToUmlContract(Constraint umlGuaranteeConstraint, Class umlContract) {
        FormalProperty guaranteeFormalProperty = this.entityUtil.getFormalProperty(umlGuaranteeConstraint);
        Contract contract = this.getContract(umlContract);
        contract.setGuarantee(guaranteeFormalProperty);
    }

    public void addContractRefinementToContractProperty(ContractProperty contractProperty, DataType umlRefinement) {
        Stereotype stereotype = umlRefinement.getAppliedStereotype(CONTRACT_REFINEMENT);
        ContractRefinement contractRefinement = (ContractRefinement)umlRefinement.getStereotypeApplication(stereotype);
        contractProperty.getRefinedBy().add((Object)contractRefinement);
    }

    public void setTextToGuaranteeOrCreateGuarantee(String formalPropertyText, Class umlContract) {
        FormalProperty guaranteeFormalProperty = this.getGuaranteeFromUmlContract(umlContract);
        if (guaranteeFormalProperty == null) {
            this.createGuaranteeToUmlContract(umlContract);
            guaranteeFormalProperty = this.getGuaranteeFromUmlContract(umlContract);
        }
        this.entityUtil.setTextInUMLConstraint(guaranteeFormalProperty.getBase_Constraint(), formalPropertyText, "OCRA");
    }

    public void setTextToAssumeOrCreateAssume(String formalPropertyText, Class umlContract) {
        FormalProperty assumptionFormalProperty = this.getAssumeFromUmlContract(umlContract);
        if (assumptionFormalProperty == null) {
            this.createAssumptionToUmlContract(umlContract);
            assumptionFormalProperty = this.getAssumeFromUmlContract(umlContract);
        }
        this.entityUtil.setTextInUMLConstraint(assumptionFormalProperty.getBase_Constraint(), formalPropertyText, "OCRA");
    }

    public EList<ContractProperty> getContractProperties(Class umlComponent) {
        BasicEList contractProperties = new BasicEList();
        for (Property umlProperty : umlComponent.getAttributes()) {
            if (!this.isContractProperty((Element)umlProperty)) continue;
            contractProperties.add((Object)this.getContractProperty(umlProperty));
        }
        return contractProperties;
    }

    public EList<Property> getContractPropertiesAsUMLProperties(Class umlComponent) {
        BasicEList contractProperties = new BasicEList();
        for (Property umlProperty : umlComponent.getAttributes()) {
            if (!this.isContractProperty((Element)umlProperty)) continue;
            contractProperties.add((Object)umlProperty);
        }
        return contractProperties;
    }

    public boolean isContractProperty(Element umlProperty) {
        return umlProperty instanceof Property && umlProperty.getAppliedStereotype(CONTRACT_PROP) != null;
    }

    public ContractProperty getContractProperty(Property umlContractProperty) {
        Stereotype contractPropertyStereotype = UMLUtil.getAppliedStereotype((Element)umlContractProperty, (String)CONTRACT_PROP, (boolean)false);
        return (ContractProperty)umlContractProperty.getStereotypeApplication(contractPropertyStereotype);
    }

    public void removeContractProperty(EList<ContractProperty> members, String qualifiedElement) {
        for (ContractProperty element : members) {
            if (!element.getBase_Property().getQualifiedName().equals(qualifiedElement)) continue;
            try {
                this.entityUtil.deleteElementInTheModel((NamedElement)element.getBase_Property());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            members.remove((Object)element);
            break;
        }
    }

    public void removeContractRefinement(EList<DataType> members, String qualifiedElement) {
        this.entityUtil.removeNamedElement(members, qualifiedElement);
    }

    public DataType getExistingUmlContractRefinement(Class owner, String refinementName) {
        return (DataType)owner.getNestedClassifier(refinementName);
    }
}

