/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.profile.chesscontract.DataTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContractStatus implements Enumerator
{
    NOT_VALIDATED(0, "notValidated", "notValidated"),
    VALIDATED(1, "validated", "validated"),
    NEEDS_RUNTIME_SUPPORT(2, "needsRuntimeSupport", "needsRuntimeSupport");

    public static final int NOT_VALIDATED_VALUE = 0;
    public static final int VALIDATED_VALUE = 1;
    public static final int NEEDS_RUNTIME_SUPPORT_VALUE = 2;
    private static final ContractStatus[] VALUES_ARRAY;
    public static final List<ContractStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContractStatus[]{NOT_VALIDATED, VALIDATED, NEEDS_RUNTIME_SUPPORT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContractStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractStatus get(int value) {
        switch (value) {
            case 0: {
                return NOT_VALIDATED;
            }
            case 1: {
                return VALIDATED;
            }
            case 2: {
                return NEEDS_RUNTIME_SUPPORT;
            }
        }
        return null;
    }

    private ContractStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

