/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Dependability.DependableComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VulnerabilityType implements Enumerator
{
    MISSING_DATA_INTEGRITY_SCHEMES(0, "missingDataIntegritySchemes", "missingDataIntegritySchemes"),
    INADEQUATE_ENCRYPTION_STRENGTH(1, "inadequateEncryptionStrength", "inadequateEncryptionStrength"),
    RESOURCE_ALLOCATION_WITHOUT_LIMITS(2, "resourceAllocationWithoutLimits", "resourceAllocationWithoutLimits");

    public static final int MISSING_DATA_INTEGRITY_SCHEMES_VALUE = 0;
    public static final int INADEQUATE_ENCRYPTION_STRENGTH_VALUE = 1;
    public static final int RESOURCE_ALLOCATION_WITHOUT_LIMITS_VALUE = 2;
    private static final VulnerabilityType[] VALUES_ARRAY;
    public static final List<VulnerabilityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VulnerabilityType[]{MISSING_DATA_INTEGRITY_SCHEMES, INADEQUATE_ENCRYPTION_STRENGTH, RESOURCE_ALLOCATION_WITHOUT_LIMITS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VulnerabilityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VulnerabilityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VulnerabilityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VulnerabilityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VulnerabilityType get(int value) {
        switch (value) {
            case 0: {
                return MISSING_DATA_INTEGRITY_SCHEMES;
            }
            case 1: {
                return INADEQUATE_ENCRYPTION_STRENGTH;
            }
            case 2: {
                return RESOURCE_ALLOCATION_WITHOUT_LIMITS;
            }
        }
        return null;
    }

    private VulnerabilityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

