/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.patterns.dialogs.PatternLabelProvider;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;
import org.polarsys.chess.patterns.utils.PatternUtils;

public class SelectDesignPatternDialog
extends TitleAreaDialog {
    private Model chessModel;
    private TableViewer availablePatterns;
    private Pattern selectedPattern;
    private Group patternIntentGroup;
    private Group patternProblemGroup;
    private Group patternSolutionGroup;
    private Group patternConsequencesGroup;
    private Group patternImplementationGroup;
    private Group patternAssumptionsGroup;
    private Group patternGuaranteesGroup;
    private StyledText patternIntent;
    private StyledText patternProblem;
    private StyledText patternSolution;
    private StyledText patternConsequences;
    private StyledText patternImplementation;
    private StyledText patternAssumptions;
    private StyledText patternGuarantees;
    private Group patternPreviewGroup;
    private Label imageLabel;
    private Image patternPreview;

    public SelectDesignPatternDialog(Shell shell, Model chessModel) {
        super(shell);
        this.chessModel = chessModel;
    }

    public void create() {
        this.setHelpAvailable(false);
        super.create();
        this.setTitle("Select a Design Pattern");
        this.setMessage("Select a design pattern from the list and click \"apply\" to apply it to the model ");
        this.getButton(0).setText("Apply");
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        GridData gdSelection = new GridData();
        gdSelection.widthHint = 400;
        gdSelection.heightHint = 200;
        gdSelection.grabExcessVerticalSpace = true;
        gdSelection.grabExcessHorizontalSpace = true;
        gdSelection.horizontalAlignment = 4;
        gdSelection.verticalAlignment = 4;
        gdSelection.horizontalSpan = 2;
        Group availablePatternsGroup = new Group(parent, 2048);
        availablePatternsGroup.setText("Available Patterns");
        availablePatternsGroup.setLayout((Layout)new GridLayout(1, false));
        availablePatternsGroup.setLayoutData((Object)gdSelection);
        this.availablePatterns = new TableViewer((Composite)availablePatternsGroup, 2048);
        GridData data = new GridData(1808);
        this.availablePatterns.getTable().setLayoutData((Object)data);
        this.availablePatterns.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.availablePatterns.setLabelProvider((IBaseLabelProvider)new PatternLabelProvider());
        this.availablePatterns.setInput((Object)this.getAvailablePatterns((Package)this.chessModel, new ArrayList<Pattern>()).toArray());
        availablePatternsGroup.pack();
        this.availablePatterns.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = SelectDesignPatternDialog.this.availablePatterns.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof Pattern) {
                    SelectDesignPatternDialog.this.selectedPattern = (Pattern)selected[0];
                    SelectDesignPatternDialog.this.updatePatternDescription(SelectDesignPatternDialog.this.selectedPattern);
                }
            }
        });
        GridData gdSingleHSpan = new GridData();
        gdSingleHSpan.widthHint = 400;
        gdSingleHSpan.heightHint = 200;
        gdSingleHSpan.grabExcessVerticalSpace = true;
        gdSingleHSpan.grabExcessHorizontalSpace = true;
        gdSingleHSpan.horizontalAlignment = 4;
        gdSingleHSpan.verticalAlignment = 4;
        GridData gdDoubleHSpan = new GridData();
        gdDoubleHSpan.widthHint = 400;
        gdDoubleHSpan.heightHint = 200;
        gdDoubleHSpan.grabExcessVerticalSpace = true;
        gdDoubleHSpan.grabExcessHorizontalSpace = true;
        gdDoubleHSpan.horizontalAlignment = 4;
        gdDoubleHSpan.verticalAlignment = 4;
        gdDoubleHSpan.horizontalSpan = 2;
        GridData gdDoubleHSpanPreview = new GridData();
        gdDoubleHSpanPreview.widthHint = 600;
        gdDoubleHSpanPreview.heightHint = 400;
        gdDoubleHSpanPreview.grabExcessVerticalSpace = true;
        gdDoubleHSpanPreview.grabExcessHorizontalSpace = true;
        gdDoubleHSpanPreview.horizontalAlignment = 4;
        gdDoubleHSpanPreview.verticalAlignment = 4;
        gdDoubleHSpanPreview.horizontalSpan = 2;
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 4;
        gdText.grabExcessHorizontalSpace = true;
        gdText.grabExcessVerticalSpace = true;
        gdText.heightHint = 200;
        this.patternIntentGroup = new Group(parent, 2048);
        this.patternIntentGroup.setText("Intent/Context");
        this.patternIntentGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternIntentGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternIntent = new StyledText((Composite)this.patternIntentGroup, 584);
        this.patternIntent.setLayoutData((Object)gdText);
        this.patternProblemGroup = new Group(parent, 2048);
        this.patternProblemGroup.setText("Problem");
        this.patternProblemGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternProblemGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternProblem = new StyledText((Composite)this.patternProblemGroup, 584);
        this.patternProblem.setLayoutData((Object)gdText);
        this.patternSolutionGroup = new Group(parent, 2048);
        this.patternSolutionGroup.setText("Solution/Pattern Structure");
        this.patternSolutionGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternSolutionGroup.setLayoutData((Object)gdDoubleHSpan);
        this.patternSolution = new StyledText((Composite)this.patternSolutionGroup, 584);
        this.patternSolution.setLayoutData((Object)gdText);
        this.patternConsequencesGroup = new Group(parent, 2048);
        this.patternConsequencesGroup.setText("Consequences");
        this.patternConsequencesGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternConsequencesGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternConsequences = new StyledText((Composite)this.patternConsequencesGroup, 584);
        this.patternConsequences.setLayoutData((Object)gdText);
        this.patternImplementationGroup = new Group(parent, 2048);
        this.patternImplementationGroup.setText("Implementation");
        this.patternImplementationGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternImplementationGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternImplementation = new StyledText((Composite)this.patternImplementationGroup, 584);
        this.patternImplementation.setLayoutData((Object)gdText);
        this.patternAssumptionsGroup = new Group(parent, 2048);
        this.patternAssumptionsGroup.setText("Pattern Assumptions");
        this.patternAssumptionsGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternAssumptionsGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternAssumptions = new StyledText((Composite)this.patternAssumptionsGroup, 584);
        this.patternAssumptions.setLayoutData((Object)gdText);
        this.patternGuaranteesGroup = new Group(parent, 2048);
        this.patternGuaranteesGroup.setText("Pattern Guarantees");
        this.patternGuaranteesGroup.setLayout((Layout)new GridLayout(1, false));
        this.patternGuaranteesGroup.setLayoutData((Object)gdSingleHSpan);
        this.patternGuarantees = new StyledText((Composite)this.patternGuaranteesGroup, 584);
        this.patternGuarantees.setLayoutData((Object)gdText);
        this.patternPreviewGroup = new Group(parent, 2048);
        this.patternPreviewGroup.setText("Pattern Preview");
        this.patternPreviewGroup.setLayout((Layout)new FillLayout());
        this.patternPreviewGroup.setLayoutData((Object)gdDoubleHSpanPreview);
        this.imageLabel = new Label((Composite)this.patternPreviewGroup, 0x1000000);
        this.imageLabel.setText("preview not available");
        return super.createDialogArea(parent);
    }

    protected void updatePatternDescription(Pattern selectedPattern) {
        this.patternIntent.setText(selectedPattern.getIntent() != null ? selectedPattern.getIntent() : "not available");
        this.patternProblem.setText(selectedPattern.getProblem() != null ? selectedPattern.getProblem() : "not available");
        this.patternSolution.setText(selectedPattern.getSolution() != null ? selectedPattern.getSolution() : "not available");
        this.patternConsequences.setText(selectedPattern.getConsequences() != null ? PatternUtils.StringListToString((List<String>)selectedPattern.getConsequences()) : "not available");
        this.patternImplementation.setText(selectedPattern.getImplementation() != null ? PatternUtils.StringListToString((List<String>)selectedPattern.getImplementation()) : "not available");
        this.patternAssumptions.setText(selectedPattern.getPatternAssumptions() != null ? PatternUtils.StringListToString((List<String>)selectedPattern.getPatternAssumptions()) : "not available");
        this.patternGuarantees.setText(selectedPattern.getPatternGuarantees() != null ? PatternUtils.StringListToString((List<String>)selectedPattern.getPatternGuarantees()) : "not available");
        Image image = PatternUtils.retrieveImageforPatternPreview(selectedPattern);
        if (image != null) {
            int width = this.imageLabel.getSize().x;
            int height = this.imageLabel.getSize().y;
            Image scaled = new Image((Device)Display.getDefault(), width, height);
            GC gc = new GC((Drawable)scaled);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
            gc.dispose();
            image.dispose();
            this.patternPreview = scaled;
            this.imageLabel.setImage(scaled);
        } else {
            this.imageLabel.setImage(null);
        }
    }

    private List<Pattern> getAvailablePatterns(Package pkg, List<Pattern> patternList) {
        for (Element el : pkg.getMembers()) {
            Pattern pattern;
            Stereotype stereo;
            if (el instanceof Collaboration && (stereo = el.getAppliedStereotype("PatternsProfile::Pattern")) != null && (pattern = (Pattern)el.getStereotypeApplication(stereo)) != null) {
                patternList.add(pattern);
            }
            if (!(el instanceof Package)) continue;
            this.getAvailablePatterns((Package)el, patternList);
        }
        return patternList;
    }

    protected boolean isResizable() {
        return true;
    }

    public Pattern getSelectedPattern() {
        return this.selectedPattern;
    }

    public Image getPatternPreview() {
        return this.patternPreview;
    }
}

