/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.patterns.apply;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.patterns.profile.PatternsProfile.Pattern;
import org.polarsys.chess.patterns.profile.PatternsProfile.PatternApplication;
import org.polarsys.chess.patterns.profile.PatternsProfile.PatternRole;
import org.polarsys.chess.patterns.profile.PatternsProfile.PatternsProfilePackage;
import org.polarsys.chess.patterns.utils.PatternUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class ApplyPattern {
    private static final String PATTERN_APPLICATION = "PatternsProfile::PatternApplication";
    private static final String PATTERN_ROLE = "PatternsProfile::PatternRole";
    private Map<NamedElement, NamedElement> mappings;
    private Class modelCtx;
    private Pattern pattern;

    public ApplyPattern(Map<NamedElement, NamedElement> mappings, Pattern pattern, Class modelCtx) {
        this.mappings = mappings;
        this.pattern = pattern;
        this.modelCtx = modelCtx;
    }

    public void apply() {
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)editor.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                Dependency dep;
                PatternRole pRole;
                Class mappedClass;
                Class patternClass;
                Profile patternsProfile;
                Model chessModel = ApplyPattern.this.modelCtx.getModel();
                if (chessModel.getProfileApplication(patternsProfile = UMLResourcesUtil.getProfile((EPackage)PatternsProfilePackage.eINSTANCE, (EObject)chessModel)) == null) {
                    PackageUtil.applyProfile((Package)chessModel, (Profile)patternsProfile, (boolean)false);
                }
                CollaborationUse collUse = UMLFactory.eINSTANCE.createCollaborationUse();
                collUse.setType(ApplyPattern.this.pattern.getBase_Collaboration());
                String name = ApplyPattern.this.pattern.getBase_Collaboration().getName();
                name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
                collUse.setName(String.valueOf(name) + "_Application");
                ApplyPattern.this.modelCtx.getCollaborationUses().add((Object)collUse);
                Stereotype stereo = UMLUtils.applyStereotype((Element)collUse, (String)ApplyPattern.PATTERN_APPLICATION);
                if (stereo != null) {
                    PatternApplication pAppl = (PatternApplication)collUse.getStereotypeApplication(stereo);
                    pAppl.setAppliedPattern(ApplyPattern.this.pattern.getPatternName());
                }
                HashMap<Object, Object> newMappings = new HashMap<Object, Object>();
                for (NamedElement nelem : ApplyPattern.this.mappings.keySet()) {
                    if (!(nelem instanceof Class)) continue;
                    Class mappedClass2 = (Class)ApplyPattern.this.mappings.get(nelem);
                    if (mappedClass2 == null) {
                        Package pkg = ApplyPattern.this.modelCtx.getNearestPackage();
                        mappedClass2 = UMLFactory.eINSTANCE.createClass();
                        mappedClass2.setName(nelem.getName());
                        pkg.getPackagedElements().add((Object)mappedClass2);
                        PatternUtils.applyStereotypes(nelem, (NamedElement)mappedClass2);
                        newMappings.put(nelem, mappedClass2);
                    }
                    if ((stereo = UMLUtils.applyStereotype((Element)mappedClass2, (String)ApplyPattern.PATTERN_ROLE)) != null) {
                        PatternRole pRole2 = (PatternRole)mappedClass2.getStereotypeApplication(stereo);
                        pRole2.setAppliedPattern(ApplyPattern.this.pattern.getPatternName());
                        pRole2.setMappedRole(nelem.getQualifiedName());
                    }
                    Dependency dep2 = UMLFactory.eINSTANCE.createDependency();
                    dep2.getSuppliers().add((Object)nelem);
                    dep2.getClients().add((Object)mappedClass2);
                    dep2.setName("rolebinding_" + nelem.getName() + "_" + mappedClass2.getName());
                    collUse.getRoleBindings().add((Object)dep2);
                }
                ApplyPattern.this.mappings.putAll(newMappings);
                newMappings.clear();
                for (NamedElement nelem : ApplyPattern.this.mappings.keySet()) {
                    if (!(nelem instanceof Port)) continue;
                    patternClass = (Class)nelem.getOwner();
                    mappedClass = (Class)ApplyPattern.this.mappings.get(patternClass);
                    Port mappedPort = (Port)ApplyPattern.this.mappings.get(nelem);
                    if (mappedPort == null) {
                        mappedPort = UMLFactory.eINSTANCE.createPort();
                        mappedPort.setName(nelem.getName());
                        mappedClass.getOwnedPorts().add((Object)mappedPort);
                        PatternUtils.applyStereotypes(nelem, (NamedElement)mappedPort);
                        newMappings.put(nelem, mappedPort);
                    }
                    if ((stereo = UMLUtils.applyStereotype((Element)mappedPort, (String)ApplyPattern.PATTERN_ROLE)) != null) {
                        pRole = (PatternRole)mappedPort.getStereotypeApplication(stereo);
                        pRole.setAppliedPattern(ApplyPattern.this.pattern.getPatternName());
                        pRole.setMappedRole(nelem.getQualifiedName());
                    }
                    dep = UMLFactory.eINSTANCE.createDependency();
                    dep.getSuppliers().add((Object)nelem);
                    dep.getClients().add((Object)mappedPort);
                    dep.setName("rolebinding_" + nelem.getName() + "_" + mappedPort.getName());
                    collUse.getRoleBindings().add((Object)dep);
                }
                ApplyPattern.this.mappings.putAll(newMappings);
                newMappings.clear();
                for (NamedElement nelem : ApplyPattern.this.mappings.keySet()) {
                    if (!(nelem instanceof Property) || nelem instanceof Port) continue;
                    patternClass = (Class)((Property)nelem).getType();
                    mappedClass = (Class)ApplyPattern.this.mappings.get(patternClass);
                    Property mappedProperty = (Property)ApplyPattern.this.mappings.get(nelem);
                    if (mappedProperty == null) {
                        mappedProperty = UMLFactory.eINSTANCE.createProperty();
                        if (mappedClass != null) {
                            mappedProperty.setType((Type)mappedClass);
                        }
                        mappedProperty.setName(nelem.getName());
                        mappedProperty.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                        ApplyPattern.this.modelCtx.getOwnedAttributes().add((Object)mappedProperty);
                        newMappings.put(nelem, mappedProperty);
                        Association association = UMLFactory.eINSTANCE.createAssociation();
                        Property prop = UMLFactory.eINSTANCE.createProperty();
                        prop.setType((Type)ApplyPattern.this.modelCtx);
                        prop.setOwningAssociation(association);
                        prop.setName(String.valueOf(ApplyPattern.this.modelCtx.getName().substring(0, 1).toLowerCase()) + ApplyPattern.this.modelCtx.getName().substring(1));
                        prop.setAggregation(AggregationKind.NONE_LITERAL);
                        association.getMemberEnds().add((Object)prop);
                        association.getMemberEnds().add((Object)mappedProperty);
                        association.setName("A_" + mappedProperty.getName() + "_" + prop.getName());
                        ApplyPattern.this.modelCtx.getNearestPackage().getPackagedElements().add((Object)association);
                    }
                    if ((stereo = UMLUtils.applyStereotype((Element)mappedProperty, (String)ApplyPattern.PATTERN_ROLE)) != null) {
                        pRole = (PatternRole)mappedProperty.getStereotypeApplication(stereo);
                        pRole.setAppliedPattern(ApplyPattern.this.pattern.getPatternName());
                        pRole.setMappedRole(nelem.getQualifiedName());
                    }
                    dep = UMLFactory.eINSTANCE.createDependency();
                    dep.getSuppliers().add((Object)nelem);
                    dep.getClients().add((Object)mappedProperty);
                    dep.setName("rolebinding_" + nelem.getName() + "_" + mappedProperty.getName());
                    collUse.getRoleBindings().add((Object)dep);
                }
                ApplyPattern.this.mappings.putAll(newMappings);
                newMappings.clear();
                for (NamedElement nelem : ApplyPattern.this.mappings.keySet()) {
                    Connector patternConnector;
                    if (!(nelem instanceof Connector) || (patternConnector = (Connector)nelem).getEnds().size() != 2) continue;
                    Port patternFirstPort = (Port)((ConnectorEnd)patternConnector.getEnds().get(0)).getRole();
                    Port patternSecondPort = (Port)((ConnectorEnd)patternConnector.getEnds().get(1)).getRole();
                    Property patternFirstProp = ((ConnectorEnd)patternConnector.getEnds().get(0)).getPartWithPort();
                    Property patternSecondProp = ((ConnectorEnd)patternConnector.getEnds().get(1)).getPartWithPort();
                    if (patternFirstPort == null || patternSecondPort == null || patternFirstProp == null || patternSecondProp == null) continue;
                    Connector mappedConnector = (Connector)ApplyPattern.this.mappings.get(patternConnector);
                    if (mappedConnector == null) {
                        mappedConnector = UMLFactory.eINSTANCE.createConnector();
                        mappedConnector.setName("c_" + patternFirstProp.getName() + "_" + patternFirstPort.getName() + "_" + patternSecondProp.getName() + "_" + patternSecondPort.getName());
                        ConnectorEnd firstEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                        firstEnd.setRole((ConnectableElement)((Port)ApplyPattern.this.mappings.get(patternFirstPort)));
                        firstEnd.setPartWithPort((Property)ApplyPattern.this.mappings.get(patternFirstProp));
                        ConnectorEnd secondEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                        secondEnd.setRole((ConnectableElement)((Port)ApplyPattern.this.mappings.get(patternSecondPort)));
                        secondEnd.setPartWithPort((Property)ApplyPattern.this.mappings.get(patternSecondProp));
                        mappedConnector.getEnds().add((Object)firstEnd);
                        mappedConnector.getEnds().add((Object)secondEnd);
                        ApplyPattern.this.modelCtx.getOwnedConnectors().add((Object)mappedConnector);
                        newMappings.put(patternConnector, mappedConnector);
                    }
                    if ((stereo = UMLUtils.applyStereotype((Element)mappedConnector, (String)ApplyPattern.PATTERN_ROLE)) != null) {
                        PatternRole pRole3 = (PatternRole)mappedConnector.getStereotypeApplication(stereo);
                        pRole3.setAppliedPattern(ApplyPattern.this.pattern.getPatternName());
                        pRole3.setMappedRole(nelem.getQualifiedName());
                    }
                    Dependency dep3 = UMLFactory.eINSTANCE.createDependency();
                    dep3.getSuppliers().add((Object)nelem);
                    dep3.getClients().add((Object)mappedConnector);
                    dep3.setName("rolebinding_" + patternConnector.getName() + "_" + mappedConnector.getName());
                    collUse.getRoleBindings().add((Object)dep3);
                }
                ApplyPattern.this.mappings.putAll(newMappings);
                newMappings.clear();
            }
        });
    }
}

