/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomRegionCompartmentEditPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StateMachine;
import org.polarsys.chess.diagramsCreator.actions.ShowBDDElementsAction;
import org.polarsys.chess.diagramsCreator.actions.ShowSMDElementsAction;

public class DiagramUtils {
    private static final String STMD = "PapyrusUMLStateMachineDiagram";
    private static final String BDD = "BlockDefinition";
    private static final String IBD = "InternalBlock";
    private static final Logger logger = Logger.getLogger(DiagramUtils.class);
    private static DiagramUtils diagramUtils;

    public static DiagramUtils getInstance() {
        if (diagramUtils == null) {
            diagramUtils = new DiagramUtils();
        }
        return diagramUtils;
    }

    public Command showElementIn(EObject elementToShow, DiagramEditor activeEditor, EditPart editPart, int position, List<EditPart> childrenList) {
        if (elementToShow instanceof Element) {
            DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
            ArrayList<Element> list = new ArrayList<Element>();
            list.add((Element)elementToShow);
            dropObjectsRequest.setObjects(list);
            dropObjectsRequest.setLocation(new Point(100 * position, 100 * position));
            Command commandDrop = editPart.getCommand((Request)dropObjectsRequest);
            boolean processChildren = false;
            if (commandDrop == null) {
                processChildren = true;
            } else {
                if (commandDrop.canExecute()) {
                    return commandDrop;
                }
                processChildren = true;
            }
            if (processChildren) {
                for (EditPart child : childrenList) {
                    Command commandDropChild;
                    if (!(child instanceof CustomRegionCompartmentEditPart) || (commandDropChild = child.getCommand((Request)dropObjectsRequest)) == null || !commandDropChild.canExecute()) continue;
                    return commandDropChild;
                }
            }
        }
        return null;
    }

    public Command showElementsIn(ArrayList<EObject> elementsToDisplay, DiagramEditor activeEditor, EditPart editPart, List<EditPart> childrenList, Point pos) {
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        ArrayList<Element> list = new ArrayList<Element>();
        for (EObject elementToShow : elementsToDisplay) {
            if (!(elementToShow instanceof Element)) continue;
            list.add((Element)elementToShow);
        }
        dropObjectsRequest.setObjects(list);
        dropObjectsRequest.setLocation(pos);
        Command commandDrop = editPart.getCommand((Request)dropObjectsRequest);
        boolean processChildren = false;
        if (commandDrop == null) {
            processChildren = true;
        } else {
            if (commandDrop.canExecute()) {
                return commandDrop;
            }
            processChildren = true;
        }
        if (processChildren) {
            for (EditPart child : childrenList) {
                Command commandDropChild;
                if (!(child instanceof EditPart) || (commandDropChild = child.getCommand((Request)dropObjectsRequest)) == null || !commandDropChild.canExecute()) continue;
                return commandDropChild;
            }
        }
        return null;
    }

    public List<EditPart> findAllChildren(EditPart root) {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        list.addAll(root.getChildren());
        for (Object editPart : root.getChildren()) {
            if (!(editPart instanceof EditPart)) continue;
            list.addAll(this.findAllChildren((EditPart)editPart));
        }
        return list;
    }

    public void createOrRefreshStateMachineDiagram(Diagram stateMachineDiagram, StateMachine stateMachine, boolean rearrangeDiagramLayout, ExecutionEvent event) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor descriptor = window.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.papyrus.infra.core.perspective");
        window.getActivePage().setPerspective(descriptor);
        ShowSMDElementsAction smdAction = ShowSMDElementsAction.getInstance();
        if (stateMachineDiagram != null) {
            smdAction.refreshDiagram(stateMachineDiagram);
        } else {
            stateMachineDiagram = smdAction.addSMD((Class)stateMachine);
            smdAction.populateDiagram(stateMachineDiagram);
        }
        if (rearrangeDiagramLayout) {
            this.rearrangeDiagramLayout(event);
        }
    }

    public void createOrRefreshBDDDiagramByReferenceWithEmptyBlocks(Diagram blockDefinitionDiagram, Package pkg, ExecutionEvent event, EList<Element> elementsByRef, boolean rearrangeDiagramLayout) throws Exception {
        ShowBDDElementsAction bddAction = ShowBDDElementsAction.getInstance();
        bddAction.setDisplayableElement(new HashSet<ShowBDDElementsAction.DisplayableElement>());
        if (blockDefinitionDiagram != null) {
            bddAction.refreshDiagram(blockDefinitionDiagram);
        } else {
            try {
                blockDefinitionDiagram = bddAction.addBDD(pkg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bddAction.populateDiagramByReference(blockDefinitionDiagram, elementsByRef);
        }
        if (rearrangeDiagramLayout) {
            this.rearrangeDiagramLayout(event, this.getParams());
        }
    }

    public void createOrRefreshBDDDiagramByReference(Diagram blockDefinitionDiagram, Package pkg, ExecutionEvent event, EList<Element> elementsByRef, boolean rearrangeDiagramLayout, Set<ShowBDDElementsAction.DisplayableElement> displayableElements) {
        ShowBDDElementsAction bddAction = ShowBDDElementsAction.getInstance();
        bddAction.setDisplayableElement(displayableElements);
        if (blockDefinitionDiagram != null) {
            bddAction.refreshDiagram(blockDefinitionDiagram);
        } else {
            try {
                blockDefinitionDiagram = bddAction.addBDD(pkg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bddAction.populateDiagramByReference(blockDefinitionDiagram, elementsByRef);
        }
        if (rearrangeDiagramLayout) {
            this.rearrangeDiagramLayout(event, this.getParams());
        }
    }

    public void createOrRefreshBDDDiagram(Diagram blockDefinitionDiagram, Package pkg, ExecutionEvent event, boolean rearrangeDiagramLayout) throws Exception {
        this.createOrRefreshBDD(blockDefinitionDiagram, pkg);
        if (rearrangeDiagramLayout) {
            this.rearrangeDiagramLayout(event);
        }
    }

    public void createOrRefreshBDDDiagram(Diagram blockDefinitionDiagram, Package pkg, ExecutionEvent event, boolean rearrangeDiagramLayout, DiagramLayoutEngine.Parameters param) throws Exception {
        this.createOrRefreshBDD(blockDefinitionDiagram, pkg);
        if (rearrangeDiagramLayout) {
            this.rearrangeDiagramLayout(event, param);
        }
    }

    private void createOrRefreshBDD(Diagram blockDefinitionDiagram, Package pkg) {
        ShowBDDElementsAction bddAction = ShowBDDElementsAction.getInstance();
        HashSet<ShowBDDElementsAction.DisplayableElement> elementsToDisplay = new HashSet<ShowBDDElementsAction.DisplayableElement>();
        elementsToDisplay.add(ShowBDDElementsAction.DisplayableElement.OPERATION);
        elementsToDisplay.add(ShowBDDElementsAction.DisplayableElement.PROPERTY);
        bddAction.setDisplayableElement(elementsToDisplay);
        if (blockDefinitionDiagram != null) {
            bddAction.refreshDiagram(blockDefinitionDiagram);
        } else {
            try {
                logger.debug((Object)("pkg.eResource(): " + pkg.eResource()));
                blockDefinitionDiagram = bddAction.addBDD(pkg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bddAction.populateDiagram(blockDefinitionDiagram);
        }
    }

    public void rearrangeDiagramLayout(ExecutionEvent event) {
        this.rearrangeDiagramLayout(event, null);
    }

    public void rearrangeDiagramLayout(ExecutionEvent event, DiagramLayoutEngine.Parameters params) {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IEditorPart nestedEditor = null;
        if (editorPart instanceof IMultiDiagramEditor) {
            nestedEditor = ((IMultiDiagramEditor)editorPart).getActiveEditor();
        }
        if (nestedEditor instanceof DiagramEditor) {
            Object diagramPart = null;
            if (params == null) {
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)nestedEditor, diagramPart, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)editorPart, diagramPart, (DiagramLayoutEngine.Parameters)params);
            }
        }
    }

    private DiagramLayoutEngine.Parameters getParams() {
        DiagramLayoutEngine.Parameters params = new DiagramLayoutEngine.Parameters();
        params.getGlobalSettings().setProperty(CoreOptions.ANIMATE, (Object)true).setProperty(CoreOptions.LAYOUT_ANCESTORS, (Object)false).setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector(300.0, 300.0)).setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.minimumSize()).setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN).setProperty(CoreOptions.NODE_SIZE_OPTIONS, EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE)).setProperty(CoreOptions.PROGRESS_BAR, (Object)false).setProperty(CoreOptions.ALGORITHM, (Object)"org.eclipse.elk.layered.layered");
        params.addLayoutRun().configure(ElkNode.class).setProperty(LayeredOptions.SPACING_NODE_NODE, (Object)10.0).setProperty(LayeredOptions.DIRECTION, (Object)Direction.DOWN).setProperty(LayeredOptions.EDGE_THICKNESS, (Object)10.0).setProperty(LayeredOptions.LAYERING_STRATEGY, (Object)LayeringStrategy.NETWORK_SIMPLEX).setProperty(LayeredOptions.NODE_SIZE_MINIMUM, (Object)new KVector(150.0, 150.0)).setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, (Object)SizeConstraint.minimumSize()).setProperty(LayeredOptions.NODE_SIZE_OPTIONS, EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE));
        return params;
    }

    public void createOrUpdateBDDClassesAndTypesDiagrams(ExecutionEvent event, Package classesPkg, Package typesPkg, boolean arrangeLayout) throws Exception {
        Collection<Diagram> diagrams = this.getDiagrams();
        Diagram classesBlockDefinitionDiagram = this.getBDD(diagrams, (EObject)classesPkg);
        Diagram typesBlockDefinitionDiagram = this.getBDD(diagrams, (EObject)typesPkg);
        this.createOrRefreshBDDDiagram(classesBlockDefinitionDiagram, classesPkg, event, arrangeLayout);
        this.createOrRefreshBDDDiagram(typesBlockDefinitionDiagram, typesPkg, event, arrangeLayout);
    }

    public void createOrUpdateBDDDiagramsByReference(ExecutionEvent event, List<Package> packages, List<EList<Element>> elementsByRefList, Set<ShowBDDElementsAction.DisplayableElement> displayableElements, boolean arrangeLayout) {
        Collection<Diagram> diagrams = this.getDiagrams();
        int i = 0;
        while (i < packages.size()) {
            Package pkg = packages.get(i);
            Diagram diagram = this.getBDD(diagrams, (EObject)pkg);
            if (elementsByRefList.get(i).size() != 0) {
                this.createOrRefreshBDDDiagramByReference(diagram, pkg, event, elementsByRefList.get(i), arrangeLayout, displayableElements);
            }
            ++i;
        }
    }

    public void createOrUpdateBDDClassesAndTypesDiagrams2(ExecutionEvent event, Package classesPkg, Package typesPkg) {
        ShowBDDElementsAction bddAction = ShowBDDElementsAction.getInstance();
        Collection<Diagram> diagrams = this.getDiagrams();
        Diagram classesBlockDefinitionDiagram = this.getBDD(diagrams, (EObject)classesPkg);
        Diagram typesBlockDefinitionDiagram = this.getBDD(diagrams, (EObject)typesPkg);
        HashSet<ShowBDDElementsAction.DisplayableElement> elementsToDisplay = new HashSet<ShowBDDElementsAction.DisplayableElement>();
        elementsToDisplay.add(ShowBDDElementsAction.DisplayableElement.OPERATION);
        elementsToDisplay.add(ShowBDDElementsAction.DisplayableElement.PROPERTY);
        bddAction.setDisplayableElement(elementsToDisplay);
        if (typesBlockDefinitionDiagram != null) {
            bddAction.refreshDiagram(typesBlockDefinitionDiagram);
        } else {
            try {
                typesBlockDefinitionDiagram = bddAction.addBDD(typesPkg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bddAction.populateDiagram(typesBlockDefinitionDiagram);
        }
        new LayoutThread(event).start();
        if (classesBlockDefinitionDiagram != null) {
            bddAction.refreshDiagram(classesBlockDefinitionDiagram);
        } else {
            try {
                classesBlockDefinitionDiagram = bddAction.addBDD(classesPkg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bddAction.populateDiagram(classesBlockDefinitionDiagram);
        }
        new LayoutThread(event).start();
    }

    public Diagram getBDD(Collection<Diagram> diagrams, EObject element) {
        for (Diagram diagram : diagrams) {
            if (!this.isBDD(diagram) || diagram.getElement() != element) continue;
            return diagram;
        }
        return null;
    }

    public boolean isBDD(Diagram diagram) {
        return diagram.getType().equals(BDD);
    }

    public Diagram getSMD(Collection<Diagram> diagrams, EObject element) {
        for (Diagram diagram : diagrams) {
            if (!diagram.getType().equals(STMD) || diagram.getElement() != element) continue;
            return diagram;
        }
        return null;
    }

    public void openAndLayoutDiagram(ExecutionEvent event, Diagram diagram) throws Exception {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        OpenElementService openService = (OpenElementService)((IMultiDiagramEditor)editorPart).getServicesRegistry().getService(OpenElementService.class);
        openService.openElement((EObject)diagram);
        Object diagramPart = null;
        DiagramLayoutEngine.invokeLayout((IWorkbenchPart)editorPart, diagramPart, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    public Collection<Diagram> getDiagrams() {
        NotationModel notationModel = NotationUtils.getNotationModel();
        Set<Diagram> diagrams = this.getChessDiagrams(notationModel.getResources());
        return diagrams;
    }

    public Set<Diagram> getDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                if (!(element instanceof Diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    private Set<Diagram> getChessDiagrams(Set<Resource> resources) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Resource current : resources) {
            for (EObject element : current.getContents()) {
                Diagram diagram;
                if (!(element instanceof Diagram) || !this.isBDD(diagram = (Diagram)element) && !this.isIBD(diagram) && !this.isSMD(diagram)) continue;
                diagrams.add((Diagram)element);
            }
        }
        return diagrams;
    }

    public boolean isIBD(Diagram diagram) {
        return diagram.getType().compareTo(IBD) == 0;
    }

    public boolean isSMD(Diagram diagram) {
        return diagram.getType().compareTo(STMD) == 0;
    }

    private class LayoutThread
    extends Thread {
        IEditorPart editorPart;

        public LayoutThread(ExecutionEvent event) {
            this.editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        }

        @Override
        public void run() {
            if (this.editorPart instanceof IMultiDiagramEditor) {
                this.editorPart = ((IMultiDiagramEditor)this.editorPart).getActiveEditor();
            }
            if (this.editorPart instanceof DiagramEditor) {
                Object diagramPart = null;
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)this.editorPart, diagramPart, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                DiagramLayoutEngine.invokeLayout((IWorkbenchPart)this.editorPart, diagramPart, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
        }
    }
}

