/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.core.model;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class ChessSystemModel
implements AbstractSystemModel {
    private static ChessSystemModel chessToOCRAModelRunner;
    private ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private EntityUtil entityUtil = EntityUtil.getInstance();

    public static ChessSystemModel getInstance() {
        if (chessToOCRAModelRunner == null) {
            chessToOCRAModelRunner = new ChessSystemModel();
        }
        return chessToOCRAModelRunner;
    }

    public String[] getLowerUpperBoundsForRangeType(Object rangeType) {
        return this.entityUtil.getLowerUpperBoundsForRangeType((Type)rangeType);
    }

    public String[] getValuesForEnumeratorType(Object enumTypePort) {
        return this.entityUtil.getValuesForEnumeratorType((Type)enumTypePort);
    }

    public String getComponentTypeName(Object component) {
        if (this.entityUtil.isBlock((Element)component)) {
            return this.entityUtil.getComponentName((Element)component);
        }
        return null;
    }

    public boolean isRangeType(Object type) {
        return this.entityUtil.isRangeType((Type)type);
    }

    public EList<?> getContractsOfComponent(Object component) {
        return this.contractEntityUtil.getContractProperties((Class)component);
    }

    public String getComponentInstanceTypeName(Object component) {
        if (this.entityUtil.isBlock((Element)component)) {
            return "";
        }
        if (this.entityUtil.isComponentInstance((Element)component)) {
            return ((Class)((Property)component).getType()).getName();
        }
        return null;
    }

    public String getPortName(Object port) {
        return this.entityUtil.getPortName((Port)port);
    }

    public String getConnectorEndName(Object connector) {
        if (((ConnectorEnd)connector).getRole() != null) {
            return ((ConnectorEnd)connector).getRole().getName();
        }
        return null;
    }

    public String getContractDefinitionsText(Object component) throws Exception {
        EList listCp = null;
        if (this.entityUtil.isComponentInstance((Element)component)) {
            Class componentType = (Class)((Property)component).getType();
            listCp = this.contractEntityUtil.getContractPropertiesAsUMLProperties(componentType);
        } else if (this.entityUtil.isBlock((Element)component)) {
            listCp = this.contractEntityUtil.getContractPropertiesAsUMLProperties((Class)component);
        }
        String definitions = "";
        if (listCp != null) {
            for (Property contractProperty : listCp) {
                String currContract = this.contractEntityUtil.convertContractPropertyInStr(contractProperty);
                definitions = definitions.concat(currContract);
            }
        }
        return definitions;
    }

    public String getFormulaConstraintText(Object formulaConstraint) {
        return ((Constraint)formulaConstraint).getSpecification().stringValue();
    }

    public EList<Constraint> getFormulaConstraints(Object component) {
        return this.entityUtil.getDelegationConstraintsAsUMLConstraints((Element)component);
    }

    public EList<Port> getNonStaticInputPorts(Object component) {
        return new BasicEList((Collection)this.entityUtil.getUmlPorts((Element)component, 0, false));
    }

    public EList<?> getNonStaticPorts(Object component) {
        return this.entityUtil.getUmlPorts((Element)component, false);
    }

    public String getUninterpretedFunctionName(Object function) {
        if (function instanceof FunctionBehavior) {
            return this.entityUtil.getUmlFunctionBehaviorName((FunctionBehavior)function);
        }
        return null;
    }

    public EList<Port> getNonStaticOutputPorts(Object component) {
        int direction = 1;
        return new BasicEList((Collection)this.entityUtil.getUmlPorts((Element)component, direction, false));
    }

    public EList<Port> getNonStaticGenericPorts(Object component) {
        int direction = 2;
        return new BasicEList((Collection)this.entityUtil.getUmlPorts((Element)component, direction, false));
    }

    public Object getConnectorSource(Object connection) throws Exception {
        ConnectorEnd source = (ConnectorEnd)((Connector)connection).getEnds().get(0);
        ConnectorEnd target = (ConnectorEnd)((Connector)connection).getEnds().get(1);
        Property sourceOwner = source.getPartWithPort();
        Property targetOwner = target.getPartWithPort();
        ConnectableElement sourcePort = source.getRole();
        ConnectableElement targetPort = target.getRole();
        if (sourcePort == null) {
            throw new Exception("The connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have a source port");
        }
        if (targetPort == null) {
            throw new Exception("The connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have a target port");
        }
        Integer sourceDir = this.entityUtil.getPortDirection((Element)sourcePort);
        Integer targetDir = this.entityUtil.getPortDirection((Element)targetPort);
        if (sourceDir == null) {
            throw new Exception("The source port of the connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have assiociated a port");
        }
        if (targetDir == null) {
            throw new Exception("The target port of the connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have assiociated a port");
        }
        if (sourceOwner == null && sourceDir == 0) {
            return source;
        }
        if (targetOwner == null && targetDir == 0) {
            return target;
        }
        if (sourceOwner != null && sourceDir == 1) {
            return source;
        }
        if (targetOwner != null && targetDir == 1) {
            return target;
        }
        return ((Connector)connection).getEnds().get(0);
    }

    public Object getConnectorTarget(Object connection) throws Exception {
        ConnectorEnd source = (ConnectorEnd)((Connector)connection).getEnds().get(0);
        ConnectorEnd target = (ConnectorEnd)((Connector)connection).getEnds().get(1);
        Property sourceOwner = source.getPartWithPort();
        Property targetOwner = target.getPartWithPort();
        ConnectableElement sourcePort = source.getRole();
        ConnectableElement targetPort = target.getRole();
        if (sourcePort == null) {
            throw new Exception("The connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have a source port");
        }
        if (targetPort == null) {
            throw new Exception("The connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have a target port");
        }
        Integer sourceDir = this.entityUtil.getPortDirection((Element)sourcePort);
        Integer targetDir = this.entityUtil.getPortDirection((Element)targetPort);
        if (sourceDir == null) {
            throw new Exception("The source port of the connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have assiociated a port");
        }
        if (targetDir == null) {
            throw new Exception("The target port of the connection '" + ((Connector)connection).getName() + "' of the component '" + this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)((Connector)connection))) + "' does not have assiociated a port");
        }
        if (sourceOwner == null && sourceDir == 1) {
            return source;
        }
        if (targetOwner == null && targetDir == 1) {
            return target;
        }
        if (sourceOwner != null && sourceDir == 0) {
            return source;
        }
        if (targetOwner != null && targetDir == 0) {
            return target;
        }
        return ((Connector)connection).getEnds().get(1);
    }

    public EList<Connector> getConnectionsPorts(Object component) {
        if (this.entityUtil.isBlock((Element)component)) {
            return ((Class)component).getOwnedConnectors();
        }
        if (this.entityUtil.isComponentInstance((Element)component)) {
            return ((Class)((Property)component).getType()).getOwnedConnectors();
        }
        return null;
    }

    public Object getConnectorEndOwner(Object connectorEnd) {
        if (connectorEnd != null) {
            return ((ConnectorEnd)connectorEnd).getPartWithPort();
        }
        return null;
    }

    public String getComponentInstanceName(Object component) {
        if (this.entityUtil.isComponentInstance((Element)component)) {
            return ((Property)component).getName().replaceAll("::", "_");
        }
        return null;
    }

    public Object getContract(Object component, String contractName) {
        Property property;
        if (this.entityUtil.isComponentInstance((Element)component)) {
            Class compClass = (Class)((Property)component).getType();
            return this.contractEntityUtil.getContractProperty(this.contractEntityUtil.getPropertyOfUmlComponentWithContractPropertyType(compClass, contractName));
        }
        if (this.entityUtil.isBlock((Element)component) && (property = this.contractEntityUtil.getPropertyOfUmlComponentWithContractPropertyType((Class)component, contractName)) != null) {
            return this.contractEntityUtil.getContractProperty(property);
        }
        return null;
    }

    public String getContractInstanceName(Object contractProperty) throws Exception {
        if (contractProperty instanceof ContractProperty) {
            Type contractType = ((ContractProperty)contractProperty).getBase_Property().getType();
            if (contractType != null) {
                return ((ContractProperty)contractProperty).getBase_Property().getType().getName();
            }
            throw new Exception("The ContractProperty \"" + ((ContractProperty)contractProperty).getBase_Property().getName() + "\" does not have a type.");
        }
        throw new Exception("The element \"" + contractProperty + "\" is not a contract property.");
    }

    public String getComponentName(Object component) {
        return this.entityUtil.getComponentName((Element)component);
    }

    public Object getComponentType(Object component) {
        if (this.entityUtil.isComponentInstance((Element)component)) {
            return this.entityUtil.getUmlType((Property)component);
        }
        if (component instanceof Class) {
            return component;
        }
        return null;
    }

    public String getContractQualifiedName(Object contract) {
        return this.contractEntityUtil.getContractQualifiedName((Class)contract);
    }

    public EList<ContractRefinement> getContractRefinements(Object parentContract) {
        return ((ContractProperty)parentContract).getRefinedBy();
    }

    public String getContractRefinementName(Object contractRefinement) {
        return ((ContractRefinement)contractRefinement).getBase_DataType().getName();
    }

    public Object getComponentInstanceOfContractRefinement(Object contractRefinement) {
        return ((ContractRefinement)contractRefinement).getInstance();
    }

    public Object getContractInstanceOfContractRefinement(Object contractRefinement) {
        return ((ContractRefinement)contractRefinement).getContract();
    }

    public EList<Property> getSubComponentsInstances(Object component) {
        if (this.entityUtil.isBlock((Element)component)) {
            return new BasicEList((Collection)this.entityUtil.getSubComponentsInstances((Class)component));
        }
        if (this.entityUtil.isComponentInstance((Element)component)) {
            return new BasicEList((Collection)this.entityUtil.getSubComponentsInstances((Class)((Property)component).getType()));
        }
        return null;
    }

    public boolean isContractInstanceOwnerEqualToComponent(Object contract, Object component) {
        Type componentType;
        Element contractOwner = this.entityUtil.getOwner((Element)((ContractProperty)contract).getBase_Property());
        return contractOwner == (componentType = ((Property)component).getType());
    }

    public String getOwnerName(Object element) {
        return this.entityUtil.getComponentName(this.entityUtil.getOwner((Element)element));
    }

    public boolean isInputPort(Object port) {
        return this.entityUtil.isInputPort((Element)((Port)port));
    }

    public boolean isOutputPort(Object port) {
        return this.entityUtil.isOutputPort((Element)((Port)port));
    }

    public boolean isInOutPort(Object port) {
        return this.entityUtil.isInOutPort((Element)((Port)port));
    }

    public String getConstraintQualifiedName(Object constraint) {
        return this.entityUtil.getQualifiedName((NamedElement)constraint);
    }

    public String getComponentQualifiedName(Object component) {
        return this.entityUtil.getQualifiedName((NamedElement)component);
    }

    public EList<?> getStaticPorts(Object component) {
        return this.entityUtil.getUmlPorts((Element)component, true);
    }

    public String getInterfaceAssertionBody(Object interfaceAssertion, String language) {
        return this.entityUtil.getConstraintBodyStr((Constraint)interfaceAssertion, language);
    }

    public EList<?> getInterfaceAssertions(Object component) {
        return this.entityUtil.getInterfaceFormalPropertiesAsConstraints((Element)component);
    }

    public String getInterfaceAssertionName(Object interfaceAssertion) {
        return this.entityUtil.getConstraintName((Constraint)interfaceAssertion);
    }

    public String getRefinementAssertionName(Object refinementAssertion) {
        return this.entityUtil.getConstraintName((Constraint)refinementAssertion);
    }

    public String getRefinementAssertionBody(Object refinementAssertion, String language) {
        return this.entityUtil.getConstraintBodyStr((Constraint)refinementAssertion, language);
    }

    public EList<?> getRefinementAssertions(Object component) {
        return this.entityUtil.getRefinementFormalPropertiesAsConstraints((Element)component);
    }

    public String getAssertionQualifiedName(Object formalProperty) {
        return this.entityUtil.getConstraintQualifiedName((Constraint)formalProperty);
    }

    public String getDefineName(Object define) {
        return this.entityUtil.getConstraintName((Constraint)define);
    }

    public String getDefineBody(Object define, String language) {
        return this.entityUtil.getConstraintBodyStr((Constraint)define, language);
    }

    public boolean isAssertion(Object constraint) {
        return this.entityUtil.isFormalProperty((Element)((Constraint)constraint));
    }

    public boolean isInterfaceAssertion(Object constraint) {
        return this.entityUtil.isInterfaceFormalProperty((Element)((Constraint)constraint));
    }

    public EList<String> getEnumValues(Object component) {
        return this.entityUtil.getEnumValuesFromComponentAttributes((Element)component);
    }

    public EList<?> getDefines(Object component) {
        return this.entityUtil.getMacroDefinitionsAsUMLConstraints((Element)component);
    }

    public boolean isDefine(Object element) {
        return this.entityUtil.isMacroDefinition((Element)element);
    }

    public Object getNearestOwnerComponent(Object element) {
        Element owner = this.entityUtil.getOwner((Element)element);
        if (!(owner instanceof Class)) {
            return null;
        }
        if (this.contractEntityUtil.isContract(owner)) {
            owner = (Class)this.entityUtil.getOwner(owner);
        }
        return owner;
    }

    public String[] getSubComponentsName(Object component) {
        return this.entityUtil.getSubComponentsName((Class)component);
    }

    public Object getSubComponent(Object component, String subCompName) {
        return this.entityUtil.getSubComponent((Element)component, subCompName);
    }

    public EList<?> getUninterpretedFunctions(Object component) {
        return this.entityUtil.getUmlFunctionBehaviors((Element)component);
    }

    public EList<String> getEnumValuesFromAttributes(Object component) {
        return this.entityUtil.getEnumValuesFromComponentAttributes((Element)component);
    }

    public Object getPortType(Object attribute) {
        return this.entityUtil.getAttributeType((Property)attribute);
    }

    public boolean isBooleanType(Object type) {
        return this.entityUtil.isBooleanType((Type)type);
    }

    public boolean isContinuousType(Object type) {
        return this.entityUtil.isContinuousType((Type)type);
    }

    public boolean isEnumType(Object type) {
        return this.entityUtil.isEnumerationType((Type)type);
    }

    public boolean isEventType(Object type) {
        return this.entityUtil.isEventType((Type)type);
    }

    public boolean isIntType(Object type) {
        return this.entityUtil.isIntegerType((Type)type);
    }

    public boolean isNumberType(Object type) {
        return false;
    }

    public boolean isRealType(Object type) {
        return this.entityUtil.isRealType((Type)type);
    }

    public boolean isWordType(Object type) {
        return false;
    }

    public Object getUninterpretedFunctionOutputType(Object uninterpretedFunction) {
        return this.entityUtil.getUmlFunctionBehaviorOutputType((FunctionBehavior)uninterpretedFunction);
    }

    public EList<?> getUninterpretedFunctionInputTypes(Object uninterpretedFunction) {
        return this.entityUtil.getUmlFunctionBehaviorInputTypes((FunctionBehavior)uninterpretedFunction);
    }

    public boolean isRefinementAssertion(Object formalProperty) {
        return this.entityUtil.isRefinementFormalProperty((Element)formalProperty);
    }

    public String[] getComponentInstanceMultiplicityBoundaries(Object component) throws Exception {
        return this.entityUtil.getComponentInstanceMultiplicity((Property)component);
    }

    public String[] getPortMultiplicityBoundaries(Object port) {
        return this.entityUtil.getAttributeMultiplicity((MultiplicityElement)((Property)port));
    }

    public String getPortTypeAsStringName(Object activePackage, String componentName, String portName) {
        if (activePackage instanceof Package) {
            Package pkg = (Package)activePackage;
            Class element = (Class)pkg.getOwnedMember(componentName, false, UMLFactory.eINSTANCE.createClass().eClass());
            Port port = element.getOwnedPort(portName, null);
            return port.getType().getName();
        }
        return null;
    }

    public EList<?> getParameterAssumptions(Object component) {
        return this.entityUtil.getParameterAssumptionsAsConstraintsUml((Element)component);
    }

    public String getParameterAssumptionsBody(Object parameterAssumption, String language) {
        return this.entityUtil.getConstraintBodyStr((Constraint)parameterAssumption, language);
    }

    public boolean isParameterAssumptions(Object element) {
        return this.entityUtil.isParameterAssumptions((Element)element);
    }

    public String[] getUninterpretedFunctionOutputMultiplicity(Object uninterpretedFunction) {
        return this.entityUtil.getUmlFunctionBehaviorOutputMultiplicity((FunctionBehavior)uninterpretedFunction);
    }

    public EList<String[]> getUninterpretedFunctionInputMultiplicities(Object uninterpretedFunction) {
        return this.entityUtil.getUmlFunctionBehaviorInputMultiplicities((FunctionBehavior)uninterpretedFunction);
    }

    public String[] getComponentInstanceRangeOfContractRefinement(Object contractRefinement) {
        String lower = ((ContractRefinement)contractRefinement).getLowerIndexOfInstance();
        String upper = ((ContractRefinement)contractRefinement).getUpperIndexOfInstance();
        return new String[]{lower, upper};
    }

    public EList<?> getLocalAttributes(Object component) {
        return this.entityUtil.getLocalProperties((Element)component);
    }

    public String getLocalAttributeName(Object attribute) {
        return this.entityUtil.getLocalPropertyName((Property)attribute);
    }

    public String getLocalAttributeType(Object attribute) {
        return this.entityUtil.getLocalPropertyType((Property)attribute);
    }

    public String getAnalysisContextName(Object ctx) {
        return ((AnalysisContextElement)ctx).getBase_Component().getQualifiedName();
    }

    public String getModelCheckingAnalysisContextType(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"check_type");
    }

    public String getModelCheckingAnalysisContextProperty(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"property");
    }

    public String getValidationPropertyAnalysisContextType(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"check_type");
    }

    public String getValidationPropertyAnalysisContextExpression(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"property");
    }

    public String getValidationPropertyAnalysisContextComponent(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"selected_components");
    }

    public String[] getValidationPropertyAnalysisContextSelectedProperties(Object ctx) {
        return StringArrayUtil.getConditionValue((EList)((AnalysisContextElement)ctx).getConditions(), (String)"selected_properties").split(",");
    }

    public String getInstantiatedArchitectureConfigurationName(Object instantiatedArchitectureConfiguration) {
        return this.entityUtil.getInstantiatedArchitectureConfigurationName((InstantiatedArchitectureConfiguration)instantiatedArchitectureConfiguration);
    }

    public EList<String> getParametersListFromInstantiatedArchitectureConfiguration(Object instantiatedArchitectureConfiguration) {
        return this.entityUtil.getParametersListFromInstantiatedArchitectureConfiguration((InstantiatedArchitectureConfiguration)instantiatedArchitectureConfiguration);
    }

    public EList<?> getOperations(Object component) {
        return this.entityUtil.getUmlOperations((Element)component);
    }

    public String getOperationName(Object operation) {
        if (operation instanceof Operation) {
            return this.entityUtil.getUmlOperationName((Operation)operation);
        }
        return null;
    }

    public Object getOperationOutputType(Object operation) {
        return this.entityUtil.getUmlOperationOutputType((Operation)operation);
    }

    public EList<?> getOperationInputTypes(Object operation) {
        return this.entityUtil.getUmlOperationInputTypes((Operation)operation);
    }

    public String getOperationBody(Object operation, String language) {
        return this.entityUtil.getUmlOperationBody((Operation)operation, language);
    }

    public EList<?> getBlockTypeAttributes(Object component) {
        return EntityUtil.getInstance().getBlockTypeAttributes((Class)component);
    }

    public String getLocalAttributeVisibility(Object blockTypeAttribute) {
        return EntityUtil.getInstance().getAttributeVisibility((Property)blockTypeAttribute);
    }

    public Object getAttributeType(Object attribute) {
        return ((Property)attribute).getType();
    }

    public boolean isBlockTypeAttribute(String attributeName, Object blockAsClass) {
        return EntityUtil.getInstance().isBlockTypeAttribute(attributeName, (Class)blockAsClass);
    }

    public boolean isBlockType(Object type) {
        return EntityUtil.getInstance().isBlock((Element)type);
    }

    public Object getAttributeBlockType(String attributeName, Object block) {
        return EntityUtil.getInstance().getAttributeBlockType(attributeName, (Class)block);
    }

    public Object getAttributeType(String attributeName, Object block) {
        if (block instanceof Class) {
            return EntityUtil.getInstance().getAttributeType(attributeName, (Class)block);
        }
        return null;
    }

    public boolean isCommandOperation(String methodName, Object block) {
        return false;
    }

    public boolean isAttribute(String attributeName, Object block) {
        return EntityUtil.getInstance().isAttribute(attributeName, (Class)block);
    }

    public boolean isOperation(String operationName, Object block) {
        return EntityUtil.getInstance().isOperation(operationName, (Class)block);
    }

    public boolean isEnumValue(String name, Object enumType) {
        return EntityUtil.getInstance().isEnumValue(name, (Type)enumType);
    }

    public String getQualifiedName(Object element) {
        return ((NamedElement)element).getQualifiedName();
    }

    public Object getOperationReturnType(String operationName, Object block) {
        return EntityUtil.getInstance().getOperationType(operationName, (Class)block);
    }

    public Object getParameterType(int paramIndex, String methodName, Object retrieveBlockType) {
        return EntityUtil.getInstance().getParameterType(paramIndex, methodName, (Class)retrieveBlockType);
    }

    public String getCallEventOperationName(Object callEvent) throws Exception {
        return EntityUtil.getInstance().getCallEventOperationName((CallEvent)callEvent);
    }

    public String getCallEventName(Object callEvent) {
        return ((CallEvent)callEvent).getName();
    }

    public Collection<?> getAllCallEvent(Object block) {
        return EntityUtil.getInstance().getAllCallEvent((Class)block);
    }

    public String getName(Object element) {
        return ((NamedElement)element).getName();
    }

    public EList<String> getOperationsNames(Object component) {
        return EntityUtil.getInstance().getOperationsNames((Class)component);
    }

    public EList<String> getAttributesNames(Object component) {
        return EntityUtil.getInstance().getAttributesNames((Class)component);
    }

    public boolean isCallEvent(Object element) {
        return element instanceof CallEvent;
    }

    public Object getCallEventParameterType(String paramterName, Object callEvent) {
        System.out.println(callEvent);
        if (this.isCallEvent(callEvent)) {
            System.out.println("isCallEvent. operation: " + ((CallEvent)callEvent).getOperation());
            Parameter par = ((CallEvent)callEvent).getOperation().getOwnedParameter(paramterName, null);
            if (par != null) {
                return par.getType();
            }
        }
        return null;
    }

    public Object getCallEventOperation(Object callEvent) throws Exception {
        return EntityUtil.getInstance().getCallEventOperation((CallEvent)callEvent);
    }

    public Object getParameterType(String paramName, String methodName, Object retrieveBlockType) {
        return EntityUtil.getInstance().getParameterType(paramName, methodName, (Class)retrieveBlockType);
    }
}

