/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.utils;

import eu.fbk.eclipse.standardtools.diagram.ui.dialog.ComponentToImageDialog;
import eu.fbk.eclipse.standardtools.diagram.ui.dialog.ModelToDocumentDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExportDialogUtils {
    private static ExportDialogUtils exportDialogUtils;

    public static ExportDialogUtils getInstance() {
        if (exportDialogUtils == null) {
            exportDialogUtils = new ExportDialogUtils();
        }
        return exportDialogUtils;
    }

    public void showMessage_ExportDone(final String filePath) {
        final Display defaultDisplay = Display.getDefault();
        defaultDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currShell = defaultDisplay.getActiveShell();
                MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)("The model is exported in " + filePath + "."));
            }
        });
    }

    public String openImageDialog(String projectDir, String imageName) {
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Set target file");
        fd.setFilterPath(projectDir);
        String[] filterExt = new String[]{"*.svg", "*.png", "*.pdf"};
        fd.setFilterExtensions(filterExt);
        fd.setFileName(imageName);
        String fileName = fd.open();
        return fileName;
    }

    public ModelToDocumentDialog getCompiledModelToDocumentDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ModelToDocumentDialog parameterDialog = new ModelToDocumentDialog(shell);
        return parameterDialog;
    }

    public ComponentToImageDialog getCompiledComponentToImageDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ComponentToImageDialog parameterDialog = new ComponentToImageDialog(shell);
        parameterDialog.open();
        return parameterDialog;
    }
}

