/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.contracts.transformations.commands.CommandsCommon;
import org.polarsys.chess.contracts.transformations.dialogs.SelectFTAFMEAAnalysisCtxDialog;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class FTANuSMV3Handler
extends AbstractHandler {
    private String systemQN;
    private String ftaCond;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String filename;
        Shell activeShell;
        IEditorPart editor;
        block4: {
            editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            activeShell = window.getShell();
            try {
                PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
                Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
                Model model = ResourceUtils.getModel((Resource)res);
                filename = model.getName();
                SelectFTAFMEAAnalysisCtxDialog dialog = new SelectFTAFMEAAnalysisCtxDialog(activeShell, null, null, model, null);
                dialog.create();
                if (dialog.open() == 0) {
                    this.systemQN = dialog.getSystem();
                    this.ftaCond = dialog.getFtaCondition();
                    if (this.systemQN == null || this.systemQN.isEmpty() || this.ftaCond == null || this.ftaCond.isEmpty()) {
                        return null;
                    }
                    break block4;
                }
                return null;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return null;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.systemQN);
        String systemName = this.systemQN.substring(this.systemQN.lastIndexOf("::") + 2);
        args.add(systemName);
        args.add(String.valueOf(filename) + "_" + systemName);
        CommandsCommon.TransformationJob(activeShell, editor, args, CommandsCommon.CommandEnum.FTA, null, this.ftaCond);
        return null;
    }
}

