/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.constraints.constraintEditor;

import eu.fbk.eclipse.standardtools.constraintEditor.constraintTab.ConstraintEditorTab;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.uml2.uml.Constraint;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class CustomConstraintEditorTab
extends ConstraintEditorTab {
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private EntityUtil entityUtil = EntityUtil.getInstance();

    public Resource getResourceFromConstraint(Object constraint) {
        return ((Constraint)constraint).eResource();
    }

    public Object returnConstraint(ISelection selection) {
        Object selectedUmlElement = this.selectionUtil.getUmlSelectedObject((Object)selection);
        if (selectedUmlElement instanceof Constraint) {
            return (Constraint)selectedUmlElement;
        }
        return null;
    }

    public void constraintEditorchanged(final Object constraint, final String textChanged) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)constraint);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CustomConstraintEditorTab.this.entityUtil.setTextInUMLConstraint((Constraint)constraint, textChanged, "OCRA");
            }
        });
    }

    public String getConstraintName(Object constraint) {
        if (constraint != null) {
            return ((Constraint)constraint).getQualifiedName();
        }
        return null;
    }

    public String getStrFromConstraint(Object constraint) {
        return this.entityUtil.getConstraintBodyStr((Constraint)constraint, "OCRA");
    }

    public AbstractSystemModel getSystemModel() {
        return ChessSystemModel.getInstance();
    }
}

