/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.internal.views.permissions.EntryId;
import org.polarsys.chess.core.internal.views.permissions.PermissionEntry;
import org.polarsys.chess.core.internal.views.permissions.PermissionList;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ViewPermissions {
    public static HashMap<String, HashMap<String, PermissionList>> permissions = new HashMap();
    static PermissionList componentViewPL;
    static PermissionList extraFunctionalViewPL;
    static PermissionList deploymentViewPL;
    static PermissionList analysisViewPL;
    static PermissionList requirementViewPL;
    static PermissionList RTAnalysisViewViewPL;
    static PermissionList DependabilityAnalysisViewPL;
    static PermissionList DependabilityViewPL;
    static PermissionList SystemViewPL;
    static PermissionList PSMView;
    static PermissionEntry allowAll;

    static {
        allowAll = new PermissionEntry(EntryId.anyEntry, false, true, true);
        ViewPermissions.initializeLists();
        CHESSProjectSupport.printlnToCHESSConsole("Load permissions...");
        ViewPermissions.readXMLPermissions();
        CHESSProjectSupport.printlnToCHESSConsole("Permissions loaded.");
    }

    public static void initializeLists() {
        permissions.put("ComponentView", new HashMap());
        permissions.put("ExtraFunctionalView", new HashMap());
        permissions.put("AnalysisView", new HashMap());
        permissions.put("DeploymentView", new HashMap());
        permissions.put("RequirementView", new HashMap());
        permissions.put("RTAnalysisView", new HashMap());
        permissions.put("DependabilityAnalysisView", new HashMap());
        permissions.put("DependabilityView", new HashMap());
        permissions.put("RailwayView", new HashMap());
        permissions.put("SystemView", new HashMap());
        permissions.put("PSMView", new HashMap());
    }

    public static void readXMLPermissions() {
        try {
            URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("permissions.xml"), null);
            url = FileLocator.toFileURL((URL)url);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), null);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(uri));
            doc.getDocumentElement().normalize();
            NodeList listOfViews = doc.getElementsByTagName("view");
            int s = 0;
            while (s < listOfViews.getLength()) {
                Node view = listOfViews.item(s);
                if (view.getNodeType() == 1) {
                    ViewPermissions.parseViewNode(view);
                }
                ++s;
            }
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(String.valueOf(' ') + err.getMessage());
            CHESSProjectSupport.printlnToCHESSConsole("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            CHESSProjectSupport.printlnToCHESSConsole(String.valueOf(' ') + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace(CHESSProjectSupport.CHESS_CONSOLE_STREAM);
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace(CHESSProjectSupport.CHESS_CONSOLE_STREAM);
            t.printStackTrace();
        }
    }

    private static void parseViewNode(Node view) {
        NodeList permList = ((Element)view).getElementsByTagName("diagram");
        String viewName = ((Element)view).getAttribute("name");
        int i = 0;
        while (i < permList.getLength()) {
            Node dg = permList.item(i);
            if (dg.getNodeType() == 1) {
                PermissionList list = ViewPermissions.parseDiagramNode(dg);
                String dgName = ((Element)dg).getAttribute("name");
                ViewPermissions.addDiagramPermissions(viewName, dgName, list);
            }
            ++i;
        }
    }

    private static void addDiagramPermissions(String view, String dg, PermissionList list) {
        permissions.get(view).put(dg, list);
    }

    private static PermissionList parseDiagramNode(Node dg) {
        NodeList permList = ((Element)dg).getElementsByTagName("perm");
        PermissionList list = new PermissionList();
        int i = 0;
        while (i < permList.getLength()) {
            Node perm = permList.item(i);
            if (perm.getNodeType() == 1) {
                PermissionEntry p = ViewPermissions.createPermission((Element)perm);
                list.add(p);
            }
            ++i;
        }
        return list;
    }

    private static PermissionEntry createPermission(Element perm) {
        String id1 = ViewPermissions.parseIdValue(perm.getAttribute(EntryId.TYPE_ATR));
        String id2 = ViewPermissions.parseIdValue(perm.getAttribute(EntryId.STEREOTYPE_ATR));
        String id3 = ViewPermissions.parseIdValue(perm.getAttribute(EntryId.FEATURE_ATR));
        EntryId id = new EntryId(id1, id2, id3);
        boolean o = ViewPermissions.parsePermissionRight(perm.getAttribute(PermissionEntry.OWNER_ATR));
        boolean w = ViewPermissions.parsePermissionRight(perm.getAttribute(PermissionEntry.WRITE_ATR));
        boolean v = ViewPermissions.parsePermissionRight(perm.getAttribute(PermissionEntry.VISIBLE_ATR));
        return new PermissionEntry(id, o, w, v);
    }

    private static boolean parsePermissionRight(String attr) {
        return attr.equalsIgnoreCase("true");
    }

    private static String parseIdValue(String attr) {
        if (attr.equals("-")) {
            return EntryId.NONE;
        }
        if (attr.isEmpty() || attr.equals("*")) {
            return EntryId.ANY;
        }
        return attr;
    }
}

