/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.statebased;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class StateBasedSourceProvider
extends AbstractSourceProvider {
    public static final String ANALYSIS = "org.polarsys.chess.statebased.stateBased";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    boolean enabled;

    public void dispose() {
    }

    public Map getCurrentState() {
        HashMap<String, String> currentStateMap = new HashMap<String, String>(2);
        String currentState = this.enabled ? ENABLED : DISABLED;
        currentStateMap.put(ANALYSIS, currentState);
        return currentStateMap;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{ANALYSIS};
    }

    private void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        String currentState = enabled ? ENABLED : DISABLED;
        this.fireSourceChanged(0, ANALYSIS, currentState);
    }

    public void updateStatus(IEditorPart activeEditor) {
        try {
            DiagramStatus ds;
            if (CHESSEditorUtils.isCHESSProject((IEditorPart)activeEditor) && (ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)((PapyrusMultiDiagramEditor)activeEditor))) != null) {
                DiagramStatus.DesignView currentView = ds.getCurrentView();
                if (currentView != null && ViewUtils.isDependabilityAnalysisView((DiagramStatus.DesignView)currentView)) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            this.refreshElements();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void refreshElements() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        service.refreshElements("org.chess.stateBasedTransformationCommandID", null);
    }
}

