/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.converters.FixedComputedSet;

public class ContainmentSet
extends FixedComputedSet {
    private String containerParameterName;
    private String destParameterName;
    private Multimap<Object, Item> itemMap;
    private IObservableSet patternMatchSet;

    public ContainmentSet(PAnnotation itemAnnotation, Multimap<Object, Item> itemMap2, IObservableSet patternMatchSet) {
        Preconditions.checkArgument((boolean)"ContainsItem".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Edge annotation.");
        this.itemMap = itemMap2;
        this.containerParameterName = ((ParameterReference)itemAnnotation.getFirstValue("container")).getName();
        this.destParameterName = ((ParameterReference)itemAnnotation.getFirstValue("item")).getName();
        this.patternMatchSet = patternMatchSet;
    }

    @Override
    public Set<Containment> calculate() {
        HashSet<Containment> edgeSet = new HashSet<Containment>();
        for (Object _match : this.patternMatchSet) {
            IPatternMatch match = (IPatternMatch)_match;
            EObject sourceValue = (EObject)match.get(this.containerParameterName);
            EObject destValue = (EObject)match.get(this.destParameterName);
            for (Object _sourceItem : this.itemMap.get((Object)sourceValue)) {
                Item sourceItem = (Item)_sourceItem;
                for (Object _destItem : this.itemMap.get((Object)destValue)) {
                    Item destItem = (Item)_destItem;
                    Containment edge = new Containment(sourceItem, destItem, match);
                    edgeSet.add(edge);
                }
            }
        }
        return edgeSet;
    }
}

