/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;

public class ViewersComponentConfiguration {
    private Notifier model;
    private Collection<IQuerySpecification<?>> patterns;
    private ViewerDataFilter filter;

    private ViewersComponentConfiguration() {
        this.model = null;
        this.patterns = Sets.newHashSet();
        this.filter = ViewerDataFilter.UNFILTERED;
    }

    public ViewersComponentConfiguration(Notifier _model, Collection<IQuerySpecification<?>> _patterns, ViewerDataFilter _filter) {
        Assert.isNotNull((Object)_model);
        Assert.isNotNull(_patterns);
        Assert.isNotNull((Object)_filter);
        this.setModel(_model);
        this.setPatterns(_patterns);
        this.setFilter(_filter);
    }

    public ViewersComponentConfiguration(Notifier _model, Collection<IQuerySpecification<?>> _patterns) {
        this(_model, _patterns, ViewerDataFilter.UNFILTERED);
    }

    public static ViewersComponentConfiguration fromQuerySpecs(Collection<IQuerySpecification<IncQueryMatcher<? extends IPatternMatch>>> specs) {
        ViewersComponentConfiguration c = new ViewersComponentConfiguration();
        for (IQuerySpecification<IncQueryMatcher<? extends IPatternMatch>> spec : specs) {
            c.patterns.add(spec);
        }
        return c;
    }

    public static ViewersComponentConfiguration fromQuerySpecFQNs(Collection<String> fqns) {
        ViewersComponentConfiguration c = new ViewersComponentConfiguration();
        for (String fqn : fqns) {
            c.patterns.add(QuerySpecificationRegistry.getQuerySpecification((String)fqn));
        }
        return c;
    }

    public Notifier getModel() {
        return this.model;
    }

    public void setModel(Notifier model) {
        this.model = model;
    }

    public Collection<IQuerySpecification<?>> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection<IQuerySpecification<?>> patterns) {
        this.patterns = patterns;
    }

    public ViewerDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ViewerDataFilter filter) {
        this.filter = filter;
    }

    public ViewersComponentConfiguration newCopy() {
        ArrayList r = Lists.newArrayList();
        r.addAll(this.getPatterns());
        return new ViewersComponentConfiguration(this.getModel(), r, this.getFilter());
    }
}

