/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.layers.stackmodel.util.FakeObservableListListener;
import org.eclipse.papyrus.layers.stackmodel.util.ObservableListView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableListTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testObservableList() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ObservableListView notyfyingList = new ObservableListView(list);
        Assert.assertNotNull((String)"Object created", notyfyingList);
    }

    @Test
    public void testDelegate() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ObservableListView notyfyingList = new ObservableListView(list);
        Assert.assertSame((String)"delegate is set", (Object)list, notyfyingList.delegate());
    }

    @Test
    public void testGetEventBus() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ObservableListView notyfyingList = new ObservableListView(list);
        Assert.assertNotNull((String)"eventBus found", (Object)notyfyingList.getEventBus());
    }

    @Test
    public void testAddE() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        String addedElement = "purple";
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore + 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.add(addedElement);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        Assert.assertTrue((String)"event addedElement is correct", (boolean)((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements().contains(addedElement));
        Collection eventAddedElements = ((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements();
        Assert.assertEquals((String)"event elements size", (long)1L, (long)eventAddedElements.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testAddAllCollectionOfQextendsE() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow"});
        ArrayList addedElements = Lists.newArrayList((Object[])new String[]{"green", "blue", "purple"});
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore + addedElements.size();
        ObservableListView notyfyingList = new ObservableListView(list);
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.addAll(addedElements);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        Collection eventAddedElements = ((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements();
        Assert.assertEquals((String)"event elements size", (long)addedElements.size(), (long)eventAddedElements.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testAddIntE() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        String addedElement = "purple";
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore + 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.add(3, addedElement);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        Assert.assertTrue((String)"event addedElement is correct", (boolean)((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements().contains(addedElement));
        Collection eventAddedElements = ((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements();
        Assert.assertEquals((String)"event elements size", (long)1L, (long)eventAddedElements.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testAddAllIntCollectionOfQextendsE() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow"});
        ArrayList addedElements = Lists.newArrayList((Object[])new String[]{"green", "blue", "purple"});
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore + addedElements.size();
        ObservableListView notyfyingList = new ObservableListView(list);
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.addAll(2, addedElements);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        Collection eventAddedElements = ((ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier).getAddedElements();
        Assert.assertEquals((String)"event elements size", (long)addedElements.size(), (long)eventAddedElements.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testRemoveInt() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        String removedElement = "purple";
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore - 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.remove(removedElement);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertTrue((String)"event removesElement is correct", (boolean)event.getRemovedElements().contains(removedElement));
        Assert.assertEquals((String)"addedElement size", (long)0L, (long)event.getAddedElements().size());
        Assert.assertEquals((String)"removedElement size", (long)1L, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testRemoveObject() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        int removedIndex = 3;
        String removedElement = (String)list.get(removedIndex);
        int listSizeBefore = list.size();
        int expectedListSizeAfter = listSizeBefore - 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.remove(removedIndex);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertTrue((String)"event removesElement is correct", (boolean)event.getRemovedElements().contains(removedElement));
        Assert.assertEquals((String)"addedElement size", (long)0L, (long)event.getAddedElements().size());
        Assert.assertEquals((String)"removedElement size", (long)1L, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testRemoveAllCollectionOfQ() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList elementsToRemove = Lists.newArrayList((Object[])new String[]{"orange", "green", "purple"});
        int listSizeBefore = list.size();
        int removedElementsCount = elementsToRemove.size();
        int expectedListSizeAfter = listSizeBefore - removedElementsCount;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.removeAll(elementsToRemove);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertTrue((String)"event removesElement is correct", (boolean)event.getRemovedElements().containsAll(elementsToRemove));
        Assert.assertEquals((String)"addedElement size", (long)0L, (long)event.getAddedElements().size());
        Assert.assertEquals((String)"removedElement size", (long)removedElementsCount, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testRemoveAllCollectionOfQWithTooMuchElements() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList elementsToRemove = Lists.newArrayList((Object[])new String[]{"orange", "falseColor1", "green", "purple", "falseColor"});
        int listSizeBefore = list.size();
        int removedElementsCount = elementsToRemove.size() - 2;
        int expectedListSizeAfter = listSizeBefore - removedElementsCount;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.removeAll(elementsToRemove);
        Assert.assertSame((String)"event propagated", (Object)1, (Object)notifyingListListener.traces.size());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertTrue((String)"removed elements are from the required list", (boolean)elementsToRemove.containsAll(event.getRemovedElements()));
        Assert.assertEquals((String)"addedElement size", (long)0L, (long)event.getAddedElements().size());
        Assert.assertEquals((String)"removedElement size", (long)removedElementsCount, (long)event.getRemovedElements().size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)notyfyingList.size());
        Assert.assertEquals((String)"result list size", (long)expectedListSizeAfter, (long)list.size());
    }

    @Test
    public void testResetTo() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList listToReset = Lists.newArrayList((Object[])new String[]{"orange", "green", "purple", "falseColor"});
        ArrayList expectedRemovedElement = Lists.newArrayList((Object[])new String[]{"red", "yellow", "blue"});
        ArrayList expectedAddedElement = Lists.newArrayList((Object[])new String[]{"falseColor"});
        int expectedEventCount = 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.resetTo(listToReset);
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        Assert.assertArrayEquals((String)"List equals", (Object[])listToReset.toArray(), (Object[])notyfyingList.toArray());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertArrayEquals((String)"Removed list ok", (Object[])expectedRemovedElement.toArray(), (Object[])event.getRemovedElements().toArray());
        Assert.assertArrayEquals((String)"Added list ok", (Object[])expectedAddedElement.toArray(), (Object[])event.getAddedElements().toArray());
    }

    @Test
    public void testResetToNoAdded() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList listToReset = Lists.newArrayList((Object[])new String[]{"orange", "green", "purple"});
        ArrayList expectedRemovedElement = Lists.newArrayList((Object[])new String[]{"red", "yellow", "blue"});
        List expectedAddedElement = Collections.emptyList();
        int expectedEventCount = 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.resetTo(listToReset);
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        Assert.assertArrayEquals((String)"List equals", (Object[])listToReset.toArray(), (Object[])notyfyingList.toArray());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertArrayEquals((String)"Removed list ok", (Object[])expectedRemovedElement.toArray(), (Object[])event.getRemovedElements().toArray());
        Assert.assertArrayEquals((String)"Added list ok", (Object[])expectedAddedElement.toArray(), (Object[])event.getAddedElements().toArray());
    }

    @Test
    public void testResetToWithAddition() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList listToReset = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple", "falseColor"});
        List expectedRemovedElement = Collections.emptyList();
        ArrayList expectedAddedElement = Lists.newArrayList((Object[])new String[]{"falseColor"});
        int expectedEventCount = 1;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.resetTo(listToReset);
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        Assert.assertArrayEquals((String)"List equals", (Object[])listToReset.toArray(), (Object[])notyfyingList.toArray());
        ObservableListView.ObservableListEvent event = (ObservableListView.ObservableListEvent)notifyingListListener.traces.get((int)0).notifier;
        Assert.assertArrayEquals((String)"Removed list ok", (Object[])expectedRemovedElement.toArray(), (Object[])event.getRemovedElements().toArray());
        Assert.assertArrayEquals((String)"Added list ok", (Object[])expectedAddedElement.toArray(), (Object[])event.getAddedElements().toArray());
    }

    @Test
    public void testResetToNoChanges() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        ArrayList listToReset = Lists.newArrayList((Object[])new String[]{"red", "orange", "yellow", "green", "blue", "purple"});
        List expectedRemovedElement = Collections.emptyList();
        List expectedAddedElement = Collections.emptyList();
        int expectedEventCount = 0;
        FakeObservableListListener notifyingListListener = new FakeObservableListListener();
        ObservableListView notyfyingList = new ObservableListView(list);
        notyfyingList.getEventBus().register(notifyingListListener);
        notyfyingList.resetTo(listToReset);
        Assert.assertSame((String)"event propagated", (Object)expectedEventCount, (Object)notifyingListListener.traces.size());
        Assert.assertArrayEquals((String)"List equals", (Object[])listToReset.toArray(), (Object[])notyfyingList.toArray());
    }
}

