/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.operators;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.BooleanInstance;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.operators.BooleanOrOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BooleanOrOperatorTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    protected BooleanInstance createBooleanInstance(boolean value) {
        BooleanInstance val = LayersFactory.eINSTANCE.createBooleanInstance();
        val.setValue(value);
        return val;
    }

    @Test
    public void testGetComputePropertyValueCommandReturnTrue() throws LayersException {
        BasicEList nestedCommand = new BasicEList();
        BooleanInstance val1 = this.createBooleanInstance(false);
        nestedCommand.add((Object)val1);
        BooleanInstance val2 = this.createBooleanInstance(true);
        nestedCommand.add((Object)val2);
        BooleanInstance val3 = this.createBooleanInstance(false);
        nestedCommand.add((Object)val3);
        BooleanOrOperator op = new BooleanOrOperator();
        Assert.assertNotNull((String)"command created", (Object)op.getComputePropertyValueCommand((EList<ComputePropertyValueCommand>)nestedCommand));
        Assert.assertSame((String)"return the right value", (Object)true, (Object)((BooleanInstance)op.getComputePropertyValueCommand((EList<ComputePropertyValueCommand>)nestedCommand).getCmdValue()).isValue());
    }

    @Test
    public void testGetComputePropertyValueCommandReturnFalse() throws LayersException {
        BasicEList nestedCommand = new BasicEList();
        BooleanInstance val1 = this.createBooleanInstance(false);
        nestedCommand.add((Object)val1);
        BooleanInstance val2 = this.createBooleanInstance(false);
        nestedCommand.add((Object)val2);
        BooleanInstance val3 = this.createBooleanInstance(false);
        nestedCommand.add((Object)val3);
        BooleanOrOperator op = new BooleanOrOperator();
        Assert.assertNotNull((String)"command created", (Object)op.getComputePropertyValueCommand((EList<ComputePropertyValueCommand>)nestedCommand));
        Assert.assertSame((String)"return the right value", (Object)false, (Object)((BooleanInstance)op.getComputePropertyValueCommand((EList<ComputePropertyValueCommand>)nestedCommand).getCmdValue()).isValue());
    }
}

