/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.notifier;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.layers.stackmodel.notifier.TraceUmlNamedElementChangedEventListener;
import org.eclipse.papyrus.layers.stackmodel.notifier.UmlNamedElementChangedEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.UmlNamedElementChangedEventNotifierFactory;
import org.eclipse.papyrus.layers.stackmodel.util.NotationAndUmlModelsFactory;
import org.eclipse.papyrus.layers.stackmodel.util.TriggeredEventTraces;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UmlNamedElementChangedEventNotifierTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testUmlNamedElementChangedEventNotifier() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        Assert.assertNotNull((String)"notifier created", (Object)((Object)eventNotifier));
    }

    @Test
    public void testAddEventListener() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        TraceUmlNamedElementChangedEventListener listener = new TraceUmlNamedElementChangedEventListener();
        eventNotifier.addEventListener(listener);
        Assert.assertTrue((String)"listener added", (boolean)eventNotifier.listeners.contains(listener));
    }

    @Test
    public void testRemoveEventListener() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        TraceUmlNamedElementChangedEventListener listener = new TraceUmlNamedElementChangedEventListener();
        eventNotifier.addEventListener(listener);
        eventNotifier.removeEventListener(listener);
        Assert.assertFalse((String)"listener removed", (boolean)eventNotifier.listeners.contains(listener));
    }

    @Test
    public void testNameChangedEvent() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        TraceUmlNamedElementChangedEventListener listener = new TraceUmlNamedElementChangedEventListener();
        eventNotifier.addEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        traces.clear();
        c1.setName("newName");
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("valueChanged"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        TriggeredEventTraces.TriggeredEvent event = traces.traces.get(0);
        Assert.assertEquals((String)"right element in event", (Object)c1, (Object)((Notification)event.notifier).getNotifier());
    }

    @Test
    public void testPropertyAdded() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        TraceUmlNamedElementChangedEventListener listener = new TraceUmlNamedElementChangedEventListener();
        eventNotifier.addEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        int expectedEventCount = 2;
        traces.clear();
        Property p1 = modelsFactory.newProperty(c1, "p1");
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("valueChanged"));
        Assert.assertEquals((String)"one event recorded", (long)expectedEventCount, (long)traces.traces.size());
    }

    @Test
    public void testPropertyNameChanged() {
        NotationAndUmlModelsFactory modelsFactory = new NotationAndUmlModelsFactory();
        Diagram diagram1 = modelsFactory.newDiagram();
        Class c1 = modelsFactory.newClass(diagram1, "C1");
        Property p1 = modelsFactory.newProperty(c1, "p1");
        UmlNamedElementChangedEventNotifierFactory notifierFactory = new UmlNamedElementChangedEventNotifierFactory();
        UmlNamedElementChangedEventNotifier eventNotifier = (UmlNamedElementChangedEventNotifier)notifierFactory.adapt((Notifier)c1, UmlNamedElementChangedEventNotifier.class);
        TraceUmlNamedElementChangedEventListener listener = new TraceUmlNamedElementChangedEventListener();
        eventNotifier.addEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        int expectedEventCount = 1;
        traces.clear();
        p1.setName("NewName");
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("valueChanged"));
        Assert.assertEquals((String)"one event recorded", (long)expectedEventCount, (long)traces.traces.size());
    }
}

