/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.notifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.notifier.ILayersTreeEventListener;

public class LayersTreeEventNotifier
extends EContentAdapter {
    protected List<ILayersTreeEventListener> listeners = new ArrayList<ILayersTreeEventListener>();

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.listeners.clear();
        this.listeners = null;
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public void notifyChanged(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".notifyChanged( " + notification.getFeature() + ")");
        }
        super.notifyChanged(notification);
        if (notification.getFeature() == LayersPackage.eINSTANCE.getLayerOperator_Layers() || notification.getFeature() == LayersPackage.eINSTANCE.getLayersStack_Layers()) {
            switch (notification.getEventType()) {
                case 1: {
                    this.fireLayerSet(notification);
                    break;
                }
                case 3: {
                    this.fireLayerAdded(notification);
                    break;
                }
                case 4: {
                    this.fireLayerRemoved(notification);
                    break;
                }
                case 7: {
                    this.fireLayerMoved(notification);
                }
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == LayersTreeEventNotifier.class;
    }

    public void addLayersModelEventListener(ILayersTreeEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeLayersModelEventListener(ILayersTreeEventListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLayerSet(Notification notification) {
        for (ILayersTreeEventListener listener : this.listeners) {
            listener.layerSet(notification);
        }
    }

    public void fireLayerAdded(Notification notification) {
        for (ILayersTreeEventListener listener : this.listeners) {
            listener.layerAdded(notification);
        }
    }

    public void fireLayerRemoved(Notification notification) {
        for (ILayersTreeEventListener listener : this.listeners) {
            listener.layerRemoved(notification);
        }
    }

    public void fireLayerMoved(Notification notification) {
        for (ILayersTreeEventListener listener : this.listeners) {
            listener.layerMoved(notification);
        }
    }
}

