/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.Type;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyRegistryImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPropertyRegistryImpl() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertNotNull((String)"type registry created", (Object)registry.getTypeRegistry());
        Assert.assertNotNull((String)"properties created", registry.getProperties());
    }

    @Test
    public void testinit() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertTrue((String)"property list size is correct", (registry.getProperties().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testinitDefaultValue() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertTrue((String)"property list size is correct", (registry.getProperties().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"property list size is correct", (Object)((Property)registry.getProperties().get(0)).getDefaultValue());
    }

    @Test
    public void testGetProperties() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertNotNull((String)"properties list created", registry.getProperties());
        Assert.assertTrue((String)"properties created", (registry.getProperties().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPropertiesCount() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertSame((String)"count is ok", (Object)registry.getProperties().size(), (Object)registry.getPropertiesCount());
        Property property = LayersFactory.eINSTANCE.createProperty();
        property.setName("prop1");
        registry.getProperties().add((Object)property);
        Assert.assertSame((String)"count is ok", (Object)registry.getProperties().size(), (Object)registry.getPropertiesCount());
    }

    @Test
    public void testGetTypeRegistry() {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        Assert.assertNotNull((String)"registry created", (Object)registry);
        Assert.assertNotNull((String)"type registry created", (Object)registry.getTypeRegistry());
    }

    @Test
    public void testGetPropertyIndex() throws NotFoundException {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        int index = 0;
        Property property = (Property)registry.getProperties().get(index);
        Assert.assertEquals((String)"index found", (long)index, (long)registry.getPropertyIndex(property.getName()));
    }

    @Test
    public void testAddProperty() throws NotFoundException {
        PropertyRegistry registry = LayersFactory.eINSTANCE.createPropertyRegistry();
        String typeName = "boolean";
        String name = "prop1";
        Property property = LayersFactory.eINSTANCE.createProperty();
        property.setName(name);
        property.setType((Type)registry.getTypeRegistry().getTypes().get((Object)typeName));
        registry.addProperty(property);
        Property propFound = registry.getProperty(name);
        Assert.assertSame((String)"property found", (Object)property, (Object)propFound);
        Assert.assertTrue((String)"property index set", (propFound.getIndex() >= 0 ? 1 : 0) != 0);
    }
}

