/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.AndStackedLayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.DefaultPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerOperatorDescriptorRegistryImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayerOperatorDescriptorRegistryImpl() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertNotNull((String)"registry created", (Object)registry);
    }

    @Test
    public void testGetDescriptors() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertNotNull((String)"descriptors list is set", registry.getDescriptors());
    }

    @Test
    public void testGetPropertyOperators() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertNotNull((String)"operators list is set", registry.getPropertyOperators());
    }

    @Test
    public void testGetPropertyCollectionSize() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertSame((String)"sie is set", (Object)propertiesCollectionSize, (Object)registry.getPropertyCollectionSize());
    }

    @Test
    public void testSetPropertyCollectionSize() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertSame((String)"size set", (Object)propertiesCollectionSize, (Object)registry.getPropertyCollectionSize());
    }

    @Test
    public void testGetDefaultOperator() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        Assert.assertNotNull((String)"default operator set", (Object)registry.getDefaultOperator());
        Assert.assertTrue((String)"default operator type", (boolean)(registry.getDefaultOperator() instanceof DefaultPropertyOperator));
    }

    @Test
    public void testAddLayerOperatorDescriptor() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        AndStackedLayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createAndStackedLayerOperatorDescriptor();
        registry.addLayerOperatorDescriptor(descriptor);
        Assert.assertSame((String)"list size increased", (Object)1, (Object)registry.getDescriptors().size());
        Assert.assertSame((String)"descriptor found", (Object)descriptor, (Object)registry.getDescriptors().get(0));
        Assert.assertSame((String)"descriptor property size set", (Object)propertiesCollectionSize, (Object)descriptor.getPropertyOperators().size());
    }

    @Test
    public void testGetLayerOperatorDescriptor() throws NotFoundException {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        LayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        descriptor.setName("desc1");
        registry.addLayerOperatorDescriptor(descriptor);
        Assert.assertSame((String)"descriptor found by its name", (Object)descriptor, (Object)registry.getLayerOperatorDescriptor(descriptor.getName()));
        try {
            registry.getLayerOperatorDescriptor("wrong name");
            Assert.fail((String)"Wrong name send an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddPropertyOperator() {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        PropertyOperator operator1 = LayersFactory.eINSTANCE.createPropertyOperator();
        operator1.setName("op1");
        registry.addPropertyOperator(operator1);
        Assert.assertSame((String)"list size increased", (Object)1, (Object)registry.getPropertyOperators().size());
        Assert.assertSame((String)"descriptor found", (Object)operator1, (Object)registry.getPropertyOperators().get(0));
    }

    @Test
    public void testGetPropertyOperator() throws NotFoundException {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        PropertyOperator operator1 = LayersFactory.eINSTANCE.createPropertyOperator();
        operator1.setName("op1");
        registry.addPropertyOperator(operator1);
        Assert.assertSame((String)"operator found by its name", (Object)operator1, (Object)registry.getPropertyOperator(operator1.getName()));
        try {
            registry.getPropertyOperator("wrong name");
            Assert.fail((String)"Wrong name send an NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAttachOperatorToDescriptor() throws NotFoundException {
        int propertiesCollectionSize = 10;
        LayerOperatorDescriptorRegistry registry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        registry.setPropertyCollectionSize(propertiesCollectionSize);
        LayerOperatorDescriptor descriptor = LayersFactory.eINSTANCE.createLayerOperatorDescriptor();
        descriptor.setName("desc1");
        registry.addLayerOperatorDescriptor(descriptor);
        PropertyOperator operator1 = LayersFactory.eINSTANCE.createPropertyOperator();
        operator1.setName("op1");
        registry.addPropertyOperator(operator1);
        Property prop1 = LayersFactory.eINSTANCE.createProperty();
        prop1.setName("prop1");
        prop1.setIndex(0);
        registry.attachOperatorToDescriptor(prop1, operator1.getName(), descriptor.getName());
        Assert.assertSame((String)"operator found in layer", (Object)operator1, (Object)descriptor.getPropertyOperator(prop1));
    }
}

