/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.layers.stackmodel.Activator;
import org.eclipse.papyrus.layers.stackmodel.LayersException;
import org.eclipse.papyrus.layers.stackmodel.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.layers.stackmodel.layers.CustomPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.impl.PropertyOperatorImpl;
import org.eclipse.papyrus.layers.stackmodel.operators.CustomPropertyOperatorsInstance;
import org.osgi.framework.Bundle;

public class CustomPropertyOperatorImpl
extends PropertyOperatorImpl
implements CustomPropertyOperator {
    protected static final String CLASSNAME_EDEFAULT = null;
    protected String classname = CLASSNAME_EDEFAULT;
    protected static final CustomPropertyOperatorsInstance OPERATOR_INSTANCE_EDEFAULT = null;
    protected CustomPropertyOperatorsInstance operatorInstance = OPERATOR_INSTANCE_EDEFAULT;
    protected static final String CLASS_BUNDLE_ID_EDEFAULT = null;
    protected String classBundleID = CLASS_BUNDLE_ID_EDEFAULT;

    protected CustomPropertyOperatorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.CUSTOM_PROPERTY_OPERATOR;
    }

    @Override
    public String getClassname() {
        return this.classname;
    }

    @Override
    public void setClassname(String newClassname) {
        String oldClassname = this.classname;
        this.classname = newClassname;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldClassname, (Object)this.classname));
        }
        this.setOperatorInstance(null);
    }

    @Override
    public CustomPropertyOperatorsInstance getOperatorInstance() {
        if (this.operatorInstance == null) {
            try {
                this.resetOperatorInstance();
            }
            catch (LayersException e) {
                Activator.log.error("LOG-" + this.getClass().getName() + "- Can't set custom operator instance '" + e.getMessage() + "'.", (Throwable)e);
            }
        }
        return this.operatorInstance;
    }

    @Override
    public void setOperatorInstance(CustomPropertyOperatorsInstance newOperatorInstance) {
        CustomPropertyOperatorsInstance oldOperatorInstance = this.operatorInstance;
        this.operatorInstance = newOperatorInstance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldOperatorInstance, (Object)this.operatorInstance));
        }
    }

    @Override
    public String getClassBundleID() {
        return this.classBundleID;
    }

    @Override
    public void setClassBundleID(String newClassBundleID) {
        String oldClassBundleID = this.classBundleID;
        this.classBundleID = newClassBundleID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldClassBundleID, (Object)this.classBundleID));
        }
    }

    @Override
    public void resetOperatorInstance() throws LayersException {
        if (this.getClassname() == null) {
            return;
        }
        Class<?> opClass = this.loadClass();
        try {
            this.setOperatorInstance((CustomPropertyOperatorsInstance)opClass.newInstance());
        }
        catch (Exception e) {
            throw new LayersException("Can't create instance for CustomOperator " + this.getName(), e);
        }
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(EList<ComputePropertyValueCommand> property) throws LayersException {
        return this.getOperatorInstance().getComputePropertyValueCommand(property);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getClassname();
            }
            case 2: {
                return this.getOperatorInstance();
            }
            case 3: {
                return this.getClassBundleID();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setClassname((String)newValue);
                return;
            }
            case 2: {
                this.setOperatorInstance((CustomPropertyOperatorsInstance)newValue);
                return;
            }
            case 3: {
                this.setClassBundleID((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setClassname(CLASSNAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setOperatorInstance(OPERATOR_INSTANCE_EDEFAULT);
                return;
            }
            case 3: {
                this.setClassBundleID(CLASS_BUNDLE_ID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return CLASSNAME_EDEFAULT == null ? this.classname != null : !CLASSNAME_EDEFAULT.equals(this.classname);
            }
            case 2: {
                return OPERATOR_INSTANCE_EDEFAULT == null ? this.operatorInstance != null : !OPERATOR_INSTANCE_EDEFAULT.equals(this.operatorInstance);
            }
            case 3: {
                return CLASS_BUNDLE_ID_EDEFAULT == null ? this.classBundleID != null : !CLASS_BUNDLE_ID_EDEFAULT.equals(this.classBundleID);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.resetOperatorInstance();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private Class<?> loadClass() throws LayersException {
        Class classDesc;
        String classname = this.getClassname();
        try {
            classDesc = Class.forName(classname);
        }
        catch (ClassNotFoundException e1) {
            try {
                String bundleID = this.getClassBundleID();
                Bundle bundle = Platform.getBundle((String)bundleID);
                classDesc = bundle.loadClass(classname);
            }
            catch (ClassNotFoundException e2) {
                throw new LayersException("Can't find class for the name '" + classname + "'.", e2);
            }
            catch (NullPointerException e) {
                throw new LayersException("Can't find bundle '" + this.getClassBundleID() + "' for class for the name '" + classname + "'.", e);
            }
        }
        return classDesc;
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (classname: ");
        result.append(this.classname);
        result.append(", operatorInstance: ");
        result.append(this.operatorInstance);
        result.append(", classBundleID: ");
        result.append(this.classBundleID);
        result.append(')');
        return result.toString();
    }
}

