/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.TableUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.AsyncTableRenderingViewer;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.ui.progress.UIJob;

public class AsyncTableRenderingUpdatePolicy
extends TableUpdatePolicy {
    @Override
    public void modelChanged(IModelDelta node, IModelProxy proxy) {
        AbstractVirtualContentTableModel model = this.getTableViewer().getVirtualContentModel();
        if (model != null) {
            IContentChangeComputer computer = null;
            if (model instanceof IContentChangeComputer) {
                computer = (IContentChangeComputer)((Object)model);
            }
            this.clearCache(computer);
            if (!this.containsEvent()) {
                return;
            }
            if (node.getElement() instanceof IMemoryBlock && (node.getFlags() & 0x400) != 0) {
                if (computer != null && this.getTableViewer() != null && !this.getTableViewer().getRendering().isDisplayingError()) {
                    computer.cache(model.getElements());
                }
                this.notifyRendering(node, proxy);
                this.handleMemoryBlockChanged((IMemoryBlock)node.getElement(), node);
                return;
            }
            if (node.getElement() instanceof IMemoryBlock && (node.getFlags() & 0x800) != 0) {
                this.handleMemoryBlockChanged((IMemoryBlock)node.getElement(), node);
                return;
            }
        }
        super.modelChanged(node, proxy);
    }

    protected void clearCache(IContentChangeComputer computer) {
        if (computer != null) {
            computer.clearCache();
        }
    }

    private void notifyRendering(IModelDelta node, IModelProxy proxy) {
        IModelChangedListener listener;
        if (this.getTableViewer() != null && (listener = (IModelChangedListener)this.getTableViewer().getRendering().getAdapter(IModelChangedListener.class)) != null) {
            listener.modelChanged(node, proxy);
        }
    }

    protected void handleMemoryBlockChanged(IMemoryBlock mb, IModelDelta delta) {
        block8: {
            try {
                MemoryViewPresentationContext context;
                AbstractAsyncTableRendering rendering;
                if (this.getViewer().getPresentationContext() instanceof MemoryViewPresentationContext && (rendering = this.getTableRendering(context = (MemoryViewPresentationContext)this.getViewer().getPresentationContext())) != null) {
                    if ((delta.getFlags() & 0x400) != 0) {
                        TableRenderingContentDescriptor descriptor = (TableRenderingContentDescriptor)rendering.getAdapter(TableRenderingContentDescriptor.class);
                        if (descriptor != null) {
                            final BigInteger address = this.getMemoryBlockBaseAddress(mb);
                            if (!descriptor.isMemoryBlockBaseAddressInitialized() || !address.equals(descriptor.getContentBaseAddress())) {
                                descriptor.updateContentBaseAddress();
                                UIJob job = new UIJob("go to address"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        block2: {
                                            try {
                                                rendering.goToAddress(address);
                                            }
                                            catch (DebugException e) {
                                                if (AsyncTableRenderingUpdatePolicy.this.getTableViewer() == null) break block2;
                                                AsyncTableRenderingUpdatePolicy.this.getTableViewer().handlePresentationFailure(null, e.getStatus());
                                            }
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setSystem(true);
                                job.schedule();
                            } else {
                                rendering.refresh();
                            }
                        }
                    } else {
                        rendering.updateLabels();
                    }
                }
            }
            catch (DebugException e) {
                if (this.getTableViewer() == null) break block8;
                this.getTableViewer().handlePresentationFailure(null, e.getStatus());
            }
        }
    }

    private BigInteger getMemoryBlockBaseAddress(IMemoryBlock mb) throws DebugException {
        if (mb instanceof IMemoryBlockExtension) {
            return ((IMemoryBlockExtension)mb).getBigBaseAddress();
        }
        return BigInteger.valueOf(mb.getStartAddress());
    }

    private AsyncTableRenderingViewer getTableViewer() {
        if (this.getViewer() instanceof AsyncTableRenderingViewer) {
            return (AsyncTableRenderingViewer)this.getViewer();
        }
        return null;
    }

    private boolean containsEvent() {
        AbstractAsyncTableRendering rendering;
        MemoryViewPresentationContext context;
        return !(this.getViewer().getPresentationContext() instanceof MemoryViewPresentationContext) || !((context = (MemoryViewPresentationContext)this.getViewer().getPresentationContext()).getRendering() instanceof AbstractAsyncTableRendering) || (rendering = (AbstractAsyncTableRendering)context.getRendering()).isVisible();
    }

    protected AbstractAsyncTableRendering getTableRendering(MemoryViewPresentationContext context) {
        IMemoryRendering memRendering = context.getRendering();
        if (memRendering != null && memRendering instanceof AbstractAsyncTableRendering) {
            return (AbstractAsyncTableRendering)memRendering;
        }
        return null;
    }
}

