/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.collection.CollectionFlattenOperation;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.FeatureCallExp;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.NumericLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.State;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.scoping.BaseScopeView;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.BinaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ImplicitCollectFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ImplicitCollectionFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.UnaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2as.ImplicitSourceTypeIterator;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2as.ImplicitSourceVariableIterator;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.AbstractNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ConstructorExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ConstructorPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.IndexExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.LetExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.LetVariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.UnaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.util.AbstractEssentialOCLCSLeft2RightVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCSLeft2RightVisitor
extends AbstractEssentialOCLCSLeft2RightVisitor {
    @NonNull
    protected final MetaModelManager metaModelManager;

    public EssentialOCLCSLeft2RightVisitor(@NonNull CS2PivotConversion context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    protected void checkForInvalidImplicitSourceType(@NonNull ExpCS csInvocationExp) {
        ImplicitSourceTypeIterator it = new ImplicitSourceTypeIterator((ElementCS)csInvocationExp);
        while (it.hasNext()) {
            if (!this.isInvalidType((Type)it.next())) continue;
            csInvocationExp.setHasError(true);
            break;
        }
    }

    protected ImplicitSourceTypeIterator createImplicitSourceTypeIterator(@NonNull ElementCS csElement) {
        return new ImplicitSourceTypeIterator(csElement);
    }

    @NonNull
    protected OCLExpression createImplicitSourceVariableExp(@NonNull AbstractNameExpCS csNameExp, Type owningType) {
        VariableDeclaration sourceVariable;
        VariableDeclaration variableDeclaration = sourceVariable = owningType != null ? this.getImplicitSource(csNameExp, owningType) : null;
        if (sourceVariable == null) {
            VariableDeclaration sourceVariable2 = owningType != null ? this.getImplicitSource(csNameExp, owningType) : null;
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "No implicit source");
        }
        return this.createImplicitVariableExp(sourceVariable);
    }

    @NonNull
    protected VariableExp createImplicitVariableExp(@NonNull VariableDeclaration variable) {
        VariableExp variableExp = (VariableExp)((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, null);
        variableExp.setReferredVariable(variable);
        variableExp.setImplicit(true);
        ((CS2PivotConversion)this.context).setType((TypedElement)variableExp, variable.getType(), variable.isRequired());
        return variableExp;
    }

    @Nullable
    protected Iteration getBestIteration(@NonNull List<NamedElement> invocations) {
        Iteration bestIteration = null;
        Type bestType = null;
        int bestIteratorsSize = Integer.MAX_VALUE;
        for (NamedElement operation : invocations) {
            Type specializedType;
            if (!(operation instanceof Iteration)) continue;
            Iteration iteration = (Iteration)operation;
            int iteratorsSize = iteration.getOwnedIterator().size();
            if (bestIteration != null && iteratorsSize > bestIteratorsSize || (specializedType = iteration.getOwningType()) == null) continue;
            Type unspecializedType = (Type)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)specializedType);
            if (bestType != null && this.metaModelManager.isSuperClassOf(unspecializedType, bestType)) continue;
            bestIteration = iteration;
            bestType = unspecializedType;
            bestIteratorsSize = iteratorsSize;
        }
        return bestIteration;
    }

    @Nullable
    protected Operation getExampleOperation(@NonNull List<NamedElement> invocations) {
        if (invocations.size() <= 1) {
            NamedElement namedElement = invocations.get(0);
            return namedElement instanceof Operation ? (Operation)namedElement : null;
        }
        EReference aReferredOperation = PivotPackage.Literals.OPERATION_CALL_EXP__REFERRED_OPERATION;
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)aReferredOperation, null);
        environmentView.addElements(invocations);
        environmentView.resolveDuplicates();
        Object content = ((Map.Entry)environmentView.getEntries().iterator().next()).getValue();
        if (content instanceof List) {
            content = ((List)content).get(0);
        }
        return (Operation)content;
    }

    @Nullable
    protected List<NamedElement> getInvocations(@Nullable OCLExpression sourceExp, @NonNull InvocationExpCS csInvocationExp) {
        NameExpCS csNameExp = csInvocationExp.getNameExp();
        if (csNameExp == null) {
            return null;
        }
        PathNameCS csPathName = csNameExp.getPathName();
        if (csPathName == null) {
            return null;
        }
        EList csPathElements = csPathName.getPath();
        if (csPathElements == null) {
            return null;
        }
        int pathSize = csPathElements.size();
        if (pathSize <= 0) {
            return null;
        }
        PathElementCS csLastPathElement = (PathElementCS)csPathElements.get(pathSize - 1);
        if (csLastPathElement == null) {
            return null;
        }
        Element asElement = csLastPathElement.basicGetElement();
        if (asElement instanceof Operation && !asElement.eIsProxy()) {
            return Collections.singletonList((NamedElement)asElement);
        }
        String name = ElementUtil.getTextName((ElementCS)csLastPathElement);
        if (name == null) {
            return null;
        }
        int iteratorCount = 0;
        int expressionCount = 0;
        for (NavigatingArgCS csArg : csInvocationExp.getArgument()) {
            if (csArg.getRole() == NavigationRole.ITERATOR) {
                ++iteratorCount;
                continue;
            }
            if (csArg.getRole() != NavigationRole.EXPRESSION) continue;
            ++expressionCount;
        }
        if (pathSize > 1) {
            Element asScope = ((PathElementCS)csPathElements.get(pathSize - 2)).getElement();
            if (!(asScope instanceof Type)) {
                return null;
            }
            Type asType = (Type)asScope;
            List<NamedElement> invocations = this.getInvocations(asType, name, iteratorCount, expressionCount);
            if (invocations == null && name.startsWith("_")) {
                String unescapedName = name.substring(1);
                invocations = this.getInvocations(asType, unescapedName, iteratorCount, expressionCount);
            }
            return invocations;
        }
        if (sourceExp != null) {
            List<NamedElement> invocations;
            Type asType = sourceExp.getType();
            if (asType == null) {
                return null;
            }
            if (asType.getOwningTemplateParameter() != null) {
                asType = this.metaModelManager.getOclAnyType();
            }
            if ((invocations = this.getInvocations(asType, name, iteratorCount, expressionCount)) == null && name.startsWith("_")) {
                String unescapedName = name.substring(1);
                invocations = this.getInvocations(asType, unescapedName, iteratorCount, expressionCount);
            }
            return invocations;
        }
        List<NamedElement> invocations = null;
        ImplicitSourceTypeIterator it = this.createImplicitSourceTypeIterator((ElementCS)csInvocationExp);
        while (invocations == null && it.hasNext()) {
            Type asType = (Type)it.next();
            invocations = this.getInvocations(asType, name, iteratorCount, expressionCount);
        }
        if (invocations == null && name.startsWith("_")) {
            String unescapedName = name.substring(1);
            ImplicitSourceTypeIterator it2 = this.createImplicitSourceTypeIterator((ElementCS)csInvocationExp);
            while (invocations == null && it2.hasNext()) {
                Type asType = (Type)it2.next();
                invocations = this.getInvocations(asType, unescapedName, iteratorCount, expressionCount);
            }
        }
        return invocations;
    }

    @Nullable
    protected VariableDeclaration getImplicitSource(@NonNull ModelElementCS csExp, @NonNull Type requiredType) {
        Variable lastVariable = null;
        ImplicitSourceVariableIterator it = new ImplicitSourceVariableIterator((ElementCS)csExp);
        while (it.hasNext()) {
            Variable variable;
            lastVariable = variable = (Variable)it.next();
            Type type = variable.getType();
            if (type == null || !type.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)requiredType)) continue;
            return variable;
        }
        return lastVariable;
    }

    @Nullable
    protected List<NamedElement> getInvocations(@NonNull Type asType, @NonNull String name, int iteratorCount, int expressionCount) {
        Type instanceType;
        Stereotype asStereotype;
        Iterable instanceOperations = this.metaModelManager.getAllOperations((DomainType)asType, FeatureFilter.SELECT_NON_STATIC, name);
        List<NamedElement> invocations = this.getInvocationsInternal(null, instanceOperations, iteratorCount, expressionCount);
        if (asType instanceof ElementExtension && (asStereotype = ((ElementExtension)asType).getStereotype()) != null) {
            Iterable stereotypeOperations = this.metaModelManager.getAllOperations((DomainType)asStereotype, FeatureFilter.SELECT_NON_STATIC, name);
            invocations = this.getInvocationsInternal(invocations, stereotypeOperations, iteratorCount, expressionCount);
        }
        if (asType instanceof Metaclass && (instanceType = ((Metaclass)asType).getInstanceType()) != null) {
            Iterable classOperations = this.metaModelManager.getAllOperations((DomainType)instanceType, FeatureFilter.SELECT_STATIC, name);
            invocations = this.getInvocationsInternal(invocations, classOperations, iteratorCount, expressionCount);
        }
        return invocations;
    }

    @Nullable
    protected List<NamedElement> getInvocationsInternal(@Nullable List<NamedElement> invocations, @NonNull Iterable<? extends DomainOperation> allOperations, int iteratorCount, int expressionCount) {
        for (DomainOperation domainOperation : allOperations) {
            Operation candidateOperation;
            int operationsSize;
            Iteration asOperation = null;
            if (domainOperation instanceof Iteration) {
                Iteration candidateIteration = (Iteration)domainOperation;
                int iteratorsSize = candidateIteration.getOwnedIterator().size();
                if (iteratorCount == 0 || iteratorCount == iteratorsSize) {
                    asOperation = candidateIteration;
                }
            } else if (domainOperation instanceof Operation && expressionCount == (operationsSize = (candidateOperation = (Operation)domainOperation).getOwnedParameter().size())) {
                asOperation = candidateOperation;
            }
            if (asOperation == null) continue;
            if (invocations == null) {
                invocations = new ArrayList<NamedElement>();
            }
            invocations.add((NamedElement)asOperation);
        }
        return invocations;
    }

    protected boolean isInvalidType(@Nullable Type type) {
        return type == null || type instanceof InvalidType || type instanceof CollectionType && ((CollectionType)type).getElementType() instanceof InvalidType;
    }

    @NonNull
    protected OperationCallExp refreshOperationCallExp(@NonNull InvocationExpCS csInvocationExp, @NonNull OCLExpression sourceExp) {
        OperationCallExp callExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csInvocationExp);
        callExp.setSource(sourceExp);
        return callExp;
    }

    @NonNull
    protected OppositePropertyCallExp refreshOppositePropertyCallExp(@NonNull NameExpCS csNameExp, @NonNull OCLExpression sourceExp, @NonNull Property property) {
        OppositePropertyCallExp callExp = (OppositePropertyCallExp)((CS2PivotConversion)this.context).refreshModelElement(OppositePropertyCallExp.class, PivotPackage.Literals.OPPOSITE_PROPERTY_CALL_EXP, (ModelElementCS)csNameExp);
        callExp.setSource(sourceExp);
        callExp.setReferredProperty(property.getOpposite());
        return callExp;
    }

    @NonNull
    protected PropertyCallExp refreshPropertyCallExp(@NonNull NameExpCS csNameExp, @NonNull OCLExpression sourceExp, @NonNull Property property) {
        PropertyCallExp callExp = (PropertyCallExp)((CS2PivotConversion)this.context).refreshModelElement(PropertyCallExp.class, PivotPackage.Literals.PROPERTY_CALL_EXP, (ModelElementCS)csNameExp);
        callExp.setSource(sourceExp);
        callExp.setReferredProperty(property);
        return callExp;
    }

    protected void resolveAtPre(@Nullable NameExpCS csNameExp, @NonNull FeatureCallExp featureCallExp) {
        if (csNameExp != null) {
            featureCallExp.setIsPre(csNameExp.isAtPre());
        }
    }

    @Nullable
    protected OCLExpression resolveBestInvocation(@Nullable OCLExpression sourceExp, @NonNull InvocationExpCS csInvocationExp, @NonNull List<NamedElement> invocations) {
        Iteration iteration = this.getBestIteration(invocations);
        if (iteration != null) {
            if (sourceExp == null) {
                sourceExp = this.createImplicitSourceVariableExp(csInvocationExp, iteration.getOwningType());
            }
            LoopExp iterationCallExp = this.resolveIterationCallExp(csInvocationExp, sourceExp, iteration);
            NamedElement namedElement = csInvocationExp.getNamedElement();
            this.resolveIterationContent(csInvocationExp, iterationCallExp);
            return iterationCallExp;
        }
        Operation exampleOperation = this.getExampleOperation(invocations);
        if (exampleOperation != null) {
            if (sourceExp == null) {
                sourceExp = this.createImplicitSourceVariableExp(csInvocationExp, exampleOperation.getOwningType());
            }
            OperationCallExp operationCallExp = this.refreshOperationCallExp(csInvocationExp, sourceExp);
            if (invocations.size() == 1) {
                ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, exampleOperation);
            }
            this.resolveOperationArgumentTypes(csInvocationExp);
            NamedElement namedElement = csInvocationExp.getNamedElement();
            if (namedElement instanceof Operation) {
                return this.resolveOperationCallExp(csInvocationExp, operationCallExp, (Operation)namedElement);
            }
        }
        return null;
    }

    @NonNull
    protected EnumLiteralExp resolveEnumLiteral(@NonNull ExpCS csExp, @NonNull EnumerationLiteral enumerationLiteral) {
        EnumLiteralExp expression = (EnumLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(EnumLiteralExp.class, PivotPackage.Literals.ENUM_LITERAL_EXP, (ModelElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)enumerationLiteral.getEnumeration(), true);
        expression.setReferredEnumLiteral(enumerationLiteral);
        return expression;
    }

    @NonNull
    protected OCLExpression resolveExplicitSourceNavigation(@NonNull OCLExpression sourceExp, @NonNull NameExpCS csNamedExp) {
        NamedElement namedElement = csNamedExp.getNamedElement();
        if (namedElement instanceof Property && !namedElement.eIsProxy()) {
            CallExp callExp = this.resolvePropertyCallExp(sourceExp, csNamedExp, (Property)namedElement);
            return callExp;
        }
        PropertyCallExp expression = this.refreshPropertyCallExp(csNamedExp, sourceExp, this.metaModelManager.getOclInvalidProperty());
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclInvalidType(), false);
        return expression;
    }

    @NonNull
    protected OCLExpression resolveImplicitAsSet(@NonNull OCLExpression sourceExp, @NonNull Type sourceType, @NonNull NavigationOperatorCS csOperator) {
        OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, null);
        expression.setImplicit(true);
        PivotUtil.resetContainer((EObject)sourceExp);
        expression.setSource(sourceExp);
        expression.setName("oclAsSet");
        this.resolveOperationCall(expression, csOperator, new ImplicitCollectionFilter(sourceType));
        return expression;
    }

    @Nullable
    protected IteratorExp resolveImplicitCollectExp(@NonNull OCLExpression sourceExp, @NonNull AbstractNameExpCS csElement) {
        OperatorCS parent = csElement.getParent();
        if (!(parent instanceof NavigationOperatorCS)) {
            return null;
        }
        if (parent.getSource() == csElement) {
            return null;
        }
        NavigationOperatorCS navigationOperatorCS = (NavigationOperatorCS)parent;
        if (!".".equals(navigationOperatorCS.getName())) {
            return null;
        }
        Type actualSourceType = sourceExp.getType();
        if (!(actualSourceType instanceof CollectionType)) {
            return null;
        }
        Type elementType = ((CollectionType)actualSourceType).getElementType();
        if (elementType == null) {
            return null;
        }
        IteratorExp implicitCollectExp = (IteratorExp)((CS2PivotConversion)this.context).refreshModelElement(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, null);
        implicitCollectExp.setSource(sourceExp);
        implicitCollectExp.setImplicit(true);
        EReference eReference = PivotPackage.Literals.LOOP_EXP__REFERRED_ITERATION;
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)eReference, "collect");
        environmentView.addFilter((ScopeFilter)new ImplicitCollectFilter((CollectionType)actualSourceType, elementType));
        Type lowerBoundType = (Type)PivotUtil.getLowerBound((Element)actualSourceType);
        environmentView.computeLookups((Element)lowerBoundType, null);
        Iteration resolvedIteration = (Iteration)environmentView.getContent();
        if (resolvedIteration == null) {
            return null;
        }
        ((CS2PivotConversion)this.context).setReferredIteration((LoopExp)implicitCollectExp, resolvedIteration);
        Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, null);
        Parameter resolvedIterator = (Parameter)resolvedIteration.getOwnedIterator().get(0);
        iterator.setRepresentedParameter(resolvedIterator);
        ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, "1_");
        ((CS2PivotConversion)this.context).setType((TypedElement)iterator, elementType, false);
        iterator.setImplicit(true);
        implicitCollectExp.getIterator().add(iterator);
        return implicitCollectExp;
    }

    @NonNull
    protected OCLExpression resolveInvocation(@Nullable OCLExpression sourceExp, @NonNull InvocationExpCS csInvocationExp) {
        List<NamedElement> invocations = this.getInvocations(sourceExp, csInvocationExp);
        if (invocations != null) {
            OCLExpression invocationExp = this.resolveBestInvocation(sourceExp, csInvocationExp, invocations);
            if (invocationExp != null) {
                return invocationExp;
            }
        } else {
            this.checkForInvalidImplicitSourceType(csInvocationExp);
            csInvocationExp.getNamedElement();
        }
        if (sourceExp == null) {
            sourceExp = this.createImplicitSourceVariableExp(csInvocationExp, (Type)this.metaModelManager.getOclAnyType());
        }
        OperationCallExp operationCallExp = this.refreshOperationCallExp(csInvocationExp, sourceExp);
        ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, this.metaModelManager.getOclInvalidOperation());
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInvocationExp, (Element)operationCallExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)operationCallExp, (Type)this.metaModelManager.getOclInvalidType(), false);
        return operationCallExp;
    }

    protected void resolveIterationAccumulators(@NonNull InvocationExpCS csInvocationExp, @NonNull LoopExp expression) {
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotAccumulators = new ArrayList<Variable>();
        for (NavigatingArgCS csArgument : csInvocationExp.getArgument()) {
            if (csArgument.getRole() != NavigationRole.ACCUMULATOR) continue;
            ExpCS csName = csArgument.getName();
            Variable acc = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csName);
            if (acc != null) {
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)acc);
                ExpCS csInit = csArgument.getInit();
                if (csInit != null) {
                    OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csInit);
                    acc.setInitExpression(initExpression);
                    TypedRefCS csAccType = csArgument.getOwnedType();
                    Type initType = initExpression.getType();
                    Type accType = csAccType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csAccType) : initType;
                    if (this.metaModelManager.isUnderspecified((ParameterableElement)initType)) {
                        initExpression.setType(accType);
                    }
                    ((CS2PivotConversion)this.context).setType((TypedElement)acc, accType, false);
                }
                acc.setRepresentedParameter((Parameter)iteration.getOwnedAccumulator().get(pivotAccumulators.size()));
                pivotAccumulators.add(acc);
            }
            if (csArgument.getInit() != null) continue;
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Missing initializer for accumulator");
        }
        if (expression instanceof IterateExp) {
            IterateExp iterateExp = (IterateExp)expression;
            if (pivotAccumulators.size() > 1) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, "Iterate '" + csInvocationExp.getPathName() + "' cannot have more than one accumulator");
            } else {
                iterateExp.setResult((Variable)pivotAccumulators.get(0));
            }
        } else if (pivotAccumulators.size() > 0) {
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, "Iteration '" + csInvocationExp.getPathName() + "' cannot have an accumulator");
        }
    }

    protected void resolveIterationBody(@NonNull InvocationExpCS csInvocationExp, @NonNull LoopExp expression) {
        ArrayList<OCLExpression> pivotBodies = new ArrayList<OCLExpression>();
        for (NavigatingArgCS csArgument : csInvocationExp.getArgument()) {
            if (csArgument.getRole() != NavigationRole.EXPRESSION) continue;
            if (csArgument.getInit() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for expression");
            }
            if (csArgument.getOwnedType() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected type for expression");
            }
            ExpCS name = csArgument.getName();
            assert (name != null);
            OCLExpression exp = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)name);
            if (exp != null) {
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)exp);
                pivotBodies.add(exp);
                continue;
            }
            pivotBodies.add(((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csArgument, "Invalid '" + csInvocationExp.getPathName() + "' iteration body"));
        }
        if (pivotBodies.size() != 1) {
            expression.setBody(((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csInvocationExp, "Iteration '" + csInvocationExp.getPathName() + "' must have exactly one body"));
        } else {
            expression.setBody((OCLExpression)pivotBodies.get(0));
        }
    }

    @NonNull
    protected LoopExp resolveIterationCallExp(@NonNull InvocationExpCS csInvocationExp, @NonNull OCLExpression sourceExp, @NonNull Iteration iteration) {
        LoopExp expression = iteration.getOwnedAccumulator().size() > 0 ? (LoopExp)((CS2PivotConversion)this.context).refreshModelElement(IterateExp.class, PivotPackage.Literals.ITERATE_EXP, (ModelElementCS)csInvocationExp) : (LoopExp)((CS2PivotConversion)this.context).refreshModelElement(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, (ModelElementCS)csInvocationExp);
        expression.setSource(sourceExp);
        ((CS2PivotConversion)this.context).setReferredIteration(expression, iteration);
        return expression;
    }

    protected void resolveIterationContent(@NonNull InvocationExpCS csInvocationExp, @NonNull LoopExp expression) {
        OCLExpression source = (OCLExpression)DomainUtil.nonNullState((Object)expression.getSource());
        this.resolveIterationIterators(csInvocationExp, source, expression);
        this.resolveIterationAccumulators(csInvocationExp, expression);
        this.resolveOperationArgumentTypes(csInvocationExp);
        this.resolveIterationBody(csInvocationExp, expression);
        this.resolveOperationReturnType((CallExp)expression);
    }

    protected void resolveIterationIterators(@NonNull InvocationExpCS csInvocationExp, @NonNull OCLExpression source, @NonNull LoopExp expression) {
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotIterators = new ArrayList<Variable>();
        int iterationIteratorsSize = iteration.getOwnedIterator().size();
        Type sourceType = ((CollectionType)csInvocationExp.getSourceType()).getElementType();
        Type sourceElementType = sourceType != null ? this.metaModelManager.getPrimaryType((DomainType)sourceType) : null;
        int argIndex = 0;
        while (argIndex < csInvocationExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csInvocationExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ITERATOR) {
                if (iterationIteratorsSize <= argIndex) {
                    ((CS2PivotConversion)this.context).addWarning((ModelElementCS)csArgument, OCLMessages.RedundantIterator_WARNING_, new Object[]{iteration.getName()});
                } else {
                    ExpCS csName;
                    Variable iterator;
                    if (csArgument.getInit() != null) {
                        ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for iterator");
                    }
                    if ((iterator = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)(csName = csArgument.getName()))) != null) {
                        Type varType;
                        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)iterator);
                        iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterator().get(pivotIterators.size()));
                        TypedRefCS csType = csArgument.getOwnedType();
                        Type type = varType = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : sourceElementType;
                        if (varType == null) {
                            varType = sourceElementType;
                        }
                        ((CS2PivotConversion)this.context).setType((TypedElement)iterator, varType, false);
                        pivotIterators.add(iterator);
                    }
                }
            }
            ++argIndex;
        }
        while (pivotIterators.size() < iterationIteratorsSize) {
            String varName = String.valueOf(Integer.toString(pivotIterators.size() + 1)) + "_";
            Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, null);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, varName);
            ((CS2PivotConversion)this.context).setType((TypedElement)iterator, sourceElementType, false);
            iterator.setImplicit(true);
            iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterator().get(pivotIterators.size()));
            pivotIterators.add(iterator);
        }
        ((CS2PivotConversion)this.context).refreshList(expression.getIterator(), pivotIterators);
    }

    protected void resolveOperationArgumentTypes(@NonNull InvocationExpCS csInvocationExp) {
        int argIndex = 0;
        for (NavigatingArgCS csArgument : csInvocationExp.getArgument()) {
            if (csArgument.getRole() == NavigationRole.ITERATOR || csArgument.getRole() == NavigationRole.ACCUMULATOR) break;
            if (csArgument.getRole() != NavigationRole.EXPRESSION) continue;
            ExpCS csName = csArgument.getName();
            if (csName != null) {
                OCLExpression arg;
                Type type;
                List parameters;
                Operation operation;
                Element callExp;
                PathNameCS csPathName;
                if (csName instanceof NameExpCS && (csPathName = ((NameExpCS)csName).getPathName()) != null && (callExp = csInvocationExp.getPivot()) instanceof OperationCallExp && (operation = ((OperationCallExp)callExp).getReferredOperation()) != null && argIndex < (parameters = operation.getOwnedParameter()).size() && (type = ((Parameter)parameters.get(argIndex)).getType()) instanceof Metaclass) {
                    CS2Pivot.setElementType((PathNameCS)csPathName, (EClass)PivotPackage.Literals.NAMED_ELEMENT, (ElementCS)csName, (ScopeFilter)TypeArgumentFilter.INSTANCE);
                }
                if ((arg = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csName)) != null) {
                    ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)arg);
                }
            }
            ++argIndex;
        }
    }

    protected void resolveOperationArguments(@NonNull InvocationExpCS csInvocationExp, @NonNull Operation operation, @NonNull OperationCallExp expression) {
        ArrayList<OCLExpression> pivotArguments = new ArrayList<OCLExpression>();
        EList<NavigatingArgCS> csArguments = csInvocationExp.getArgument();
        List ownedParameters = operation.getOwnedParameter();
        int parametersCount = ownedParameters.size();
        int csArgumentCount = csArguments.size();
        if (csArgumentCount > 0) {
            if (((NavigatingArgCS)csArguments.get(0)).getRole() != NavigationRole.EXPRESSION) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, "Operation calls can only specify expressions");
            }
            int argIndex = 0;
            while (argIndex < csArgumentCount) {
                OCLExpression arg;
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(argIndex);
                if (csArgument.getInit() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for expression");
                }
                if (csArgument.getOwnedType() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected type for expression");
                }
                if ((arg = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csArgument)) != null) {
                    pivotArguments.add(arg);
                }
                ++argIndex;
            }
        }
        if (csArgumentCount != parametersCount && operation != this.metaModelManager.basicGetOclInvalidOperation()) {
            String boundMessage = DomainUtil.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{csArgumentCount, parametersCount});
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, boundMessage);
        }
        ((CS2PivotConversion)this.context).refreshList(expression.getArgument(), pivotArguments);
    }

    protected void resolveOperationCall(@NonNull OperationCallExp expression, @NonNull OperatorCS csOperator, @NonNull ScopeFilter filter) {
        EReference eReference = PivotPackage.Literals.OPERATION_CALL_EXP__REFERRED_OPERATION;
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)eReference, expression.getName());
        environmentView.addFilter(filter);
        Type sourceType = PivotUtil.getType((TypedElement)expression.getSource());
        int size = 0;
        if (sourceType != null) {
            Type lowerBoundType = (Type)PivotUtil.getLowerBound((Element)sourceType);
            size = environmentView.computeLookups((Element)lowerBoundType, null);
        }
        if (size == 1) {
            Operation operation = (Operation)environmentView.getContent();
            ((CS2PivotConversion)this.context).setReferredOperation(expression, operation);
            this.resolveOperationReturnType((CallExp)expression);
        } else {
            StringBuilder s = new StringBuilder();
            for (OCLExpression argument : expression.getArgument()) {
                Type argumentType = PivotUtil.getType((TypedElement)argument);
                if (s.length() > 0) {
                    s.append(",");
                }
                if (argumentType == null) continue;
                s.append(argumentType.toString());
            }
            String boundMessage = s.length() > 0 ? DomainUtil.bind((String)OCLMessages.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{csOperator, sourceType, s.toString()}) : DomainUtil.bind((String)OCLMessages.UnresolvedOperation_ERROR_, (Object[])new Object[]{csOperator, sourceType});
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csOperator, boundMessage);
            ((CS2PivotConversion)this.context).setReferredOperation(expression, this.metaModelManager.getOclInvalidOperation());
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclInvalidType(), false);
        }
    }

    @NonNull
    protected OperationCallExp resolveOperationCallExp(@NonNull InvocationExpCS csInvocationExp, @NonNull OperationCallExp operationCallExp, @NonNull Operation operation) {
        ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, operation);
        this.resolveAtPre(csInvocationExp.getNameExp(), (FeatureCallExp)operationCallExp);
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInvocationExp, (Element)operationCallExp);
        this.resolveOperationArguments(csInvocationExp, operation, operationCallExp);
        this.resolveOperationReturnType((CallExp)operationCallExp);
        return operationCallExp;
    }

    protected void resolveOperationReturnType(@NonNull CallExp callExp) {
        OCLExpression body;
        Type bodyType;
        Type returnType;
        List parameters;
        String implementationClass;
        Operation operation = null;
        if (callExp instanceof OperationCallExp) {
            operation = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof LoopExp) {
            operation = ((LoopExp)callExp).getReferredIteration();
        }
        if (operation == null) {
            return;
        }
        HashMap<TemplateParameter, Type> templateBindings = new HashMap<TemplateParameter, Type>();
        Type sourceType = null;
        OCLExpression source = callExp.getSource();
        if (source != null) {
            sourceType = source.getType();
        }
        if (sourceType != null) {
            if (operation.isStatic() && sourceType instanceof Metaclass) {
                sourceType = ((Metaclass)sourceType).getInstanceType();
            }
            templateBindings.put(null, sourceType);
        }
        PivotUtil.getAllTemplateParameterSubstitutions(templateBindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = operation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                templateBindings.put(templateParameter, null);
            }
        }
        if ((implementationClass = operation.getImplementationClass()) != null && implementationClass.equals(CollectionFlattenOperation.class.getName())) {
            Type elementType = sourceType;
            while (elementType instanceof CollectionType) {
                elementType = ((CollectionType)elementType).getElementType();
            }
            if (elementType != null) {
                templateBindings.put((TemplateParameter)operation.getOwnedTemplateSignature().getOwnedParameter().get(0), elementType);
            }
        }
        boolean isConformant = true;
        if (callExp instanceof OperationCallExp) {
            parameters = operation.getOwnedParameter();
            List arguments = ((OperationCallExp)callExp).getArgument();
            int iMax = Math.min(parameters.size(), arguments.size());
            int i = 0;
            while (i < iMax) {
                Parameter parameter = (Parameter)parameters.get(i);
                OCLExpression argument = (OCLExpression)arguments.get(i);
                Type parameterType = PivotUtil.getType((TypedElement)parameter);
                Type argumentType = PivotUtil.getType((TypedElement)argument);
                if (parameterType != null && argumentType != null && !this.metaModelManager.conformsTo(argumentType, parameterType, templateBindings)) {
                    isConformant = false;
                }
                ++i;
            }
        } else if (callExp instanceof LoopExp) {
            List accumulators;
            if (callExp instanceof IterateExp && (accumulators = ((Iteration)operation).getOwnedAccumulator()).size() >= 1) {
                Parameter accumulator = (Parameter)accumulators.get(0);
                Variable result = ((IterateExp)callExp).getResult();
                Type accumulatorType = PivotUtil.getType((TypedElement)accumulator);
                Type resultType = PivotUtil.getType((TypedElement)result);
                if (accumulatorType != null && resultType != null && !this.metaModelManager.conformsTo(resultType, accumulatorType, templateBindings)) {
                    isConformant = false;
                }
            }
            if ((parameters = ((Iteration)operation).getOwnedParameter()).size() >= 1) {
                Parameter parameter = (Parameter)parameters.get(0);
                OCLExpression body2 = ((LoopExp)callExp).getBody();
                Type parameterType = PivotUtil.getType((TypedElement)parameter);
                Type bodyType2 = PivotUtil.getType((TypedElement)body2);
                if (bodyType2 != null && parameterType != null && !this.metaModelManager.conformsTo(bodyType2, parameterType, templateBindings)) {
                    isConformant = false;
                }
            }
        }
        Type behavioralType = PivotUtil.getType((TypedElement)operation);
        Type type = returnType = behavioralType != null ? this.metaModelManager.getSpecializedType(behavioralType, templateBindings) : null;
        if (operation instanceof Iteration && "collect".equals(operation.getName()) && callExp instanceof LoopExp && returnType instanceof CollectionType && (bodyType = PivotUtil.getType((TypedElement)(body = ((LoopExp)callExp).getBody()))) != null && bodyType instanceof CollectionType) {
            Type elementType = bodyType;
            while (elementType instanceof CollectionType) {
                Type elementType2 = ((CollectionType)elementType).getElementType();
                if (elementType2 == null) continue;
                elementType = elementType2;
            }
            boolean isOrdered = ((CollectionType)returnType).isOrdered();
            returnType = this.metaModelManager.getCollectionType(isOrdered, false, elementType, null, null);
        }
        if (operation.isStatic() && behavioralType != null && behavioralType.getOwningTemplateParameter() != null && returnType != null) {
            returnType = this.metaModelManager.getMetaclass((DomainType)returnType);
        }
        ((CS2PivotConversion)this.context).setType((TypedElement)callExp, returnType, operation.isRequired());
    }

    @NonNull
    protected CallExp resolvePropertyCallExp(@NonNull OCLExpression sourceExp, @NonNull NameExpCS csNameExp, @NonNull Property property) {
        Object callExp = property.isImplicit() ? this.refreshOppositePropertyCallExp(csNameExp, sourceExp, property) : this.refreshPropertyCallExp(csNameExp, sourceExp, property);
        this.resolveAtPre(csNameExp, (FeatureCallExp)callExp);
        Type returnType = this.resolvePropertyReturnType(sourceExp, csNameExp, property);
        ((CS2PivotConversion)this.context).setType((TypedElement)callExp, returnType, property.isRequired());
        return callExp;
    }

    protected Type resolvePropertyReturnType(@NonNull OCLExpression sourceExp, @NonNull NameExpCS csNameExp, @NonNull Property property) {
        HashMap<TemplateParameter, Type> templateBindings = new HashMap<TemplateParameter, Type>();
        Type sourceType = sourceExp.getType();
        if (sourceType != null) {
            if (property.isStatic() && sourceType instanceof Metaclass) {
                sourceType = ((Metaclass)sourceType).getInstanceType();
            }
            templateBindings.put(null, sourceType);
            Type owningType = property.getOwningType();
            if (owningType instanceof Metaclass) {
                owningType = (Type)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)owningType);
                templateBindings.put((TemplateParameter)owningType.getOwnedTemplateSignature().getOwnedParameter().get(0), sourceType);
            }
        }
        PivotUtil.getAllTemplateParameterSubstitutions(templateBindings, (TemplateableElement)sourceType);
        Type returnType = null;
        Type behavioralType = PivotUtil.getType((TypedElement)property);
        if (behavioralType != null) {
            returnType = this.metaModelManager.getSpecializedType(behavioralType, templateBindings);
            if (property.isStatic() && behavioralType.getOwningTemplateParameter() != null) {
                returnType = this.metaModelManager.getMetaclass((DomainType)returnType);
            }
        }
        return returnType;
    }

    protected StateExp resolveStateExp(@NonNull ExpCS csExp, @NonNull State state) {
        StateExp expression = (StateExp)((CS2PivotConversion)this.context).refreshModelElement(StateExp.class, PivotPackage.Literals.STATE_EXP, (ModelElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, this.metaModelManager.getPivotType("State"), true);
        expression.setReferredState(state);
        return expression;
    }

    @NonNull
    protected TypeExp resolveTypeExp(@NonNull ExpCS csExp, @NonNull Type type) {
        TypeExp expression = (TypeExp)((CS2PivotConversion)this.context).refreshModelElement(TypeExp.class, PivotPackage.Literals.TYPE_EXP, (ModelElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getMetaclass((DomainType)type), true);
        expression.setReferredType(type);
        return expression;
    }

    @NonNull
    protected VariableExp resolveVariableExp(@NonNull AbstractNameExpCS csNameExp, @NonNull VariableDeclaration variableDeclaration) {
        VariableExp expression = (VariableExp)((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (ModelElementCS)csNameExp);
        expression.setReferredVariable(variableDeclaration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, variableDeclaration.getType(), variableDeclaration.isRequired());
        return expression;
    }

    @Override
    @NonNull
    public Element visitBinaryOperatorCS(@NonNull BinaryOperatorCS csOperator) {
        OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csOperator);
        String name = csOperator.getName();
        assert (name != null);
        ((CS2PivotConversion)this.context).refreshName((NamedElement)expression, name);
        ExpCS csSource = csOperator.getSource();
        if (csSource != null) {
            OCLExpression source = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csSource);
            expression.setSource(source);
            ExpCS csArgument = csOperator.getArgument();
            if (csArgument != null) {
                OCLExpression argument = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csArgument);
                List<Object> newElements = argument != null ? Collections.singletonList(argument) : Collections.emptyList();
                ((CS2PivotConversion)this.context).refreshList(expression.getArgument(), newElements);
                Type sourceType = PivotUtil.getType((TypedElement)source);
                Type argumentType = PivotUtil.getType((TypedElement)argument);
                if (sourceType != null && argumentType != null) {
                    this.resolveOperationCall(expression, csOperator, new BinaryOperationFilter(sourceType, argumentType));
                }
            }
        }
        return expression;
    }

    @Override
    public Element visitBooleanLiteralExpCS(@NonNull BooleanLiteralExpCS csBooleanLiteralExp) {
        BooleanLiteralExp expression = (BooleanLiteralExp)PivotUtil.getPivot(BooleanLiteralExp.class, (Pivotable)csBooleanLiteralExp);
        if (expression != null) {
            expression.setBooleanSymbol(Boolean.valueOf(csBooleanLiteralExp.getName()).booleanValue());
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getBooleanType(), true);
        }
        return expression;
    }

    @Override
    public Element visitCollectionLiteralExpCS(@NonNull CollectionLiteralExpCS csCollectionLiteralExp) {
        Type commonType = null;
        for (CollectionLiteralPartCS csPart : csCollectionLiteralExp.getOwnedParts()) {
            assert (csPart != null);
            CollectionLiteralPart pivotPart = (CollectionLiteralPart)((CS2PivotConversion)this.context).visitLeft2Right(CollectionLiteralPart.class, (ElementCS)csPart);
            Type type = pivotPart.getType();
            if (type == null) continue;
            if (commonType == null) {
                commonType = type;
                continue;
            }
            if (commonType == type) continue;
            commonType = this.metaModelManager.getCommonType(commonType, type, null);
        }
        CollectionLiteralExp expression = (CollectionLiteralExp)PivotUtil.getPivot(CollectionLiteralExp.class, (Pivotable)csCollectionLiteralExp);
        if (expression != null) {
            CollectionTypeCS ownedCollectionType = csCollectionLiteralExp.getOwnedType();
            String collectionTypeName = ownedCollectionType.getName();
            assert (collectionTypeName != null);
            TypedRefCS ownedElementType = ownedCollectionType.getOwnedType();
            if (ownedElementType != null) {
                commonType = (Type)ownedElementType.getPivot();
            }
            if (commonType == null) {
                commonType = this.metaModelManager.createUnspecifiedType();
            }
            Type type = this.metaModelManager.getCollectionType(collectionTypeName, commonType, null, null);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, type, true);
            expression.setKind(PivotUtil.getCollectionKind((CollectionType)((CollectionType)type)));
        }
        return expression;
    }

    @Override
    public Element visitCollectionLiteralPartCS(@NonNull CollectionLiteralPartCS csCollectionLiteralPart) {
        CollectionLiteralPart expression;
        OCLExpression pivotLast;
        Type type;
        CollectionItem expression2;
        ExpCS csFirst = csCollectionLiteralPart.getExpressionCS();
        if (csFirst == null) {
            return null;
        }
        OCLExpression pivotFirst = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csFirst);
        ExpCS csLast = csCollectionLiteralPart.getLastExpressionCS();
        if (csLast == null) {
            expression2 = (CollectionItem)PivotUtil.getPivot(CollectionItem.class, (Pivotable)csCollectionLiteralPart);
            if (expression2 != null) {
                expression2.setItem(pivotFirst);
            }
        } else {
            expression2 = (CollectionRange)PivotUtil.getPivot(CollectionRange.class, (Pivotable)csCollectionLiteralPart);
            if (expression2 != null) {
                expression2.setFirst(pivotFirst);
                OCLExpression pivotLast2 = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csLast);
                expression2.setLast(pivotLast2);
            }
        }
        if ((type = pivotFirst.getType()) == null) {
            return null;
        }
        boolean isRequired = pivotFirst.isRequired();
        if (csLast != null && (pivotLast = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csLast)) != null) {
            Type secondType = pivotLast.getType();
            if (secondType != null) {
                type = this.metaModelManager.getCommonType(type, secondType, null);
            }
            isRequired &= pivotLast.isRequired();
        }
        if ((expression = (CollectionLiteralPart)PivotUtil.getPivot(CollectionLiteralPart.class, (Pivotable)csCollectionLiteralPart)) != null) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, type, isRequired);
        }
        return expression;
    }

    @Override
    public Element visitCollectionTypeCS(@NonNull CollectionTypeCS object) {
        return null;
    }

    @Override
    public Element visitConstructorExpCS(@NonNull ConstructorExpCS csConstructorExp) {
        ConstructorExp expression = (ConstructorExp)PivotUtil.getPivot(ConstructorExp.class, (Pivotable)csConstructorExp);
        if (expression != null) {
            expression.setType((Type)csConstructorExp.getNamedElement());
            for (ConstructorPartCS csPart : csConstructorExp.getOwnedParts()) {
                assert (csPart != null);
                ((CS2PivotConversion)this.context).visitLeft2Right(ConstructorPart.class, (ElementCS)csPart);
            }
        }
        return expression;
    }

    @Override
    public Element visitConstructorPartCS(@NonNull ConstructorPartCS csConstructorPart) {
        ConstructorPart pivotElement = (ConstructorPart)PivotUtil.getPivot(ConstructorPart.class, (Pivotable)csConstructorPart);
        if (pivotElement != null) {
            Property property = csConstructorPart.getProperty();
            pivotElement.setReferredProperty(property);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)pivotElement, property.getName());
            ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, property.getType(), property.isRequired());
            ExpCS csInitExpression = csConstructorPart.getInitExpression();
            if (csInitExpression != null) {
                OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csInitExpression);
                pivotElement.setInitExpression(initExpression);
            }
        }
        return pivotElement;
    }

    @Override
    public Element visitContextCS(@NonNull ContextCS csContext) {
        ExpressionInOCL pivotElement = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csContext);
        if (pivotElement != null) {
            pivotElement.getLanguage().clear();
            pivotElement.getBody().clear();
            ExpCS csExpression = csContext.getOwnedExpression();
            if (csExpression != null) {
                pivotElement.getLanguage().add("OCL");
                pivotElement.getBody().add(csExpression.toString());
                OCLExpression expression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csExpression);
                if (expression != null) {
                    PivotUtil.setBody((ExpressionInOCL)pivotElement, (OCLExpression)expression, (String)ElementUtil.getExpressionText((ElementCS)csExpression));
                    ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, expression.getType(), expression.isRequired());
                }
            }
        }
        return pivotElement;
    }

    @Override
    public Element visitExpCS(@NonNull ExpCS object) {
        return null;
    }

    @Override
    public Element visitIfExpCS(@NonNull IfExpCS csIfExp) {
        IfExp expression = (IfExp)PivotUtil.getPivot(IfExp.class, (Pivotable)csIfExp);
        if (expression != null) {
            ExpCS csIf = csIfExp.getCondition();
            ExpCS csThen = csIfExp.getThenExpression();
            ExpCS csElse = csIfExp.getElseExpression();
            if (csIf != null && csThen != null && csElse != null) {
                expression.setCondition((OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csIf));
                OCLExpression thenExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csThen);
                expression.setThenExpression(thenExpression);
                OCLExpression elseExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csElse);
                expression.setElseExpression(elseExpression);
                Type thenType = thenExpression != null ? thenExpression.getType() : null;
                Type elseType = elseExpression != null ? elseExpression.getType() : null;
                Type commonType = thenType != null && elseType != null ? this.metaModelManager.getCommonType(thenType, elseType, null) : null;
                boolean isRequired = thenExpression != null && thenExpression.isRequired() && elseExpression != null && elseExpression.isRequired();
                ((CS2PivotConversion)this.context).setType((TypedElement)expression, commonType, isRequired);
            }
        }
        return expression;
    }

    @Override
    public Element visitIndexExpCS(@NonNull IndexExpCS csIndexExp) {
        return null;
    }

    @Override
    public Element visitInfixExpCS(@NonNull InfixExpCS csInfixExp) {
        OperatorCS csRoot = (OperatorCS)csInfixExp.getOwnedOperator().get(0);
        OperatorCS csParent = csRoot.getParent();
        while (csParent != null) {
            csRoot = csParent;
            csParent = csParent.getParent();
        }
        OCLExpression pivot = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csRoot);
        if (pivot != null) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInfixExp, (Element)pivot);
        }
        return pivot;
    }

    @Override
    public Element visitInvalidLiteralExpCS(@NonNull InvalidLiteralExpCS csInvalidLiteralExp) {
        InvalidLiteralExp expression = (InvalidLiteralExp)PivotUtil.getPivot(InvalidLiteralExp.class, (Pivotable)csInvalidLiteralExp);
        if (expression == null) {
            expression = this.metaModelManager.createInvalidExpression();
        }
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInvalidLiteralExp, (Element)expression);
        return expression;
    }

    @Override
    public Element visitInvocationExpCS(@NonNull InvocationExpCS csInvocationExp) {
        OperatorCS csParent = csInvocationExp.getParent();
        if (csParent instanceof NavigationOperatorCS && csInvocationExp != csParent.getSource()) {
            return PivotUtil.getPivot(OCLExpression.class, (Pivotable)csInvocationExp);
        }
        return this.resolveInvocation(null, csInvocationExp);
    }

    @Override
    public Element visitLetExpCS(@NonNull LetExpCS csLetExp) {
        ExpCS csIn;
        LetExp letExp;
        LetExp firstLetExp = null;
        LetExp lastLetExp = null;
        for (LetVariableCS csLetVariable : csLetExp.getVariable()) {
            Type variableType;
            Variable variable = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csLetVariable);
            if (variable == null) continue;
            EObject variableContainer = variable.eContainer();
            letExp = variableContainer instanceof LetExp ? (LetExp)variableContainer : (LetExp)((CS2PivotConversion)this.context).refreshModelElement(LetExp.class, PivotPackage.Literals.LET_EXP, null);
            letExp.setVariable(variable);
            ExpCS csInitExpression = csLetVariable.getInitExpression();
            if (csInitExpression == null) continue;
            OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csInitExpression);
            variable.setInitExpression(initExpression);
            Type initType = initExpression != null ? initExpression.getType() : null;
            boolean isRequired = variable.isRequired() && initExpression != null && initExpression.isRequired();
            TypedRefCS csVariableType = csLetVariable.getOwnedType();
            Type type = variableType = csVariableType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csVariableType) : null;
            if (variableType == null) {
                variableType = initType;
            } else if (initExpression != null && this.metaModelManager.isUnderspecified((ParameterableElement)initType)) {
                initExpression.setType(variableType);
            }
            ((CS2PivotConversion)this.context).setType((TypedElement)variable, variableType, isRequired);
            if (lastLetExp != null) {
                lastLetExp.setIn((OCLExpression)letExp);
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csLetExp, (Element)letExp);
            } else {
                firstLetExp = letExp;
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csLetExp, (Element)firstLetExp);
            }
            lastLetExp = letExp;
        }
        if (lastLetExp != null && (csIn = csLetExp.getIn()) != null) {
            OCLExpression in = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csIn);
            lastLetExp.setIn(in);
            if (in != null) {
                Type type = in.getType();
                letExp = firstLetExp;
                while (letExp != in && letExp != null) {
                    ((CS2PivotConversion)this.context).setType((TypedElement)letExp, type, in.isRequired());
                    letExp = letExp.getIn();
                }
            }
        }
        return firstLetExp;
    }

    @Override
    public Element visitLetVariableCS(@NonNull LetVariableCS csLetVariable) {
        return null;
    }

    @Override
    public Element visitNameExpCS(@NonNull NameExpCS csNameExp) {
        this.checkForInvalidImplicitSourceType(csNameExp);
        NamedElement element = csNameExp.getNamedElement();
        if (element == null || element.eIsProxy()) {
            Element pivot = csNameExp.getPivot();
            if (pivot instanceof InvalidLiteralExp) {
                return pivot;
            }
            InvalidLiteralExp invalidLiteralExp = this.metaModelManager.createInvalidExpression();
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNameExp, (Element)invalidLiteralExp);
            return invalidLiteralExp;
        }
        if (element instanceof VariableDeclaration) {
            return this.resolveVariableExp(csNameExp, (VariableDeclaration)element);
        }
        if (element instanceof Property) {
            Property property = (Property)element;
            OCLExpression sourceExp = this.createImplicitSourceVariableExp(csNameExp, property.getOwningType());
            return this.resolvePropertyCallExp(sourceExp, csNameExp, property);
        }
        if (element instanceof Operation) {
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "No parameters for operation " + ((Operation)element).getName());
        }
        if (element instanceof Type) {
            return this.resolveTypeExp(csNameExp, (Type)element);
        }
        if (element instanceof EnumerationLiteral) {
            return this.resolveEnumLiteral(csNameExp, (EnumerationLiteral)element);
        }
        if (element instanceof State) {
            return this.resolveStateExp(csNameExp, (State)element);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "Unsupported NameExpCS " + element.eClass().getName());
    }

    @Override
    public Element visitNavigatingArgCS(@NonNull NavigatingArgCS csNavigatingArg) {
        OCLExpression pivot = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csNavigatingArg.getName());
        if (pivot != null) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNavigatingArg, (Element)pivot);
        }
        return pivot;
    }

    @Override
    public OCLExpression visitNavigationOperatorCS(@NonNull NavigationOperatorCS csOperator) {
        OCLExpression navigatingExp = null;
        ExpCS csSource = csOperator.getSource();
        if (csSource != null) {
            Type actualSourceType;
            OCLExpression sourceExp = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csSource);
            if (sourceExp != null && (actualSourceType = PivotUtil.getType((TypedElement)sourceExp)) != null) {
                ExpCS argument = csOperator.getArgument();
                if (argument instanceof AbstractNameExpCS) {
                    AbstractNameExpCS csNameExp = (AbstractNameExpCS)argument;
                    IteratorExp implicitCollectExp = null;
                    OCLExpression collectedSourceExp = sourceExp;
                    String navigationOperatorName = csOperator.getName();
                    if (actualSourceType instanceof CollectionType) {
                        if (".".equals(navigationOperatorName) && (implicitCollectExp = this.resolveImplicitCollectExp(sourceExp, csNameExp)) != null) {
                            Variable iterator = (Variable)implicitCollectExp.getIterator().get(0);
                            collectedSourceExp = this.createImplicitVariableExp((VariableDeclaration)iterator);
                        }
                    } else if ("->".equals(navigationOperatorName)) {
                        collectedSourceExp = this.resolveImplicitAsSet(sourceExp, actualSourceType, csOperator);
                    }
                    csNameExp.setSourceType(collectedSourceExp.getType());
                    OCLExpression callExp = csNameExp instanceof InvocationExpCS ? this.resolveInvocation(collectedSourceExp, (InvocationExpCS)csNameExp) : (argument instanceof NameExpCS ? this.resolveExplicitSourceNavigation(collectedSourceExp, (NameExpCS)argument) : ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)argument, "bad navigation argument"));
                    if (callExp instanceof CallExp) {
                        if (implicitCollectExp != null) {
                            implicitCollectExp.setBody(callExp);
                            this.resolveOperationReturnType((CallExp)implicitCollectExp);
                            navigatingExp = implicitCollectExp;
                        } else {
                            navigatingExp = callExp;
                        }
                    } else {
                        navigatingExp = callExp;
                    }
                } else if (argument != null) {
                    navigatingExp = ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)argument, "bad navigation argument");
                }
            }
            if (navigatingExp != null) {
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csOperator, navigatingExp);
            }
        }
        return navigatingExp;
    }

    @Override
    public Element visitNestedExpCS(@NonNull NestedExpCS csNestedExp) {
        ExpCS csSource = csNestedExp.getSource();
        if (csSource == null) {
            return null;
        }
        OCLExpression pivot = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csSource);
        if (pivot != null) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNestedExp, (Element)pivot);
        }
        return pivot;
    }

    @Override
    public Element visitNullLiteralExpCS(@NonNull NullLiteralExpCS csNullLiteralExp) {
        NullLiteralExp expression = (NullLiteralExp)PivotUtil.getPivot(NullLiteralExp.class, (Pivotable)csNullLiteralExp);
        if (expression != null) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclVoidType(), false);
        }
        return expression;
    }

    @Override
    public Element visitNumberLiteralExpCS(@NonNull NumberLiteralExpCS csNumberLiteralExp) {
        NumericLiteralExp expression = (NumericLiteralExp)PivotUtil.getPivot(NumericLiteralExp.class, (Pivotable)csNumberLiteralExp);
        if (expression instanceof UnlimitedNaturalLiteralExp) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getUnlimitedNaturalType(), true);
        } else if (expression instanceof IntegerLiteralExp) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getIntegerType(), true);
        } else if (expression != null) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getRealType(), true);
        }
        return expression;
    }

    @Override
    public Element visitOperatorCS(@NonNull OperatorCS object) {
        return null;
    }

    @Override
    public Element visitPrefixExpCS(@NonNull PrefixExpCS csPrefixExp) {
        OCLExpression pivotElement;
        UnaryOperatorCS csRoot = (UnaryOperatorCS)csPrefixExp.getOwnedOperator().get(0);
        if (csRoot == null) {
            return null;
        }
        if (!(csPrefixExp.eContainer() instanceof InfixExpCS)) {
            ((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csRoot);
        }
        if ((pivotElement = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csRoot)) != null) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csPrefixExp, (Element)pivotElement);
        }
        return pivotElement;
    }

    @Override
    public Element visitSelfExpCS(@NonNull SelfExpCS csSelfExp) {
        ElementCS parent;
        VariableExp expression = (VariableExp)PivotUtil.getPivot(VariableExp.class, (Pivotable)csSelfExp);
        if (expression != null && (parent = csSelfExp.getLogicalParent()) != null) {
            EReference eReference = PivotPackage.Literals.EXPRESSION_IN_OCL__CONTEXT_VARIABLE;
            EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)eReference, "self");
            BaseScopeView baseScopeView = BaseScopeView.getScopeView((MetaModelManager)this.metaModelManager, (ElementCS)parent, (EReference)eReference);
            environmentView.computeLookups((ScopeView)baseScopeView);
            VariableDeclaration variableDeclaration = (VariableDeclaration)environmentView.getContent();
            if (variableDeclaration == null) {
                return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csSelfExp, "The context of 'self' is unspecified");
            }
            expression.setReferredVariable(variableDeclaration);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, variableDeclaration.getType(), true);
        }
        return expression;
    }

    @Override
    public Element visitStringLiteralExpCS(@NonNull StringLiteralExpCS csStringLiteralExp) {
        StringLiteralExp pivotElement = (StringLiteralExp)PivotUtil.getPivot(StringLiteralExp.class, (Pivotable)csStringLiteralExp);
        if (pivotElement != null) {
            ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, (Type)this.metaModelManager.getStringType(), true);
        }
        return pivotElement;
    }

    @Override
    public Element visitTupleLiteralExpCS(@NonNull TupleLiteralExpCS csTupleLiteralExp) {
        TupleLiteralExp expression = (TupleLiteralExp)PivotUtil.getPivot(TupleLiteralExp.class, (Pivotable)csTupleLiteralExp);
        if (expression != null) {
            for (TupleLiteralPartCS csPart : csTupleLiteralExp.getOwnedParts()) {
                assert (csPart != null);
                ((CS2PivotConversion)this.context).visitLeft2Right(TupleLiteralPart.class, (ElementCS)csPart);
            }
            String tupleTypeName = "Tuple";
            List parts = expression.getPart();
            assert (parts != null);
            TupleType type = this.metaModelManager.getTupleType(tupleTypeName, (Collection)parts, null);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)type, true);
        }
        return expression;
    }

    @Override
    public Element visitTupleLiteralPartCS(@NonNull TupleLiteralPartCS csTupleLiteralPart) {
        ExpCS csInitExpression;
        TupleLiteralPart pivotElement = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csTupleLiteralPart);
        if (pivotElement != null && (csInitExpression = csTupleLiteralPart.getInitExpression()) != null) {
            OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csInitExpression);
            pivotElement.setInitExpression(initExpression);
            TypedRefCS csType = csTupleLiteralPart.getOwnedType();
            Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initExpression.getType();
            ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, type, initExpression.isRequired());
        }
        return pivotElement;
    }

    @Override
    public Element visitTypeLiteralExpCS(@NonNull TypeLiteralExpCS csTypeLiteralExp) {
        TypedRefCS csType = csTypeLiteralExp.getOwnedType();
        Type type = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType);
        return type != null ? this.resolveTypeExp(csTypeLiteralExp, type) : null;
    }

    @Override
    public Element visitUnaryOperatorCS(@NonNull UnaryOperatorCS csOperator) {
        OCLExpression source;
        OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csOperator);
        String name = csOperator.getName();
        assert (name != null);
        ((CS2PivotConversion)this.context).refreshName((NamedElement)expression, name);
        ExpCS csSource = csOperator.getSource();
        if (csSource != null && (source = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csSource)) != null) {
            expression.setSource(source);
            Type sourceType = PivotUtil.getType((TypedElement)source);
            if (sourceType != null) {
                this.resolveOperationCall(expression, csOperator, new UnaryOperationFilter(sourceType));
            }
        }
        return expression;
    }

    @Override
    public Element visitUnlimitedNaturalLiteralExpCS(@NonNull UnlimitedNaturalLiteralExpCS csUnlimitedNaturalLiteralExp) {
        UnlimitedNaturalLiteralExp expression = (UnlimitedNaturalLiteralExp)PivotUtil.getPivot(UnlimitedNaturalLiteralExp.class, (Pivotable)csUnlimitedNaturalLiteralExp);
        if (expression != null) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getUnlimitedNaturalType(), true);
        }
        return expression;
    }

    @Override
    public Element visitVariableCS(@NonNull VariableCS csVariable) {
        Variable variable = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csVariable);
        if (variable != null) {
            OCLExpression initExpression = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csVariable.getInitExpression());
            if (initExpression != null) {
                Type initType = initExpression.getType();
                TypedRefCS csType = csVariable.getOwnedType();
                Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initType;
                if (this.metaModelManager.isUnderspecified((ParameterableElement)initType)) {
                    initExpression.setType(type);
                }
                ((CS2PivotConversion)this.context).setType((TypedElement)variable, type, initExpression.isRequired());
            }
            variable.setInitExpression(initExpression);
        }
        return variable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeArgumentFilter
    implements ScopeFilter {
        public static TypeArgumentFilter INSTANCE = new TypeArgumentFilter();

        private TypeArgumentFilter() {
        }

        public int compareMatches(@NonNull MetaModelManager metaModelManager, @NonNull Object match1, @Nullable Map<TemplateParameter, ParameterableElement> bindings1, @NonNull Object match2, @Nullable Map<TemplateParameter, ParameterableElement> bindings2) {
            return 0;
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
            if (object instanceof Type) {
                return true;
            }
            if (object instanceof TypedElement) {
                return ((TypedElement)object).getType() instanceof Metaclass;
            }
            return false;
        }
    }
}

