/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.AbstractNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.OperatorCS;

public class NavigationUtil {
    @Nullable
    public static NavigationOperatorCS getNavigationOperator(@NonNull AbstractNameExpCS csExp) {
        EObject eContainer = csExp.eContainer();
        if (eContainer instanceof AbstractNameExpCS) {
            csExp = (AbstractNameExpCS)eContainer;
        }
        ExpCS csChild = csExp;
        OperatorCS csOperator;
        while ((csOperator = csChild.getParent()) != null) {
            ExpCS csSource = csOperator.getSource();
            if (csSource != csChild) {
                if (csOperator instanceof NavigationOperatorCS) {
                    return (NavigationOperatorCS)csOperator;
                }
                return null;
            }
            csChild = csChild.getParent();
        }
        return null;
    }

    public static boolean isIteration(@NonNull MetaModelManager metaModelManager, @NonNull InvocationExpCS csInvocationExp, @NonNull CollectionType type) {
        for (NavigatingArgCS csArg : csInvocationExp.getArgument()) {
            if (csArg.getRole() == NavigationRole.EXPRESSION) continue;
            return true;
        }
        PathNameCS pathName = csInvocationExp.getPathName();
        EList path = pathName.getPath();
        if (path.size() != 1) {
            return false;
        }
        PathElementCS csPathElement = (PathElementCS)path.get(0);
        Element unresolvedElement = csPathElement.basicGetElement();
        if (unresolvedElement != null && !unresolvedElement.eIsProxy()) {
            return unresolvedElement instanceof Iteration;
        }
        String name = csPathElement.toString();
        assert (name != null);
        Iterator iterator = metaModelManager.getAllOperations((DomainType)type, FeatureFilter.SELECT_NON_STATIC, name).iterator();
        if (iterator.hasNext()) {
            DomainOperation operation = (DomainOperation)iterator.next();
            return operation instanceof Iteration;
        }
        return false;
    }
}

