/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferencesObservableValue
extends AbstractObservableValue
implements IPropertyChangeListener {
    protected String key;
    protected IPreferenceStore store;

    public PreferencesObservableValue(String key, IPreferenceStore store) {
        this.key = key;
        this.store = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue() {
        if (this.store.contains(this.key)) {
            return this.store.getString(this.key);
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (value instanceof String) {
            this.store.setValue(this.key, (String)value);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.key)) {
            this.fireValueChange(Diffs.createValueDiff((Object)event.getOldValue(), (Object)event.getNewValue()));
        }
    }

    public void dispose() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }
}

