/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.modelelement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.creation.PropertyEditorFactory;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;

public abstract class AbstractModelElement
implements ModelElement {
    protected DataSource dataSource;
    private final Map<String, IObservable> observables = new HashMap<String, IObservable>();

    protected AbstractModelElement() {
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        return EmptyContentProvider.instance;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        return null;
    }

    public boolean isOrdered(String propertyPath) {
        return true;
    }

    public boolean isUnique(String propertyPath) {
        return false;
    }

    public boolean isMandatory(String propertyPath) {
        return false;
    }

    public boolean isEditable(String propertyPath) {
        return true;
    }

    public boolean forceRefresh(String propertyPath) {
        return false;
    }

    public void setDataSource(DataSource source) {
        this.dataSource = source;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        return new PropertyEditorFactory();
    }

    public Object getDefaultValue(String propertyPath) {
        return null;
    }

    public boolean getDirectCreation(String propertyPath) {
        return false;
    }

    public final IObservable getObservable(String propertyPath) {
        IObservable observable;
        if (!this.observables.containsKey(propertyPath) && (observable = this.doGetObservable(propertyPath)) != null) {
            this.observables.put(propertyPath, observable);
        }
        return this.observables.get(propertyPath);
    }

    protected abstract IObservable doGetObservable(String var1);

    public void dispose() {
        for (IObservable observable : this.observables.values()) {
            observable.dispose();
        }
        this.observables.clear();
    }

    public IValidator getValidator(String propertyPath) {
        return null;
    }
}

