/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.creation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.emf.utils.EClassNameComparator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.creation.CreateInDialog;
import org.eclipse.papyrus.views.properties.creation.CreationContext;
import org.eclipse.papyrus.views.properties.creation.PropertyEditorFactory;
import org.eclipse.papyrus.views.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcorePropertyEditorFactory
extends PropertyEditorFactory {
    protected EClass type;
    protected EClass eClass;
    protected String nsUri;
    protected String className;
    protected EReference referenceIn;
    protected IStaticContentProvider containerContentProvider;
    protected CreateInFeatureContentProvider referenceContentProvider;
    protected ILabelProvider containerLabelProvider;
    protected ILabelProvider referenceLabelProvider;
    protected Map<EObject, CreateIn> createIn = new HashMap<EObject, CreateIn>();

    public EcorePropertyEditorFactory(EReference referenceIn) {
        if (referenceIn == null) {
            throw new IllegalArgumentException("The referenceIn parameter must be set");
        }
        this.referenceIn = referenceIn;
        this.type = referenceIn.getEReferenceType();
    }

    public String getNsUri() {
        return this.nsUri;
    }

    public String getClassName() {
        return this.className;
    }

    public void setNsUri(String nsUri) {
        this.nsUri = nsUri;
        this.checkEClass();
    }

    public void setClassName(String className) {
        this.className = className;
        this.checkEClass();
    }

    private void checkEClass() {
        if (this.nsUri != null && this.className != null) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.nsUri);
            if (ePackage == null) {
                Activator.log.warn("Cannot find the EPackage corresponding to URI " + this.nsUri);
            }
            this.eClass = (EClass)ePackage.getEClassifier(this.className);
            if (this.eClass == null) {
                Activator.log.warn("Cannot find the EClass " + this.className + " in the package " + this.nsUri);
            }
        }
    }

    @Override
    public boolean canCreateObject() {
        return true;
    }

    @Override
    public final Object createObject(Control widget, Object context) {
        Object result;
        ResourceSet previous = NestedEditingDialogContext.getInstance().push(context);
        try {
            result = this.doCreateObject(widget, context);
        }
        finally {
            NestedEditingDialogContext.getInstance().pop(previous);
        }
        return result;
    }

    protected Object doCreateObject(Control widget, Object context) {
        EObject instance = this.referenceIn.isContainment() ? this.simpleCreateObject(widget) : this.createObjectInDifferentContainer(widget);
        return this.createObject(widget, context, instance);
    }

    @Override
    protected Object doEdit(final Control widget, final Object source, final Set<View> views, final String dialogTitle) {
        Object result;
        try {
            NestedEditingDialogContext.getInstance().enter();
            try {
                result = this.getOperationExecutor(source).execute((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return EcorePropertyEditorFactory.this.basicDoEdit(widget, source, views, dialogTitle);
                    }
                }, dialogTitle);
            }
            finally {
                NestedEditingDialogContext.getInstance().exit();
            }
        }
        catch (OperationCanceledException e) {
            if (!NestedEditingDialogContext.getInstance().isNested()) {
                throw e;
            }
            result = null;
        }
        return result;
    }

    protected final Object basicDoEdit(Control widget, Object source, Set<View> views, String dialogTitle) {
        return super.doEdit(widget, source, views, dialogTitle);
    }

    @Override
    protected void handleEditCancelled(Control widget, Object source) {
        throw new OperationCanceledException();
    }

    protected EObject simpleCreateObject(Control widget) {
        EClass eClass = this.chooseEClass(widget);
        if (eClass == null) {
            return null;
        }
        EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
        return instance;
    }

    protected EObject createObjectInDifferentContainer(Control widget) {
        EObject instance = this.simpleCreateObject(widget);
        if (instance == null) {
            return null;
        }
        ResourceSet containerInput = NestedEditingDialogContext.getInstance().getResourceSet();
        if (containerInput == null) {
            containerInput = instance;
        }
        this.containerContentProvider.inputChanged(null, null, (Object)containerInput);
        this.referenceContentProvider.setType(instance.eClass());
        CreateInDialog dialog = new CreateInDialog(widget.getShell(), instance);
        dialog.setProviders(this.containerContentProvider, this.referenceContentProvider, this.containerLabelProvider, this.referenceLabelProvider);
        dialog.setTitle(this.getCreationDialogTitle());
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        CreateIn createIn = new CreateIn();
        createIn.createInObject = dialog.getContainer();
        createIn.createInReference = dialog.getContainmentReference();
        this.createIn.put(instance, createIn);
        return instance;
    }

    protected EClass chooseEClass(Control widget) {
        EClass eClass;
        if (this.eClass != null) {
            return this.eClass;
        }
        List<EClass> availableClasses = this.getAvailableEClasses();
        if (availableClasses.isEmpty()) {
            return null;
        }
        if (availableClasses.size() == 1) {
            this.className = availableClasses.get(0).getName();
            return availableClasses.get(0);
        }
        Menu menu = new Menu(widget);
        for (EClass eClass2 : availableClasses) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(eClass2.getName());
            item.setData("eClass", (Object)eClass2);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EcorePropertyEditorFactory.this.eClass = (EClass)item.getData("eClass");
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        menu.setVisible(true);
        Display display = widget.getDisplay();
        while (menu.isVisible()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable ex) {
                Activator.log.error(ex);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
        if ((eClass = this.eClass) != null) {
            this.className = eClass.getName();
        }
        this.eClass = null;
        return eClass;
    }

    protected List<EClass> getAvailableEClasses() {
        List availableEClasses = EMFHelper.getSubclassesOf((EClass)this.type, (boolean)true);
        Collections.sort(availableEClasses, new EClassNameComparator());
        return availableEClasses;
    }

    @Override
    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        if (!this.referenceIn.isContainment()) {
            for (Object objectToValidate : objectsToValidate) {
                CreateIn creationInformation = this.createIn.get(objectToValidate);
                if (creationInformation != null) {
                    creationInformation.createInObject.eSet((EStructuralFeature)creationInformation.createInReference, objectToValidate);
                    continue;
                }
                Activator.log.warn("Unknown object : " + objectToValidate);
            }
        }
        return objectsToValidate;
    }

    @Override
    public String getCreationDialogTitle() {
        return String.valueOf(Messages.EcorePropertyEditorFactory_CreateANew) + this.className;
    }

    @Override
    public String getEditionDialogTitle(Object objectToEdit) {
        if (objectToEdit instanceof EObject) {
            return "Edit " + ((EObject)objectToEdit).eClass().getName();
        }
        return super.getEditionDialogTitle(objectToEdit);
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.setContainerLabelProvider(labelProvider);
        this.setReferenceLabelProvider(labelProvider);
    }

    public void setReferenceLabelProvider(ILabelProvider labelProvider) {
        this.referenceLabelProvider = labelProvider;
    }

    public void setContainerLabelProvider(ILabelProvider labelProvider) {
        this.containerLabelProvider = labelProvider;
    }

    public void setContainerContentProvider(IStaticContentProvider contentProvider) {
        this.containerContentProvider = contentProvider;
    }

    public void setReferenceContentProvider(CreateInFeatureContentProvider contentProvider) {
        this.referenceContentProvider = contentProvider;
    }

    @Override
    protected CreationContext getCreationContext(Object element) {
        return element instanceof EObject ? EcorePropertyEditorFactory.getCreationContext((EObject)element, true) : super.getCreationContext(element);
    }

    public static CreationContext getCreationContext(EObject modelElement, boolean demandCreate) {
        CreationContext result = (CreationContext)EcoreUtil.getExistingAdapter((Notifier)modelElement, CreationContext.class);
        if (result == null && demandCreate) {
            class EObjectCreationContext
            extends AdapterImpl
            implements CreationContext {
                private EObject context;
                private List<Object> createdElements = new ArrayList<Object>(2);

                EObjectCreationContext(EObject context) {
                    this.context = context;
                    context.eAdapters().add((Object)this);
                }

                public boolean isAdapterForType(Object type) {
                    return type == CreationContext.class;
                }

                public Object getCreationContextElement() {
                    return this.context;
                }

                public void popCreatedElement(Object newElement) {
                    if (this.createdElements.remove(newElement)) {
                        ((Notifier)newElement).eAdapters().remove((Object)this);
                        if (this.createdElements.isEmpty()) {
                            this.context.eAdapters().remove((Object)this);
                        }
                    }
                }

                public void pushCreatedElement(Object newElement) {
                    this.createdElements.add(newElement);
                    ((Notifier)newElement).eAdapters().add((Object)this);
                }
            }
            result = new EObjectCreationContext(modelElement);
        }
        return result;
    }

    protected class CreateIn {
        public EReference createInReference;
        public EObject createInObject;

        protected CreateIn() {
        }
    }
}

