/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.log.OMLogger;

public class Logger
implements OMLogger {
    private OMBundle bundle;

    public Logger(OMBundle bundle) {
        this.bundle = bundle;
    }

    public OMBundle getBundle() {
        return this.bundle;
    }

    public void log(OMLogger.Level level, String msg, Throwable t) {
        ((AbstractPlatform)this.bundle.getPlatform()).log(this, level, msg, t);
    }

    public void error(String msg, Throwable t) {
        this.log(OMLogger.Level.ERROR, msg, t);
    }

    public void warn(String msg, Throwable t) {
        this.log(OMLogger.Level.WARN, msg, t);
    }

    public void info(String msg, Throwable t) {
        this.log(OMLogger.Level.INFO, msg, t);
    }

    public void debug(String msg, Throwable t) {
        this.log(OMLogger.Level.DEBUG, msg, t);
    }

    public void log(OMLogger.Level level, String msg) {
        this.log(level, msg, null);
    }

    public void error(String msg) {
        this.log(OMLogger.Level.ERROR, msg);
    }

    public void warn(String msg) {
        this.log(OMLogger.Level.WARN, msg);
    }

    public void info(String msg) {
        this.log(OMLogger.Level.INFO, msg);
    }

    public void debug(String msg) {
        this.log(OMLogger.Level.DEBUG, msg);
    }

    public void log(OMLogger.Level level, Throwable t) {
        if (t != null) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.getClass().getSimpleName();
            }
            this.log(level, msg, t);
        }
    }

    public void error(Throwable t) {
        this.log(OMLogger.Level.ERROR, t);
    }

    public void warn(Throwable t) {
        this.log(OMLogger.Level.WARN, t);
    }

    public void info(Throwable t) {
        this.log(OMLogger.Level.INFO, t);
    }

    public void debug(Throwable t) {
        this.log(OMLogger.Level.DEBUG, t);
    }
}

