/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_LIFECYCLE, LifecycleUtil.class);

    private LifecycleUtil() {
    }

    public static boolean isDeferredActivation(Object object) {
        if (object instanceof ILifecycle.DeferrableActivation) {
            return ((ILifecycle.DeferrableActivation)object).isDeferredActivation();
        }
        return false;
    }

    public static LifecycleState getLifecycleState(Object object) {
        if (object instanceof ILifecycle) {
            return ((ILifecycle)object).getLifecycleState();
        }
        return LifecycleState.ACTIVE;
    }

    public static boolean isActive(Object object) {
        if (object instanceof ILifecycle) {
            return ((ILifecycle)object).isActive();
        }
        return object != null;
    }

    public static void checkActive(Object object) throws LifecycleException {
        if (!LifecycleUtil.isActive(object)) {
            throw new LifecycleException("Not active: " + object);
        }
    }

    public static void checkInactive(Object object) throws LifecycleException {
        if (LifecycleUtil.isActive(object)) {
            throw new LifecycleException("Not inactive: " + object);
        }
    }

    public static void activate(Object object) throws LifecycleException {
        LifecycleUtil.activate(object, false);
    }

    public static void activate(Object object, boolean useAnnotation) throws LifecycleException {
        if (object instanceof ILifecycle) {
            ((ILifecycle)object).activate();
        } else if (object != null && useAnnotation) {
            LifecycleUtil.invokeAnnotation(object, Activator.class);
        }
    }

    public static Exception activateSilent(Object object) {
        return LifecycleUtil.activateSilent(object, false);
    }

    public static Exception activateSilent(Object object, boolean useAnnotation) {
        try {
            LifecycleUtil.activate(object, useAnnotation);
            return null;
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
            return ex;
        }
    }

    public static boolean waitForActive(Object object, long millis) {
        return LifecycleUtil.waitFor(object, millis, LifecycleState.ACTIVE);
    }

    public static boolean waitForInactive(Object object, long millis) {
        return LifecycleUtil.waitFor(object, millis, LifecycleState.INACTIVE);
    }

    public static boolean waitFor(Object object, long millis, final LifecycleState state) {
        block6: {
            ILifecycle lifecycle;
            block7: {
                try {
                    if (!(object instanceof ILifecycle)) break block6;
                    lifecycle = (ILifecycle)object;
                    if (lifecycle.getLifecycleState() != state) break block7;
                    return true;
                }
                catch (Exception ex) {
                    throw WrappedException.wrap(ex);
                }
            }
            final CountDownLatch latch = new CountDownLatch(1);
            IListener adapter = new IListener(){

                public void notifyEvent(IEvent event) {
                    ILifecycleEvent e;
                    if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getSource().getLifecycleState() == state) {
                        latch.countDown();
                    }
                }
            };
            try {
                lifecycle.addListener(adapter);
                latch.await(millis, TimeUnit.MILLISECONDS);
            }
            finally {
                lifecycle.removeListener(adapter);
            }
            return lifecycle.getLifecycleState() == state;
        }
        return true;
    }

    public static Exception deactivate(Object object) {
        return LifecycleUtil.deactivate(object, false);
    }

    public static Exception deactivate(Object object, boolean useAnnotation) {
        if (object instanceof ILifecycle) {
            return ((ILifecycle)object).deactivate();
        }
        if (object != null && useAnnotation) {
            LifecycleUtil.invokeAnnotation(object, Deactivator.class);
        }
        return null;
    }

    public static void deactivate(Object object, OMLogger.Level logLevel) {
        Exception exception = LifecycleUtil.deactivate(object);
        if (exception != null) {
            OM.LOG.log(logLevel, "Problem while deactivating " + object, exception);
        }
    }

    public static void deactivateNoisy(Object object) throws LifecycleException {
        LifecycleUtil.deactivateNoisy(object, false);
    }

    public static void deactivateNoisy(Object object, boolean useAnnotation) throws LifecycleException {
        Exception ex = LifecycleUtil.deactivate(object, useAnnotation);
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex != null) {
            throw new LifecycleException(ex);
        }
    }

    public static <T> T delegateLifecycle(ClassLoader loader, T pojo, Class<?> pojoInterface, ILifecycle delegate) {
        return Delegator.newProxy(loader, pojo, pojoInterface, delegate);
    }

    public static <T> T delegateLifecycle(ClassLoader loader, T pojo, ILifecycle delegate) {
        return Delegator.newProxy(loader, pojo, pojo.getClass(), delegate);
    }

    private static <T extends Annotation> void invokeAnnotation(Object object, Class<T> annotationClass) {
        Class<?> c = object.getClass();
        while (c != Object.class) {
            Method[] methods;
            Method[] methodArray = methods = c.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                T annotation;
                Method method = methodArray[n2];
                if (method.getParameterTypes().length == 0 && (annotation = method.getAnnotation(annotationClass)) != null) {
                    boolean propagate;
                    LifecycleUtil.invokeMethod(object, method);
                    boolean bl = propagate = annotationClass == Activator.class ? ((Activator)annotation).propagate() : ((Deactivator)annotation).propagate();
                    if (!propagate) break;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
    }

    private static Object invokeMethod(Object object, Method method) {
        block6: {
            try {
                return method.invoke(object, null);
            }
            catch (IllegalAccessException iae) {
                try {
                    method.setAccessible(true);
                    return method.invoke(object, null);
                }
                catch (Exception ex) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace(ex);
                    }
                }
            }
            catch (Exception ex) {
                if (!TRACER.isEnabled()) break block6;
                TRACER.trace(ex);
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Activator {
        public boolean propagate() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Deactivator {
        public boolean propagate() default true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Delegator<T>
    implements InvocationHandler {
        private static final Class<ILifecycle> INTERFACE = ILifecycle.class;
        private T pojo;
        private ILifecycle delegate;

        public Delegator(T pojo, ILifecycle delegate) {
            this.pojo = pojo;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("activate")) {
                this.delegate.activate();
                return null;
            }
            if (name.equals("deactivate")) {
                return this.delegate.deactivate();
            }
            if (name.equals("isActive")) {
                return this.delegate.isActive();
            }
            if (name.equals("getLifecycleState")) {
                return this.delegate.getLifecycleState();
            }
            if (name.equals("getListeners")) {
                return this.delegate.getListeners();
            }
            if (name.equals("hasListeners")) {
                return this.delegate.hasListeners();
            }
            if (name.equals("addListener")) {
                this.delegate.addListener((IListener)args[0]);
                return null;
            }
            if (name.equals("removeListener")) {
                this.delegate.removeListener((IListener)args[0]);
                return null;
            }
            return method.invoke(this.pojo, args);
        }

        public static <T> T newProxy(ClassLoader loader, T pojo, Class<?> pojoInterface, ILifecycle delegate) {
            if (pojo == null) {
                return pojo;
            }
            Delegator<T> h = new Delegator<T>(pojo, delegate);
            Class[] interfaces = new Class[]{pojoInterface, INTERFACE};
            Object proxy = Proxy.newProxyInstance(loader, interfaces, h);
            return (T)proxy;
        }
    }
}

