/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.XMLOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOServerExporter<OUT> {
    private InternalRepository repository;

    public CDOServerExporter(IRepository repository) {
        this.repository = (InternalRepository)repository;
    }

    public final IRepository getRepository() {
        return this.repository;
    }

    public final void exportRepository(OutputStream out) throws Exception {
        boolean wasActive = LifecycleUtil.isActive((Object)this.repository);
        if (!wasActive) {
            LifecycleUtil.activate((Object)this.repository);
        }
        InternalSession session = this.repository.getSessionManager().openSession(null);
        StoreThreadLocal.setSession(session);
        try {
            OUT output = this.createOutput(out);
            this.exportAll(output);
        }
        finally {
            StoreThreadLocal.release();
            if (!wasActive) {
                LifecycleUtil.deactivate((Object)this.repository);
            }
            this.repository = null;
        }
    }

    protected abstract OUT createOutput(OutputStream var1) throws Exception;

    protected void exportAll(OUT out) throws Exception {
        try {
            this.exportPackages(out);
            this.exportBranches(out);
            this.exportLobs(out);
            this.exportCommits(out);
        }
        catch (WrappedException ex) {
            throw WrappedException.unwrap((Exception)((Object)ex));
        }
    }

    protected void exportPackages(OUT out) throws Exception {
        InternalCDOPackageUnit[] packageUnits;
        InternalCDOPackageRegistry packageRegistry = this.repository.getPackageRegistry(false);
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits = packageRegistry.getPackageUnits(false);
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            String id = packageUnit.getID();
            CDOPackageUnit.Type type = packageUnit.getOriginalType();
            long time = packageUnit.getTimeStamp();
            EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
            String data = new String(EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)false, (EPackage.Registry)packageRegistry));
            this.startPackageUnit(out, id, type, time, data);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n3 = internalCDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                String packageURI = packageInfo.getPackageURI();
                this.exportPackageInfo(out, packageURI);
                ++n4;
            }
            this.endPackageUnit(out);
            ++n2;
        }
    }

    protected abstract void startPackageUnit(OUT var1, String var2, CDOPackageUnit.Type var3, long var4, String var6) throws Exception;

    protected abstract void endPackageUnit(OUT var1) throws Exception;

    protected abstract void exportPackageInfo(OUT var1, String var2) throws Exception;

    protected void exportBranches(final OUT out) throws Exception {
        InternalCDOBranchManager branchManager = this.repository.getBranchManager();
        this.exportBranch(out, (CDOBranch)branchManager.getMainBranch());
        if (this.repository.isSupportingBranches()) {
            branchManager.getBranches(0, 0, new CDOBranchHandler(){

                public void handleBranch(CDOBranch branch) {
                    try {
                        CDOServerExporter.this.exportBranch(out, branch);
                    }
                    catch (Exception ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
            });
        }
    }

    protected void exportBranch(OUT out, CDOBranch branch) throws Exception {
        this.exportRevisions(out, branch);
    }

    protected void exportRevisions(final OUT out, CDOBranch branch) throws Exception {
        this.repository.handleRevisions(null, branch, true, -1L, false, (CDORevisionHandler)new CDORevisionHandler.Filtered.Undetached(new CDORevisionHandler(){

            public boolean handleRevision(CDORevision revision) {
                try {
                    CDOServerExporter.this.exportRevision(out, revision);
                    return true;
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }));
    }

    protected abstract void exportRevision(OUT var1, CDORevision var2) throws Exception;

    protected void exportLobs(final OUT out) throws Exception {
        this.repository.handleLobs(0L, 0L, new CDOLobHandler(){

            public OutputStream handleBlob(byte[] id, long size) {
                try {
                    return CDOServerExporter.this.startBlob(out, id, size);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }

            public Writer handleClob(byte[] id, long size) {
                try {
                    return CDOServerExporter.this.startClob(out, id, size);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
    }

    protected abstract OutputStream startBlob(OUT var1, byte[] var2, long var3) throws Exception;

    protected abstract Writer startClob(OUT var1, byte[] var2, long var3) throws Exception;

    protected void exportCommits(final OUT out) throws Exception {
        InternalCDOCommitInfoManager commitInfoManager = this.repository.getCommitInfoManager();
        commitInfoManager.getCommitInfos(null, 0L, 0L, new CDOCommitInfoHandler(){

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                try {
                    CDOServerExporter.this.exportCommit(out, commitInfo);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
    }

    protected abstract void exportCommit(OUT var1, CDOCommitInfo var2) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XML
    extends CDOServerExporter<XMLOutput>
    implements XMLConstants {
        public XML(IRepository repository) {
            super(repository);
        }

        @Override
        protected final XMLOutput createOutput(OutputStream out) throws Exception {
            return new XMLOutput(out);
        }

        @Override
        protected void exportAll(XMLOutput out) throws Exception {
            out.element("repository");
            out.attribute("name", (Object)this.getRepository().getName());
            out.attribute("uuid", (Object)this.getRepository().getUUID());
            out.attribute("root", (Object)this.str(this.getRepository().getRootResourceID()));
            out.attribute("created", (Object)this.getRepository().getStore().getCreationTime());
            out.attribute("committed", (Object)this.getRepository().getLastCommitTimeStamp());
            out.push();
            super.exportAll(out);
            out.done();
        }

        @Override
        protected void exportPackages(XMLOutput out) throws Exception {
            out.element("models");
            out.push();
            super.exportPackages(out);
            out.pop();
        }

        @Override
        protected void startPackageUnit(XMLOutput out, String id, CDOPackageUnit.Type type, long time, String data) throws Exception {
            out.element("packageUnit");
            out.attribute("id", (Object)id);
            out.attribute("type", (Object)type);
            out.attribute("time", (Object)time);
            out.attribute("data", (Object)data);
            out.push();
        }

        @Override
        protected void endPackageUnit(XMLOutput out) throws Exception {
            out.pop();
        }

        @Override
        protected void exportPackageInfo(XMLOutput out, String uri) throws Exception {
            out.element("packageInfo");
            out.attribute("uri", (Object)uri);
        }

        @Override
        protected void exportBranches(XMLOutput out) throws Exception {
            out.element("instances");
            out.push();
            super.exportBranches(out);
            out.pop();
        }

        @Override
        protected void exportBranch(XMLOutput out, CDOBranch branch) throws Exception {
            out.element("branch");
            out.attribute("id", (Object)branch.getID());
            out.attribute("name", (Object)branch.getName());
            out.attribute("time", (Object)branch.getBase().getTimeStamp());
            if (!branch.isMainBranch()) {
                out.attribute("parent", (Object)branch.getBase().getBranch().getID());
            }
            out.push();
            super.exportBranch(out, branch);
            out.pop();
        }

        @Override
        protected void exportRevision(XMLOutput out, CDORevision revision) throws Exception {
            int containingFeatureID;
            CDOID containerID;
            CDOID resourceID;
            InternalCDORevision rev = (InternalCDORevision)revision;
            out.element("revision");
            out.attribute("id", (Object)this.str(rev.getID()));
            out.attribute("class", (Object)new CDOClassifierRef((EClassifier)rev.getEClass()).getURI());
            out.attribute("version", (Object)rev.getVersion());
            out.attribute("time", (Object)rev.getTimeStamp());
            long revised = rev.getRevised();
            if (revised != 0L) {
                out.attribute("revised", (Object)revised);
            }
            if (!CDOIDUtil.isNull((CDOID)(resourceID = rev.getResourceID()))) {
                out.attribute("resource", (Object)this.str(resourceID));
            }
            if (!CDOIDUtil.isNull((CDOID)(containerID = (CDOID)rev.getContainerID()))) {
                out.attribute("container", (Object)this.str(containerID));
            }
            if ((containingFeatureID = rev.getContainingFeatureID()) != 0) {
                out.attribute("feature", (Object)containingFeatureID);
            }
            out.push();
            InternalRepository repository = (InternalRepository)this.getRepository();
            repository.ensureChunks(rev, -1);
            InternalCDOClassInfo classInfo = rev.getClassInfo();
            EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (feature.isMany()) {
                    List list = (List)rev.getValue(feature);
                    if (list != null) {
                        for (Object value : list) {
                            this.exportFeature(out, feature, value);
                        }
                    }
                } else {
                    Object value = rev.getValue(feature);
                    if (value != null) {
                        this.exportFeature(out, feature, value);
                    }
                }
                ++n2;
            }
            out.pop();
        }

        protected void exportFeature(XMLOutput out, EStructuralFeature feature, Object value) throws Exception {
            out.element("feature");
            out.attribute("name", (Object)feature.getName());
            this.exportFeature(out, feature, "type", value);
        }

        protected void exportFeature(XMLOutput out, EStructuralFeature feature, String featureType, Object value) throws SAXException {
            if (value instanceof CDOID) {
                out.attribute(featureType, (Object)Object.class.getSimpleName());
                out.attribute("value", (Object)this.str((CDOID)value));
            } else if (value instanceof CDOBlob) {
                CDOBlob blob = (CDOBlob)value;
                out.attribute(featureType, (Object)"Blob");
                out.attribute("id", (Object)HexUtil.bytesToHex((byte[])blob.getID()));
                out.attribute("size", (Object)blob.getSize());
            } else if (value instanceof CDOClob) {
                CDOClob clob = (CDOClob)value;
                out.attribute(featureType, (Object)"Clob");
                out.attribute("id", (Object)HexUtil.bytesToHex((byte[])clob.getID()));
                out.attribute("size", (Object)clob.getSize());
            } else if (value instanceof Date) {
                Date date = (Date)value;
                out.attribute(featureType, (Object)Date.class.getSimpleName());
                out.attribute("value", (Object)date.getTime());
            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature innerFeature = entry.getEStructuralFeature();
                Object innerValue = entry.getValue();
                out.attribute(featureType, (Object)"FeatureMap");
                out.attribute("innerFeature", (Object)innerFeature.getName());
                this.exportFeature(out, innerFeature, "innerType", innerValue);
            } else {
                if (!(value instanceof String)) {
                    out.attribute(featureType, (Object)this.type(value));
                }
                out.attributeOrNull("value", value);
            }
        }

        @Override
        protected void exportLobs(XMLOutput out) throws Exception {
            out.element("lobs");
            out.push();
            super.exportLobs(out);
            out.pop();
        }

        @Override
        protected OutputStream startBlob(XMLOutput out, byte[] id, long size) throws Exception {
            out.element("blob");
            out.attribute("id", (Object)HexUtil.bytesToHex((byte[])id));
            out.attribute("size", (Object)size);
            return out.bytes();
        }

        @Override
        protected Writer startClob(XMLOutput out, byte[] id, long size) throws Exception {
            out.element("clob");
            out.attribute("id", (Object)HexUtil.bytesToHex((byte[])id));
            out.attribute("size", (Object)size);
            return out.characters();
        }

        @Override
        protected void exportCommits(XMLOutput out) throws Exception {
            out.element("commits");
            out.push();
            super.exportCommits(out);
            out.pop();
        }

        @Override
        protected void exportCommit(XMLOutput out, CDOCommitInfo commitInfo) throws Exception {
            int branch;
            out.element("commit");
            out.attribute("time", (Object)commitInfo.getTimeStamp());
            long previous = commitInfo.getPreviousTimeStamp();
            if (previous != 0L) {
                out.attribute("previous", (Object)previous);
            }
            if ((branch = commitInfo.getBranch().getID()) != 0) {
                out.attribute("branch", (Object)branch);
            }
            out.attribute("user", (Object)commitInfo.getUserID());
            out.attribute("comment", (Object)commitInfo.getComment());
        }

        protected final String str(CDOID id) {
            StringBuilder builder = new StringBuilder();
            CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
            return builder.toString();
        }

        protected String type(Object value) {
            if (value instanceof Boolean) {
                return Boolean.class.getSimpleName();
            }
            if (value instanceof Character) {
                return Character.class.getSimpleName();
            }
            if (value instanceof Byte) {
                return Byte.class.getSimpleName();
            }
            if (value instanceof Short) {
                return Short.class.getSimpleName();
            }
            if (value instanceof Integer) {
                return Integer.class.getSimpleName();
            }
            if (value instanceof Long) {
                return Long.class.getSimpleName();
            }
            if (value instanceof Float) {
                return Float.class.getSimpleName();
            }
            if (value instanceof Double) {
                return Double.class.getSimpleName();
            }
            if (value instanceof String) {
                return String.class.getSimpleName();
            }
            if (value instanceof BigDecimal) {
                return BigDecimal.class.getSimpleName();
            }
            if (value instanceof BigInteger) {
                return BigInteger.class.getSimpleName();
            }
            throw new IllegalArgumentException("Invalid type: " + value.getClass().getName());
        }
    }

    public static interface XMLConstants {
        public static final String REPOSITORY = "repository";
        public static final String REPOSITORY_NAME = "name";
        public static final String REPOSITORY_UUID = "uuid";
        public static final String REPOSITORY_ROOT = "root";
        public static final String REPOSITORY_CREATED = "created";
        public static final String REPOSITORY_COMMITTED = "committed";
        public static final String MODELS = "models";
        public static final String PACKAGE_UNIT = "packageUnit";
        public static final String PACKAGE_UNIT_ID = "id";
        public static final String PACKAGE_UNIT_TYPE = "type";
        public static final String PACKAGE_UNIT_TIME = "time";
        public static final String PACKAGE_UNIT_DATA = "data";
        public static final String PACKAGE_INFO = "packageInfo";
        public static final String PACKAGE_INFO_URI = "uri";
        public static final String INSTANCES = "instances";
        public static final String BRANCH = "branch";
        public static final String BRANCH_ID = "id";
        public static final String BRANCH_NAME = "name";
        public static final String BRANCH_TIME = "time";
        public static final String BRANCH_PARENT = "parent";
        public static final String REVISION = "revision";
        public static final String REVISION_ID = "id";
        public static final String REVISION_CLASS = "class";
        public static final String REVISION_VERSION = "version";
        public static final String REVISION_TIME = "time";
        public static final String REVISION_REVISED = "revised";
        public static final String REVISION_RESOURCE = "resource";
        public static final String REVISION_CONTAINER = "container";
        public static final String REVISION_FEATURE = "feature";
        public static final String FEATURE = "feature";
        public static final String FEATURE_NAME = "name";
        public static final String FEATURE_TYPE = "type";
        public static final String FEATURE_INNER_FEATURE = "innerFeature";
        public static final String FEATURE_INNER_TYPE = "innerType";
        public static final String FEATURE_VALUE = "value";
        public static final String FEATURE_ID = "id";
        public static final String FEATURE_SIZE = "size";
        public static final String TYPE_BLOB = "Blob";
        public static final String TYPE_CLOB = "Clob";
        public static final String TYPE_FEATURE_MAP = "FeatureMap";
        public static final String LOBS = "lobs";
        public static final String LOB_ID = "id";
        public static final String LOB_SIZE = "size";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String COMMITS = "commits";
        public static final String COMMIT = "commit";
        public static final String COMMIT_TIME = "time";
        public static final String COMMIT_PREVIOUS = "previous";
        public static final String COMMIT_BRANCH = "branch";
        public static final String COMMIT_USER = "user";
        public static final String COMMIT_COMMENT = "comment";
    }
}

