/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;

public class TriggeredEventTraces {
    public List<TriggeredEvent> traces = new ArrayList<TriggeredEvent>();

    public void clear() {
        this.traces.clear();
    }

    public void addTrace(String name, Notification notification) {
        this.traces.add(new TriggeredEvent(name, notification));
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        for (TriggeredEvent event : this.traces) {
            if (!name.equals(event.name)) continue;
            return true;
        }
        return false;
    }

    public TriggeredEvent getFirstEvent(String name) {
        if (name == null) {
            return null;
        }
        for (TriggeredEvent event : this.traces) {
            if (!name.equals(event.name)) continue;
            return event;
        }
        return null;
    }

    public int size() {
        return this.traces.size();
    }

    public TriggeredEvent get(int index) {
        return this.traces.get(index);
    }

    public class TriggeredEvent {
        public String name;
        public Notification notifier;
        public Object object;

        public TriggeredEvent(String name, Notification notifier) {
            this.name = name;
            this.notifier = notifier;
        }

        public TriggeredEvent(String name, Object object) {
            this.name = name;
            this.object = object;
        }
    }
}

