/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.layers.runtime.model.ILayersModelRootEventListener;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;

public class LayersModelEventRootNotifier {
    protected LayersModel layersModel;
    protected List<ILayersModelRootEventListener> listeners = new ArrayList<ILayersModelRootEventListener>();
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeatureID(Resource.class) == 2) {
                switch (notification.getEventType()) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        if (!(notification.getNewValue() instanceof LayersStackApplication)) break;
                        LayersModelEventRootNotifier.this.fireLayersModelRootAddedEvent(notification);
                        break;
                    }
                    case 4: {
                        if (!(notification.getOldValue() instanceof LayersStackApplication)) break;
                        LayersModelEventRootNotifier.this.fireLayersModelRootRemovedEvent(notification);
                    }
                }
            }
        }
    };

    public LayersModelEventRootNotifier(LayersModel layersModel) {
        this.layersModel = layersModel;
        this.activate();
    }

    protected void activate() {
        this.layersModel.getResource().eAdapters().add((Object)this.modelListener);
    }

    protected void deactivate() {
        this.layersModel.getResource().eAdapters().remove((Object)this.modelListener);
    }

    public void dispose() {
        this.deactivate();
        this.layersModel = null;
    }

    protected boolean isDisposed() {
        return this.layersModel == null;
    }

    public void addEventListener(ILayersModelRootEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeEventListener(ILayersModelRootEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireLayersModelRootAddedEvent(Notification msg) {
        for (ILayersModelRootEventListener listener : this.listeners) {
            listener.layersModelRootAdded(msg);
        }
    }

    protected void fireLayersModelRootRemovedEvent(Notification msg) {
        for (ILayersModelRootEventListener listener : this.listeners) {
            listener.layersModelRootRemoved(msg);
        }
    }
}

