/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.BoundedSubtype;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.CollectionType;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.FlowPort;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Vertex;
import org.polarsys.chess.contracts.profile.chesscontract.Contract;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;

public class Service {
    public static final String CONTRACT = "CHESSContract::Contract";
    public static final String CONTRACT_PROPERTY = "CHESSContract::ContractProperty";
    public static final String FLOWPORT = "SysML::PortAndFlows::FlowPort";
    public static final String FLOWPORTMARTE = "MARTE::MARTE_DesignModel::GCM::FlowPort";
    public static final String CSPORT = "MARTE::MARTE_DesignModel::GCM::ClientServerPort";
    public static final String BOUNDEDSUBTYPE = "MARTE::MARTE_Annexes::VSL::DataTypes::BoundedSubtype";
    public static final String COLLECTIONTYPE = "MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType";

    public Set<String> getNewBlocks(Set<Property> parts) {
        HashSet<String> result = new HashSet<String>();
        for (Property prop : parts) {
            if (prop.getType() == null || prop.getType() instanceof Signal || prop.getType() instanceof PrimitiveType) continue;
            result.add(prop.getType().getName());
        }
        return result;
    }

    public Set<String> getEmptyStringSet() {
        return new HashSet<String>();
    }

    public void addToGenerated(String name, Set<String> generated) {
        generated.add(name);
    }

    public boolean isAlreadyGenerated(String name, Set<String> generated) {
        return generated.contains(name);
    }

    public String getAssume(Class contractClass) {
        Stereotype contractStereo = contractClass.getAppliedStereotype(CONTRACT);
        Contract contract = (Contract)contractClass.getStereotypeApplication(contractStereo);
        return contract.getAssume().getBase_Constraint().getSpecification().stringValue();
    }

    public String getGuarantee(Class contractClass) {
        Stereotype contractStereo = contractClass.getAppliedStereotype(CONTRACT);
        Contract contract = (Contract)contractClass.getStereotypeApplication(contractStereo);
        return contract.getGuarantee().getBase_Constraint().getSpecification().stringValue();
    }

    public String getRefinedBy(Property prop) {
        HashSet<String> result = new HashSet<String>();
        Stereotype contrPropStereo = prop.getAppliedStereotype(CONTRACT_PROPERTY);
        ContractProperty contractProp = (ContractProperty)prop.getStereotypeApplication(contrPropStereo);
        for (ContractRefinement refinedContr : contractProp.getRefinedBy()) {
            result.add(refinedContr.getBase_DataType().getName());
        }
        String strResult = ((Object)result).toString();
        strResult = strResult.substring(1, strResult.length() - 1);
        strResult = strResult.concat(";");
        return strResult;
    }

    public boolean isRefined(Property prop) {
        boolean result = true;
        Stereotype contrPropStereo = prop.getAppliedStereotype(CONTRACT_PROPERTY);
        ContractProperty contractProp = (ContractProperty)prop.getStereotypeApplication(contrPropStereo);
        if (contractProp.getRefinedBy() == null || contractProp.getRefinedBy().isEmpty()) {
            result = false;
        }
        return result;
    }

    public boolean checkRules(Connector conn) {
        boolean result = false;
        ConnectorEnd firstEnd = (ConnectorEnd)conn.getEnds().get(0);
        ConnectorEnd lastEnd = (ConnectorEnd)conn.getEnds().get(1);
        Port firstPort = (Port)firstEnd.getRole();
        Port lastPort = (Port)lastEnd.getRole();
        String firstDir = this.getDirection(firstPort);
        String lastDir = this.getDirection(lastPort);
        Property firstPart = firstEnd.getPartWithPort();
        Property lastPart = lastEnd.getPartWithPort();
        if (firstPart != null && firstDir.equalsIgnoreCase("in")) {
            if (lastPart == null && lastDir.equalsIgnoreCase("in")) {
                result = true;
            } else if (lastPart != null && lastDir.equalsIgnoreCase("out")) {
                result = true;
            }
        } else if (firstPart == null && firstDir.equalsIgnoreCase("out") && lastPart != null && lastDir.equalsIgnoreCase("out")) {
            result = true;
        }
        return result;
    }

    private String getDirection(Port port) {
        String result = null;
        Stereotype flowStereo = port.getAppliedStereotype(FLOWPORT);
        if (flowStereo != null) {
            org.eclipse.papyrus.sysml.portandflows.FlowPort flowport = (org.eclipse.papyrus.sysml.portandflows.FlowPort)port.getStereotypeApplication(flowStereo);
            result = flowport.getDirection().toString();
        } else {
            flowStereo = port.getAppliedStereotype(FLOWPORTMARTE);
            if (flowStereo != null) {
                FlowPort flowportMarte = (FlowPort)port.getStereotypeApplication(flowStereo);
                result = flowportMarte.getDirection().toString();
            }
        }
        return result;
    }

    public boolean checkConnectedPorts(Connector conn) {
        boolean result = false;
        ConnectorEnd firstEnd = (ConnectorEnd)conn.getEnds().get(0);
        ConnectorEnd lastEnd = (ConnectorEnd)conn.getEnds().get(1);
        Port firstPort = (Port)firstEnd.getRole();
        Port lastPort = (Port)lastEnd.getRole();
        if (!(firstPort.getAppliedStereotype(FLOWPORT) == null && firstPort.getAppliedStereotype(FLOWPORTMARTE) == null || lastPort.getAppliedStereotype(FLOWPORTMARTE) == null && lastPort.getAppliedStereotype(FLOWPORT) == null)) {
            result = true;
        }
        return result;
    }

    public boolean checkOperationPorts(Connector conn) {
        boolean result = false;
        ConnectorEnd firstEnd = (ConnectorEnd)conn.getEnds().get(0);
        ConnectorEnd lastEnd = (ConnectorEnd)conn.getEnds().get(1);
        Port firstPort = (Port)firstEnd.getRole();
        Port lastPort = (Port)lastEnd.getRole();
        if (firstPort.getAppliedStereotype(CSPORT) != null && lastPort.getAppliedStereotype(CSPORT) != null) {
            result = true;
        }
        return result;
    }

    public String getOperationConnections(Connector conn) {
        String connections;
        block20: {
            ClientServerPort firstCSPort;
            Property lastProperty;
            Property firstProperty;
            Port lastPort;
            Port firstPort;
            block19: {
                connections = "";
                ConnectorEnd firstEnd = (ConnectorEnd)conn.getEnds().get(0);
                ConnectorEnd lastEnd = (ConnectorEnd)conn.getEnds().get(1);
                firstPort = (Port)firstEnd.getRole();
                lastPort = (Port)lastEnd.getRole();
                firstProperty = firstEnd.getPartWithPort();
                lastProperty = lastEnd.getPartWithPort();
                Stereotype firstStereo = firstPort.getAppliedStereotype(CSPORT);
                firstCSPort = (ClientServerPort)firstPort.getStereotypeApplication(firstStereo);
                Stereotype lastStereo = lastPort.getAppliedStereotype(CSPORT);
                ClientServerPort lastCSPort = (ClientServerPort)lastPort.getStereotypeApplication(lastStereo);
                if (firstProperty == null || lastProperty == null) break block19;
                Interface provInt = null;
                boolean firstProv = false;
                if (firstCSPort.getProvInterface() != null && firstCSPort.getProvInterface().size() > 0) {
                    provInt = (Interface)firstCSPort.getProvInterface().get(0);
                    firstProv = true;
                }
                if (lastCSPort.getProvInterface() != null && lastCSPort.getProvInterface().size() > 0) {
                    provInt = (Interface)lastCSPort.getProvInterface().get(0);
                }
                if (provInt == null) break block20;
                if (!firstProv) {
                    for (Operation op : provInt.getOperations()) {
                        connections = String.valueOf(connections) + "DEFINE " + firstProperty.getName() + "." + firstPort.getName() + "_" + op.getName() + " := " + lastProperty.getName() + "." + lastPort.getName() + "_" + op.getName() + ";\n\t";
                    }
                } else {
                    for (Operation op : provInt.getOperations()) {
                        connections = String.valueOf(connections) + "DEFINE " + lastProperty.getName() + "." + lastPort.getName() + "_" + op.getName() + " := " + firstProperty.getName() + "." + firstPort.getName() + "_" + op.getName() + ";\n\t";
                    }
                }
                break block20;
            }
            if (firstProperty != null && lastProperty == null || firstProperty == null && lastProperty != null) {
                if (firstCSPort.getProvInterface() != null && firstCSPort.getProvInterface().size() > 0) {
                    Interface provInt = (Interface)firstCSPort.getProvInterface().get(0);
                    if (firstProperty == null) {
                        for (Operation op : provInt.getOperations()) {
                            connections = String.valueOf(connections) + "DEFINE " + firstPort.getName() + "_" + op.getName() + " := " + lastProperty.getName() + "." + lastPort.getName() + "_" + op.getName() + ";\n\t";
                        }
                    } else if (lastProperty == null) {
                        for (Operation op : provInt.getOperations()) {
                            connections = String.valueOf(connections) + "DEFINE " + lastPort.getName() + "_" + op.getName() + " := " + firstProperty.getName() + "." + firstPort.getName() + "_" + op.getName() + ";\n\t";
                        }
                    }
                }
                if (firstCSPort.getReqInterface() != null && firstCSPort.getReqInterface().size() > 0) {
                    Interface reqInt = (Interface)firstCSPort.getReqInterface().get(0);
                    if (firstProperty == null) {
                        for (Operation op : reqInt.getOperations()) {
                            connections = String.valueOf(connections) + "DEFINE " + firstPort.getName() + "_" + op.getName() + " := " + lastProperty.getName() + "." + lastPort.getName() + "_" + op.getName() + ";\n\t";
                        }
                    } else if (lastProperty == null) {
                        for (Operation op : reqInt.getOperations()) {
                            connections = String.valueOf(connections) + "DEFINE " + lastPort.getName() + "_" + op.getName() + " := " + firstProperty.getName() + "." + firstPort.getName() + "_" + op.getName() + ";\n\t";
                        }
                    }
                }
            }
        }
        return connections;
    }

    public String getInitCondition(StateMachine sm) {
        Vertex init = null;
        OpaqueBehavior effect = null;
        EList transitions = ((Region)sm.getRegions().get(0)).getTransitions();
        for (Transition tr : transitions) {
            if (!(tr.getSource() instanceof Pseudostate)) continue;
            init = tr.getTarget();
            effect = (OpaqueBehavior)tr.getEffect();
        }
        if (effect != null) {
            return String.valueOf(init.getName()) + " & " + (String)effect.getBodies().get(0);
        }
        return init.getName();
    }

    public Class getSystem(Set<Class> classes, String qname) {
        for (Class cl : classes) {
            if (!cl.getQualifiedName().equals(qname)) continue;
            return cl;
        }
        return null;
    }

    public Interface getInterface(Port port) {
        Stereotype csStereo = port.getAppliedStereotype(CSPORT);
        ClientServerPort csPort = (ClientServerPort)port.getStereotypeApplication(csStereo);
        if (csPort.getReqInterface() != null && csPort.getReqInterface().size() > 0) {
            return (Interface)csPort.getReqInterface().get(0);
        }
        if (csPort.getProvInterface() != null && csPort.getProvInterface().size() > 0) {
            return (Interface)csPort.getProvInterface().get(0);
        }
        return null;
    }

    public String getParamList(Operation op) {
        String paramList = "";
        for (Parameter param : op.getOwnedParameters()) {
            String direction = "";
            if (param.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL)) {
                direction = "IN ";
            }
            if (param.getDirection().equals((Object)ParameterDirectionKind.OUT_LITERAL)) {
                direction = "OUT ";
            }
            if (!param.getDirection().equals((Object)ParameterDirectionKind.IN_LITERAL) && !param.getDirection().equals((Object)ParameterDirectionKind.OUT_LITERAL)) continue;
            paramList = String.valueOf(paramList) + ", " + direction + param.getName() + " : " + this.getType(param.getType());
        }
        if (paramList.compareTo("") == 0) {
            return paramList;
        }
        return paramList.substring(1);
    }

    public String getReturn(Operation op) {
        for (Parameter param : op.getOwnedParameters()) {
            if (!param.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            return this.getType(param.getType());
        }
        return "void";
    }

    public String getOperationName(Operation op, Port port) {
        Stereotype csStereo = port.getAppliedStereotype(CSPORT);
        ClientServerPort csPort = (ClientServerPort)port.getStereotypeApplication(csStereo);
        if (!csPort.getKind().equals((Object)ClientServerKind.PROREQ)) {
            return String.valueOf(port.getName()) + "_" + op.getName();
        }
        return null;
    }

    public String getType(Type type) {
        BoundedSubtype subtype;
        if (type == null) {
            return "";
        }
        if (type instanceof Signal) {
            return "event";
        }
        if (type instanceof Enumeration) {
            Enumeration en = (Enumeration)type;
            String enumString = "";
            Iterator it = en.getOwnedLiterals().iterator();
            while (it.hasNext()) {
                EnumerationLiteral lit = (EnumerationLiteral)it.next();
                enumString = String.valueOf(enumString) + lit.getName();
                if (!it.hasNext()) continue;
                enumString = String.valueOf(enumString) + ",";
            }
            return "{" + enumString + "}";
        }
        Stereotype boundedste = type.getAppliedStereotype(BOUNDEDSUBTYPE);
        if (boundedste != null && (subtype = (BoundedSubtype)type.getStereotypeApplication(boundedste)).getBaseType().getName().compareToIgnoreCase("integer") == 0) {
            return String.valueOf(subtype.getMinValue()) + " .." + subtype.getMaxValue();
        }
        Stereotype collectiontypeStereo = type.getAppliedStereotype(COLLECTIONTYPE);
        if (collectiontypeStereo != null) {
            CollectionType collType = (CollectionType)type.getStereotypeApplication(collectiontypeStereo);
            Property collProp = collType.getCollectionAttrib();
            String arrayType = collProp.getType().getName().toLowerCase();
            arrayType = this.getType(collProp.getType());
            String mult = String.valueOf(collProp.getLower()) + ".." + collProp.getUpper();
            return "array " + mult + " of " + arrayType;
        }
        return type.getName();
    }

    public String getType4FTA(Type type) {
        if (type instanceof Signal) {
            return "event";
        }
        if (type instanceof Enumeration) {
            Enumeration en = (Enumeration)type;
            String enumString = "";
            Iterator it = en.getOwnedLiterals().iterator();
            while (it.hasNext()) {
                EnumerationLiteral lit = (EnumerationLiteral)it.next();
                enumString = String.valueOf(enumString) + lit.getName();
                if (!it.hasNext()) continue;
                enumString = String.valueOf(enumString) + ",";
            }
            return "{" + enumString + "}";
        }
        return type.getName();
    }

    public String getTransitionTarget(String name, String str) {
        String res = "";
        String[] splits = str.split(";");
        int i = 0;
        while (i < splits.length) {
            if (splits[i].contains(name)) {
                res = splits[i];
                res = res.substring(res.lastIndexOf("=") + 1, res.length());
                res = res.trim();
            }
            ++i;
        }
        return String.valueOf(res) + ";";
    }

    public String getEffectOnProperty(StateMachine sm, String propertyName) {
        String res = "";
        for (Element el : sm.allOwnedElements()) {
            OpaqueBehavior effect;
            String body;
            String[] splits;
            Transition tr;
            Behavior beh;
            if (!(el instanceof Transition) || !((beh = (tr = (Transition)el).getEffect()) instanceof OpaqueBehavior) || (splits = (body = (String)(effect = (OpaqueBehavior)beh).getBodies().get(0)).split("="))[0].compareToIgnoreCase(propertyName) != 0 || !(tr.getGuard().getSpecification() instanceof OpaqueExpression)) continue;
            OpaqueExpression guard = (OpaqueExpression)tr.getGuard().getSpecification();
            res = res.concat(String.valueOf((String)guard.getBodies().get(0)) + ":" + splits[1] + ";\n");
        }
        return res;
    }

    public String getModuleFormalParameter(Class block) {
        EList props = block.getOwnedAttributes();
        String result = "";
        String temp = "";
        for (Property prop : props) {
            FlowPort marteflowport;
            Stereotype flowStereo = prop.getAppliedStereotype(FLOWPORT);
            if (flowStereo != null) {
                org.eclipse.papyrus.sysml.portandflows.FlowPort flowport = (org.eclipse.papyrus.sysml.portandflows.FlowPort)prop.getStereotypeApplication(flowStereo);
                temp = flowport.getDirection().toString();
                if (temp.compareToIgnoreCase("in") != 0) continue;
                if (result.compareToIgnoreCase("") == 0) {
                    result = result.concat(prop.getName());
                    continue;
                }
                result = result.concat("," + prop.getName());
                continue;
            }
            Stereotype marteflowStereo = prop.getAppliedStereotype(FLOWPORTMARTE);
            if (marteflowStereo == null || (temp = (marteflowport = (FlowPort)prop.getStereotypeApplication(marteflowStereo)).getDirection().toString()).compareToIgnoreCase("in") != 0) continue;
            result = result.compareToIgnoreCase("") == 0 ? result.concat(prop.getName()) : result.concat("," + prop.getName());
        }
        return result;
    }

    public List<Port> getModuleFormalParameterAsPorts(Class block) {
        Vector<Port> list = new Vector<Port>();
        EList props = block.getOwnedPorts();
        String temp = "";
        for (Port port : props) {
            FlowPort marteflowport;
            Stereotype flowStereo = port.getAppliedStereotype(FLOWPORT);
            if (flowStereo != null) {
                org.eclipse.papyrus.sysml.portandflows.FlowPort flowport = (org.eclipse.papyrus.sysml.portandflows.FlowPort)port.getStereotypeApplication(flowStereo);
                temp = flowport.getDirection().toString();
                if (temp.compareToIgnoreCase("in") != 0) continue;
                list.add(port);
                continue;
            }
            Stereotype marteflowStereo = port.getAppliedStereotype(FLOWPORTMARTE);
            if (marteflowStereo == null || (temp = (marteflowport = (FlowPort)port.getStereotypeApplication(marteflowStereo)).getDirection().toString()).compareToIgnoreCase("in") != 0) continue;
            list.add(port);
        }
        return list;
    }

    public String getModuleInstanceActualParameter(Class blockOwner, Property prop) {
        if (!(prop.getType() instanceof Class)) {
            return "";
        }
        Class module = (Class)prop.getType();
        List<Port> formalParams = this.getModuleFormalParameterAsPorts(module);
        Vector<String> actualParams = new Vector<String>();
        for (Port p : formalParams) {
            FlowPort marteflowport;
            String temp;
            Stereotype flowStereo = p.getAppliedStereotype(FLOWPORT);
            if (flowStereo != null) {
                org.eclipse.papyrus.sysml.portandflows.FlowPort flowport = (org.eclipse.papyrus.sysml.portandflows.FlowPort)p.getStereotypeApplication(flowStereo);
                String temp2 = flowport.getDirection().toString();
                if (temp2.compareToIgnoreCase("in") != 0) continue;
                actualParams.add("");
                continue;
            }
            Stereotype marteflowStereo = p.getAppliedStereotype(FLOWPORTMARTE);
            if (marteflowStereo == null || (temp = (marteflowport = (FlowPort)p.getStereotypeApplication(marteflowStereo)).getDirection().toString()).compareToIgnoreCase("in") != 0) continue;
            actualParams.add("");
        }
        Integer index = -1;
        String result = "(";
        String temp = "";
        for (Connector conn : blockOwner.getOwnedConnectors()) {
            String proprIn = null;
            String portIn = null;
            boolean found = false;
            for (ConnectorEnd end : conn.getEnds()) {
                if (end.getPartWithPort() != null && end.getPartWithPort().equals(prop) && end.getRole() instanceof Port) {
                    Stereotype flowStereo = end.getRole().getAppliedStereotype(FLOWPORT);
                    if (flowStereo != null) {
                        org.eclipse.papyrus.sysml.portandflows.FlowPort flowport = (org.eclipse.papyrus.sysml.portandflows.FlowPort)end.getRole().getStereotypeApplication(flowStereo);
                        temp = flowport.getDirection().toString();
                        if (temp.compareToIgnoreCase("in") == 0) {
                            found = true;
                            index = formalParams.lastIndexOf(end.getRole());
                        }
                    } else {
                        FlowPort marteflowport;
                        Stereotype marteflowStereo = end.getRole().getAppliedStereotype(FLOWPORTMARTE);
                        if (marteflowStereo != null && (temp = (marteflowport = (FlowPort)end.getRole().getStereotypeApplication(marteflowStereo)).getDirection().toString()).compareToIgnoreCase("in") == 0) {
                            found = true;
                            index = formalParams.lastIndexOf(end.getRole());
                        }
                    }
                } else {
                    proprIn = end.getPartWithPort() != null ? String.valueOf(end.getPartWithPort().getName()) + "." : "";
                    portIn = end.getRole().getName();
                }
                if (!found) continue;
                actualParams.set(index, String.valueOf(proprIn) + portIn);
                index = -1;
            }
        }
        for (Constraint c : blockOwner.getOwnedRules()) {
            boolean found = false;
            String constraintName = null;
            for (Element el : c.getConstrainedElements()) {
                if (el.equals(prop)) {
                    found = true;
                }
                if (!((Class)prop.getType()).getOwnedPorts().contains((Object)el)) continue;
                constraintName = c.getName();
                index = formalParams.lastIndexOf((Port)el);
            }
            if (!found || constraintName == null) continue;
            actualParams.set(index, constraintName);
            index = -1;
        }
        for (String s : actualParams) {
            result = String.valueOf(result) + s + ",";
        }
        if (result.compareTo("(") == 0) {
            return "";
        }
        return String.valueOf(result.substring(0, result.length() - 1)) + ")";
    }

    public String getTypeNameForProperty(Property prop) {
        Type type = prop.getType();
        if (type == null) {
            return "";
        }
        Stereotype stereo = type.getAppliedStereotype(BOUNDEDSUBTYPE);
        if (stereo != null) {
            BoundedSubtype subtype = (BoundedSubtype)type.getStereotypeApplication(stereo);
            return String.valueOf(subtype.getMinValue()) + ".." + subtype.getMaxValue();
        }
        return this.getType(type);
    }
}

