/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnHeaderLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.ui.tools.internal.util.ItemSearcher;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class TableUIUpdater
extends ResourceSetListenerImpl {
    private DTableViewerManager dTableViewerManager;
    private DTableTreeViewer dTableTreeViewer;

    public TableUIUpdater(DTableViewerManager dTableViewerManager) {
        this.dTableViewerManager = dTableViewerManager;
        this.dTableTreeViewer = (DTableTreeViewer)dTableViewerManager.getTreeViewer();
        dTableViewerManager.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    private boolean isCustom(Notification notif) {
        return notif.getEventType() == -1;
    }

    private void notifyChanged(Notification notification) {
        Resource resource;
        if (this.dTableTreeViewer == null || this.dTableTreeViewer.getControl() == null || this.dTableTreeViewer.getControl().isDisposed()) {
            TransactionalEditingDomain domain;
            if (notification.getNotifier() instanceof EObject && (domain = TransactionUtil.getEditingDomain((Object)notification.getNotifier())) != null) {
                domain.removeResourceSetListener((ResourceSetListener)this);
            }
            return;
        }
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource && "odesign".equals((resource = (Resource)notifier).getURI().fileExtension()) && (notification.getFeatureID(Resource.class) == 3 || notification.getFeatureID(Resource.class) == 4)) {
            this.dTableTreeViewer.setDescriptionFileChanged(true);
        }
        if (this.isChangeAboutDTableModel(notification)) {
            if (notifier instanceof DTable) {
                this.handleDTableNotification(notification, (DTable)notifier);
            } else if (notifier instanceof DLine) {
                this.handleDLineNotification(notification, (DLine)notifier);
            } else if (notifier instanceof DColumn) {
                this.handleDColumnNotification(notification, (DColumn)notifier);
            } else if (notifier instanceof DCell) {
                this.handleDCellNotification(notification, (DCell)notifier);
            } else if (notifier instanceof DTableElementStyle) {
                this.handleDTableElementStyleNotification(notification, (DTableElementStyle)notification.getNotifier());
            } else if (notifier instanceof RGBValues) {
                this.handleDCellNotification(notification, (RGBValues)notifier);
            }
        }
    }

    private boolean isChangeAboutDTableModel(Notification notification) {
        boolean isImpactingNotification = false;
        Object notifier = notification.getNotifier();
        DTable dTable = null;
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            if (eObject instanceof DTable) {
                dTable = (DTable)eObject;
            }
            while (eObject != null && dTable == null) {
                if (eObject instanceof DTable) {
                    dTable = (DTable)eObject;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        if (dTable != null && this.dTableTreeViewer.isSameTable(dTable)) {
            isImpactingNotification = true;
        } else if (dTable == null && notifier instanceof DTableElement) {
            isImpactingNotification = true;
        }
        return isImpactingNotification;
    }

    private void handleDTableNotification(Notification n, final DTable dTable) {
        int featureID = n.getFeatureID(DTable.class);
        switch (featureID) {
            case 6: 
            case 7: {
                DslCommonPlugin.PROFILER.startWork("Refresh the SWT table");
                this.refreshViewer(dTable);
                DslCommonPlugin.PROFILER.stopWork("Refresh the SWT table");
                break;
            }
            case 9: {
                if (!this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) break;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Tree tree;
                        TreeColumn headerTreeColumn;
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed() && (headerTreeColumn = (tree = TableUIUpdater.this.dTableTreeViewer.getTree()).getColumn(0)).getWidth() != dTable.getHeaderColumnWidth()) {
                            headerTreeColumn.setWidth(dTable.getHeaderColumnWidth());
                        }
                    }
                });
                break;
            }
            case 8: {
                if (n.getEventType() == 3) {
                    if (!(n.getNewValue() instanceof DColumn)) break;
                    this.add(n.getPosition(), (DColumn)n.getNewValue());
                    break;
                }
                if (n.getEventType() == 7) {
                    if (!(n.getNewValue() instanceof DTargetColumn)) break;
                    this.move(n.getPosition(), (Integer)n.getOldValue(), (DTargetColumn)n.getNewValue());
                    break;
                }
                if (n.getEventType() == 4) {
                    if (!(n.getOldValue() instanceof DColumn)) break;
                    this.remove((DColumn)n.getOldValue());
                    break;
                }
                if (n.getEventType() != 6 || !(n.getOldValue() instanceof EList)) break;
                for (EObject oldValue : (EList)n.getOldValue()) {
                    if (!(oldValue instanceof DTargetColumn)) continue;
                    this.remove((DColumn)((DTargetColumn)oldValue));
                }
                break;
            }
        }
    }

    private void add(final int position, final DColumn newValue) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                    TableUIUpdater.this.addNewColumn(position + 1, newValue);
                    TableUIUpdater.this.dTableTreeViewer.refresh();
                }
            }
        });
    }

    private void move(final int position, final Integer oldValue, final DTargetColumn newValue) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableUIUpdater.this.addNewColumn(position + 1, (DColumn)newValue);
                int newPosition = position + 1;
                int oldPosition = oldValue + 1;
                if (newPosition < oldPosition) {
                    TableUIUpdater.this.removeOldColumn(oldPosition + 1);
                } else {
                    TableUIUpdater.this.removeOldColumn(oldPosition);
                }
            }
        });
    }

    private void remove(final DColumn column) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                    TableUIUpdater.this.removeOldColumn(column);
                }
            }
        });
    }

    private void removeOldColumn(DColumn oldColumn) {
        this.dTableTreeViewer.removeOldColumn(oldColumn);
    }

    private void removeOldColumn(int position) {
        this.dTableTreeViewer.removeOldColumn(position);
    }

    private void addNewColumn(int position, DColumn newColumn) {
        DTableEditorUtil.addNewColumn(this.dTableViewerManager, position, newColumn);
    }

    private void handleDLineNotification(Notification n, final DLine dLine) {
        int featureID = n.getFeatureID(DLine.class);
        switch (featureID) {
            case 5: 
            case 9: {
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(dLine);
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
            case 11: {
                DslCommonPlugin.PROFILER.startWork("Refresh a line of the SWT table");
                this.refreshViewer(dLine);
                DslCommonPlugin.PROFILER.stopWork("Refresh a line of the SWT table");
                break;
            }
            case 1: {
                DslCommonPlugin.PROFILER.startWork("Refresh a line of the SWT table");
                this.refreshViewer(dLine);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                            TableUIUpdater.this.dTableTreeViewer.setExpandedState(dLine, !dLine.isCollapsed());
                        }
                    }
                });
                DslCommonPlugin.PROFILER.stopWork("Refresh a line of the SWT table");
                break;
            }
            case 8: {
                if (!(n.getNewValue() instanceof Boolean) || this.dTableTreeViewer == null) break;
                DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
                final boolean collapsed = n.getNewBooleanValue();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                            TableUIUpdater.this.dTableTreeViewer.setExpandedState(dLine, !collapsed);
                        }
                    }
                });
                DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
                break;
            }
            case 7: {
                if (!(n.getNewValue() instanceof Boolean) || this.dTableTreeViewer == null) break;
                DslCommonPlugin.PROFILER.startWork("Change the visible state of a line of the SWT table");
                this.dTableTreeViewer.refresh(false);
                DslCommonPlugin.PROFILER.stopWork("Change the visible state of a line of the SWT table");
                break;
            }
        }
    }

    private void handleDColumnNotification(final Notification n, final DColumn dColumn) {
        int featureID = n.getFeatureID(DColumn.class);
        switch (featureID) {
            case 4: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                            int i = 0;
                            while (i < TableUIUpdater.this.dTableTreeViewer.getTree().getColumns().length) {
                                CellLabelProvider labelProvider = TableUIUpdater.this.dTableTreeViewer.getLabelProvider(i);
                                if (labelProvider instanceof DTableColumnLabelProvider && ((DTableColumnLabelProvider)labelProvider).isProvideColumn(dColumn)) {
                                    DslCommonPlugin.PROFILER.startWork("Set the column name in the SWT table");
                                    TreeColumn treeColumn = TableUIUpdater.this.dTableTreeViewer.getTree().getColumn(i);
                                    DTableColumnHeaderLabelProvider dTableColumnHeaderLabelProvider = new DTableColumnHeaderLabelProvider();
                                    String text = dTableColumnHeaderLabelProvider.getText(dColumn);
                                    treeColumn.setText(text);
                                    Image image = dTableColumnHeaderLabelProvider.getImage(dColumn);
                                    treeColumn.setImage(image);
                                    DslCommonPlugin.PROFILER.stopWork("Set the column name in the SWT table");
                                }
                                ++i;
                            }
                        }
                    }
                });
                break;
            }
            case 8: {
                DslCommonPlugin.PROFILER.startWork("Refresh a table");
                this.dTableTreeViewer.refresh(true);
                DslCommonPlugin.PROFILER.stopWork("Refresh a table");
                break;
            }
            case 9: {
                if (!(n.getNewValue() instanceof Boolean) || this.dTableTreeViewer == null) break;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                            int i = 0;
                            while (i < TableUIUpdater.this.dTableTreeViewer.getTree().getColumns().length) {
                                CellLabelProvider labelProvider = TableUIUpdater.this.dTableTreeViewer.getLabelProvider(i);
                                if (labelProvider instanceof DTableColumnLabelProvider && ((DTableColumnLabelProvider)labelProvider).isProvideColumn(dColumn)) {
                                    DslCommonPlugin.PROFILER.startWork("Change the visible state of a column of the SWT table");
                                    TreeColumn treeColumn = TableUIUpdater.this.dTableTreeViewer.getTree().getColumn(i);
                                    this.handleColumn(treeColumn, n);
                                    DslCommonPlugin.PROFILER.stopWork("Change the visible state of a column of the SWT table");
                                }
                                ++i;
                            }
                        }
                    }

                    protected void handleColumn(TreeColumn treeColumn, Notification n2) {
                        if (n2.getNewBooleanValue()) {
                            Integer restoredWith = (Integer)treeColumn.getData("restoredWidth");
                            if (restoredWith != null) {
                                treeColumn.setWidth(restoredWith.intValue());
                                ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(restoredWith.intValue()));
                            } else {
                                treeColumn.pack();
                                ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(treeColumn.getWidth()));
                            }
                        } else {
                            treeColumn.setData("restoredWidth", (Object)treeColumn.getWidth());
                            treeColumn.setWidth(0);
                            ((TreeColumnLayout)treeColumn.getParent().getParent().getLayout()).setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(0));
                        }
                    }
                });
                break;
            }
            case 10: {
                if (!this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) break;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                            TreeColumn treeColumn;
                            Tree tree = TableUIUpdater.this.dTableTreeViewer.getTree();
                            ItemSearcher itemSearcher = new ItemSearcher(tree, (DRepresentationElement)dColumn);
                            itemSearcher.run();
                            Object result = itemSearcher.getResult();
                            if (result instanceof TreeColumn && (treeColumn = (TreeColumn)result).getWidth() != dColumn.getWidth()) {
                                treeColumn.setWidth(dColumn.getWidth());
                            }
                        }
                    }
                });
                break;
            }
        }
    }

    private void handleDCellNotification(Notification n, DCell cell) {
        int featureID = n.getFeatureID(DCell.class);
        switch (featureID) {
            case 4: 
            case 7: {
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(cell.getLine());
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
        }
    }

    private void handleDCellNotification(Notification n, RGBValues notifier) {
        int featureID = n.getFeatureID(RGBValues.class);
        switch (featureID) {
            case 0: 
            case 1: 
            case 2: {
                DCell containerCell = TableHelper.getCell((RGBValues)notifier);
                if (containerCell == null || containerCell.getLine() == null) break;
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(containerCell.getLine());
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
        }
    }

    private void handleDTableElementStyleNotification(Notification n, DTableElementStyle notifier) {
        int featureID = n.getFeatureID(DTableElementStyle.class);
        switch (featureID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (notifier.eContainer() instanceof DCell) {
                    DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                    this.updateViewer(((DCell)notifier.eContainer()).getLine());
                    DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                    break;
                }
                if (notifier.eContainer() instanceof DLine) {
                    DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                    this.updateViewer(notifier.eContainer());
                    DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                    break;
                }
                if (!(notifier.eContainer() instanceof DColumn)) break;
                DslCommonPlugin.PROFILER.startWork("Refresh the SWT table");
                this.refreshViewer(((DColumn)notifier.eContainer()).getTable());
                DslCommonPlugin.PROFILER.stopWork("Refresh the SWT table");
                break;
            }
        }
    }

    private void refreshViewer(final Object object) {
        if (object != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                        TableUIUpdater.this.dTableTreeViewer.refresh(object, true);
                    }
                }
            });
        }
    }

    private void updateViewer(final Object object) {
        if (object != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TableUIUpdater.this.dTableTreeViewer != null && TableUIUpdater.this.dTableTreeViewer.getControl() != null && !TableUIUpdater.this.dTableTreeViewer.getTree().isDisposed()) {
                        TableUIUpdater.this.dTableTreeViewer.update(object, null);
                    }
                }
            });
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
        for (Notification notif : event.getNotifications()) {
            if (this.isCustom(notif)) continue;
            this.notifyChanged(notif);
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

