/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FilterKind implements Enumerator
{
    HIDE_LITERAL(0, "HIDE", "HIDE"),
    COLLAPSE_LITERAL(1, "COLLAPSE", "COLLAPSE");

    public static final int HIDE = 0;
    public static final int COLLAPSE = 1;
    private static final FilterKind[] VALUES_ARRAY;
    public static final List<FilterKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FilterKind[]{HIDE_LITERAL, COLLAPSE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FilterKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterKind get(int value) {
        switch (value) {
            case 0: {
                return HIDE_LITERAL;
            }
            case 1: {
                return COLLAPSE_LITERAL;
            }
        }
        return null;
    }

    private FilterKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

