/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class EdgeMappingHelper {
    private IInterpreter interpreter;

    public EdgeMappingHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public EObject getSemanticTarget(EdgeTarget edgeTarget) {
        if (edgeTarget instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)edgeTarget).getTarget();
        }
        SiriusPlugin.getDefault().warning("The edge target " + String.valueOf(edgeTarget) + "The element is not a DSemanticDecorator", null);
        return null;
    }

    public EList<EObject> getEdgeTargetCandidates(EdgeMapping self, EObject semanticOrigin, DDiagram diagram) {
        UniqueEList result = new UniqueEList();
        if (self.getTargetFinderExpression() != null && !StringUtil.isEmpty((String)self.getTargetFinderExpression().trim())) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter);
            Collection candidates = safeInterpreter.evaluateCollection(semanticOrigin, (EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_TargetFinderExpression());
            result = new UniqueEList(candidates);
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
        }
        return result;
    }

    public EList<EObject> getEdgeSourceCandidates(EdgeMapping self, EObject semanticOrigin, DDiagram diagram) {
        UniqueEList result = new UniqueEList();
        if (self.getSourceFinderExpression() != null && !StringUtil.isEmpty((String)self.getSourceFinderExpression().trim())) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            Collection resultList = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(semanticOrigin, (EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_SourceFinderExpression());
            result = new UniqueEList(resultList);
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
        }
        return result;
    }

    public DEdge createEdge(EdgeMapping edgeMapping, EdgeTarget source, EdgeTarget target, EObject container, EObject semanticTarget) {
        EObject semanticTargetToUseForExpression = semanticTarget;
        if (semanticTargetToUseForExpression == null) {
            semanticTargetToUseForExpression = this.getSemanticTarget(source);
        }
        DEdge newEdge = DiagramFactory.eINSTANCE.createDEdge();
        newEdge.setSourceNode(source);
        newEdge.setTargetNode(target);
        if (edgeMapping instanceof EdgeMappingImportWrapper) {
            newEdge.setActualMapping(((EdgeMappingImportWrapper)edgeMapping).getWrappedEdgeMappingImport());
        } else {
            newEdge.setActualMapping(edgeMapping);
        }
        DDiagram diagram = null;
        if (source instanceof DDiagramElement) {
            diagram = ((DDiagramElement)((Object)source)).getParentDiagram();
        }
        newEdge.setTarget(semanticTargetToUseForExpression);
        if (semanticTarget == null && !StringUtil.isEmpty((String)edgeMapping.getTargetExpression())) {
            EObject context = newEdge.getTarget();
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            EObject adapterValue = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateEObject(context, (EObject)edgeMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_TargetExpression());
            if (adapterValue != null) {
                newEdge.setTarget(adapterValue);
            }
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("diagram");
        }
        EdgeStyle style = (EdgeStyle)new MappingHelper(this.interpreter).getBestStyle(edgeMapping, newEdge.getTarget(), diagram, container, diagram);
        EdgeStyleDescription styleDescription = null;
        if (style != null && style.getDescription() instanceof EdgeStyleDescription) {
            styleDescription = (EdgeStyleDescription)style.getDescription();
        }
        DiagramElementMappingHelper.refreshSemanticElements(edgeMapping, newEdge, this.interpreter);
        this.createPath(edgeMapping, newEdge, diagram);
        if (style != null) {
            newEdge.setOwnedStyle(style);
        }
        if (newEdge.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle(newEdge.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        if (styleDescription != null) {
            String endName;
            String beginName;
            String name = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getCenterLabelStyleDescription(), diagram);
            if (name != null) {
                newEdge.setName(name);
            }
            if ((beginName = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getBeginLabelStyleDescription(), diagram)) != null) {
                newEdge.setBeginLabel(beginName);
            }
            if ((endName = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getEndLabelStyleDescription(), diagram)) != null) {
                newEdge.setEndLabel(endName);
            }
        }
        return newEdge;
    }

    private String computeLabel(DSemanticDecorator view, EObject descriptionObject, DDiagram diagram) {
        String result = null;
        if (descriptionObject instanceof BasicLabelStyleDescription) {
            result = "Invalid feature as name";
            String labelExpression = ((BasicLabelStyleDescription)descriptionObject).getLabelExpression();
            this.interpreter.setVariable("view", (Object)view);
            this.interpreter.setVariable("diagram", (Object)diagram);
            try {
                try {
                    result = this.interpreter.evaluateString(view.getTarget(), labelExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error(descriptionObject, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("diagram");
                this.interpreter.unSetVariable("view");
            }
        }
        return result;
    }

    private void createPath(EdgeMapping edgeMapping, DEdge edge, EObject diagram) {
        if (edgeMapping.getPathExpression() != null && !StringUtil.isEmpty((String)edgeMapping.getPathExpression()) && edgeMapping.getPathNodeMapping() != null) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            this.interpreter.setVariable("element", (Object)edge.getTarget());
            this.interpreter.setVariable("source", (Object)this.getSemanticTarget(edge.getSourceNode()));
            this.interpreter.setVariable("target", (Object)this.getSemanticTarget(edge.getTargetNode()));
            Collection elements = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(edge.getTarget(), (EObject)edgeMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_PathExpression());
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("element");
            this.interpreter.unSetVariable("source");
            this.interpreter.unSetVariable("target");
            BasicEList newPath = new BasicEList();
            for (EObject current : elements) {
                for (AbstractNodeMapping currentNodeMapping : edgeMapping.getPathNodeMapping()) {
                    EList<DDiagramElement> listView = currentNodeMapping.findDNodeFromEObject(current);
                    if (listView == null) continue;
                    for (Object vpElement : listView) {
                        if (!(vpElement instanceof EdgeTarget)) continue;
                        newPath.add((Object)((EdgeTarget)vpElement));
                    }
                }
            }
            EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
            if (!equalityHelper.equals(edge.getPath(), (List)newPath)) {
                edge.getPath().clear();
                edge.getPath().addAll((Collection)newPath);
            }
        }
    }

    public void updateEdge(EdgeMapping edgeMapping, DEdge dEdge) {
        if (dEdge.validate()) {
            EObject containerVariable = null;
            if (dEdge.eContainer() instanceof DSemanticDecorator) {
                containerVariable = ((DSemanticDecorator)dEdge.eContainer()).getTarget();
            }
            EdgeStyleDescription styleDescription = (EdgeStyleDescription)new MappingHelper(this.interpreter).getBestStyleDescription(edgeMapping, dEdge.getTarget(), dEdge, containerVariable, dEdge.getParentDiagram());
            DDiagram dDiagram = dEdge.getParentDiagram();
            this.createPath(edgeMapping, dEdge, dDiagram);
            DiagramElementMappingHelper.refreshSemanticElements(edgeMapping, dEdge, this.interpreter);
            if (styleDescription != null) {
                String endName;
                String beginName;
                String name = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getCenterLabelStyleDescription(), dDiagram);
                if (name != null) {
                    dEdge.setName(name);
                }
                if ((beginName = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getBeginLabelStyleDescription(), dDiagram)) != null) {
                    dEdge.setBeginLabel(beginName);
                }
                if ((endName = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getEndLabelStyleDescription(), dDiagram)) != null) {
                    dEdge.setEndLabel(endName);
                }
            }
            StyleHelper styleHelper = new StyleHelper(this.interpreter);
            if (styleDescription != null && dEdge.getStyle() != null && styleDescription != dEdge.getStyle().getDescription()) {
                styleHelper.setAndRefreshStyle(dEdge, dEdge.getOwnedStyle(), styleHelper.createStyle(styleDescription));
            } else if (dEdge.getOwnedStyle() != null) {
                styleHelper.refreshStyle(dEdge.getOwnedStyle());
            }
        }
    }

    public static boolean isImported(IEdgeMapping mapping, EdgeMappingImport edgeMappingImport) {
        boolean result = false;
        if (mapping.equals(edgeMappingImport.getImportedMapping())) {
            result = true;
        } else if (edgeMappingImport.getImportedMapping() instanceof EdgeMappingImport) {
            result = EdgeMappingHelper.isImported(mapping, (EdgeMappingImport)edgeMappingImport.getImportedMapping());
        }
        return result;
    }
}

