/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIDFactory;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.cache.KeyCache;

public class DEdgeCandidate {
    private final EdgeTarget sourceView;
    private final EdgeTarget targetView;
    private IEdgeMapping mapping;
    private final EObject semantic;
    private DEdge element;
    private final EdgeMapping rootMapping;
    private final int hashCode;

    public DEdgeCandidate(DEdge element) {
        this.element = element;
        this.semantic = element.getTarget();
        this.mapping = element.getActualMapping();
        this.sourceView = element.getSourceNode();
        this.targetView = element.getTargetNode();
        this.rootMapping = this.getRootMapping(this.mapping);
        this.hashCode = this.computeHashCode();
    }

    public DEdgeCandidate(EdgeMapping mapping, EObject semantic, EdgeTarget sourceView, EdgeTarget targetView) {
        this.mapping = mapping instanceof EdgeMappingImportWrapper ? ((EdgeMappingImportWrapper)mapping).getWrappedEdgeMappingImport() : mapping;
        this.semantic = semantic;
        this.sourceView = sourceView;
        this.targetView = targetView;
        this.rootMapping = this.getRootMapping(this.mapping);
        this.hashCode = this.computeHashCode();
    }

    public boolean isInvalid() {
        Option<DDiagram> sourceDiagram = new EObjectQuery(this.sourceView).getParentDiagram();
        Option<DDiagram> targetDiagram = new EObjectQuery(this.targetView).getParentDiagram();
        return !sourceDiagram.some() || !targetDiagram.some();
    }

    public EdgeTarget getSourceView() {
        return this.sourceView;
    }

    public EdgeTarget getTargetView() {
        return this.targetView;
    }

    public IEdgeMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public DEdge getEdge() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int[] parts = new int[]{this.rootMapping == null ? 0 : this.rootMapping.hashCode(), this.semantic == null ? 0 : this.getSemanticURI().hashCode(), this.sourceView == null ? 0 : this.getSourceViewURI(), this.targetView == null ? 0 : this.getTargetViewURI()};
        return KeyCache.DEFAULT.getKey((Object)(String.valueOf(parts[0]) + "/" + parts[1] + "/" + parts[2] + "/" + parts[3]));
    }

    private Integer getTargetViewURI() {
        return RefreshIDFactory.getOrCreateID((EObject)this.targetView);
    }

    private Integer getSourceViewURI() {
        return RefreshIDFactory.getOrCreateID((EObject)this.sourceView);
    }

    private Integer getSemanticURI() {
        return RefreshIDFactory.getOrCreateID((EObject)this.semantic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DEdgeCandidate)) {
            return false;
        }
        DEdgeCandidate other = (DEdgeCandidate)obj;
        if (this.rootMapping == null ? other.rootMapping != null : !this.rootMapping.equals(other.rootMapping)) {
            return false;
        }
        if (this.semantic == null ? other.semantic != null : !this.getSemanticURI().equals(other.getSemanticURI())) {
            return false;
        }
        if (this.sourceView == null ? other.sourceView != null : !this.getSourceViewURI().equals(other.getSourceViewURI())) {
            return false;
        }
        return !(this.targetView == null ? other.targetView != null : !this.getTargetViewURI().equals(other.getTargetViewURI()));
    }

    private EdgeMapping getRootMapping(IEdgeMapping iEdgeMapping) {
        IEdgeMapping result = iEdgeMapping;
        if (iEdgeMapping != null) {
            while (result instanceof EdgeMappingImport || result instanceof EdgeMappingImportWrapper) {
                if (result instanceof EdgeMappingImport) {
                    result = ((EdgeMappingImport)result).getImportedMapping();
                    continue;
                }
                if (!(result instanceof EdgeMappingImportWrapper)) continue;
                result = ((EdgeMappingImportWrapper)result).getImportedMapping();
            }
        }
        if (result instanceof EdgeMapping) {
            return (EdgeMapping)result;
        }
        return null;
    }
}

