/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;

public class ToolSectionQuery {
    private ToolSection toolSection;

    public ToolSectionQuery(ToolSection toolSection) {
        this.toolSection = toolSection;
    }

    public EList<ToolSection> getAllSections() {
        BasicEList result = new BasicEList();
        if (this.toolSection != null) {
            result.add((Object)this.toolSection);
            result.addAll(this.getAllSections(this.toolSection.getSubSections()));
        }
        return result;
    }

    private EList<ToolSection> getAllSections(EList<ToolSection> toolSections) {
        BasicEList result = new BasicEList();
        for (ToolSection ts : toolSections) {
            result.addAll(new ToolSectionQuery(ts).getAllSections());
        }
        return result;
    }

    public EList<OperationAction> getOperationActions(Session session) {
        BasicEList result = new BasicEList();
        for (ToolEntry tool : new DiagramComponentizationManager().getToolEntries(session.getSelectedViewpoints(false), this.toolSection)) {
            if (!(tool instanceof OperationAction)) continue;
            result.add((Object)((OperationAction)tool));
        }
        return result;
    }

    public EList<ExternalJavaAction> getExternalJavaActions(Session session) {
        BasicEList result = new BasicEList();
        for (ToolEntry tool : new DiagramComponentizationManager().getToolEntries(session.getSelectedViewpoints(false), this.toolSection)) {
            if (!(tool instanceof ExternalJavaAction)) continue;
            result.add((Object)((ExternalJavaAction)tool));
        }
        return result;
    }
}

