/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.utils;

import java.util.Collection;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ValueSpecification;

public class ParameterLabelUtil {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    public static String getPrintString(Parameter parameter, Collection<String> displayValue) {
        if (displayValue.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        if (parameter != null) {
            ValueSpecification valueSpecification;
            String upper;
            if (displayValue.contains("direction") || displayValue.contains("parametersDirection")) {
                String direction;
                switch (parameter.getDirection().getValue()) {
                    case 0: {
                        direction = "in";
                        break;
                    }
                    case 2: {
                        direction = "out";
                        break;
                    }
                    case 1: {
                        direction = "inout";
                        break;
                    }
                    case 3: {
                        direction = "return";
                        break;
                    }
                    default: {
                        direction = "in";
                    }
                }
                result = String.format(DIRECTION_FORMAT, direction, result);
            }
            if ((displayValue.contains("name") || displayValue.contains("parametersName")) && parameter.isSetName()) {
                String name = parameter.getName();
                result = String.format(NAME_FORMAT, result, name);
            }
            if (displayValue.contains("type") || displayValue.contains("parametersType")) {
                String type = "<Undefined>";
                if (parameter.getType() != null) {
                    type = parameter.getType().getName();
                }
                if (displayValue.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            String lower = parameter.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)parameter.getLowerValue()) : "1";
            String string = upper = parameter.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)parameter.getUpperValue()) : "1";
            if (!(!displayValue.contains("parametersMultiplicity") && !displayValue.contains("multiplicity") || "1".equals(lower) && "1".equals(upper))) {
                result = String.format(MULTIPLICITY_FORMAT, result, lower, upper);
            }
            if ((displayValue.contains("parametersDefault") || displayValue.contains("defaultValue")) && parameter.getDefaultValue() != null && ((valueSpecification = parameter.getDefaultValue()) instanceof InstanceValue && parameter.getType().equals(valueSpecification.getType()) || !(valueSpecification instanceof InstanceValue))) {
                result = String.format(DEFAULT_VALUE_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            if (displayValue.contains("parametersModifiers") || displayValue.contains("modifiers")) {
                StringBuffer sb = new StringBuffer();
                if (parameter.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (parameter.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (parameter.isStream()) {
                    sb.append(sb.length() == 0 ? "stream" : ", stream");
                }
                if (parameter.isException()) {
                    sb.append(sb.length() == 0 ? "exception" : ", exception");
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }
}

