/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.part;

import org.eclipse.draw2d.Connection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.sysml.blocks.BindingConnector;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementLinkEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConnectorLinkLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConnectorLinkLabelSourceMultiplicityEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConnectorLinkLabelTargetMultiplicityEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.ConnectorEdgeFigure;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectorEditPart
extends AbstractElementLinkEditPart {
    public ConnectorEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ConnectorLinkLabelEditPart) {
            ((ConnectorLinkLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof ConnectorLinkLabelSourceMultiplicityEditPart) {
            ((ConnectorLinkLabelSourceMultiplicityEditPart)childEditPart).setLabel(this.getPrimaryShape().getSourceMultiplicityLabel());
            return true;
        }
        if (childEditPart instanceof ConnectorLinkLabelTargetMultiplicityEditPart) {
            ((ConnectorLinkLabelTargetMultiplicityEditPart)childEditPart).setLabel(this.getPrimaryShape().getTargetMultiplicityLabel());
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ConnectorLinkLabelEditPart) {
            return true;
        }
        if (childEditPart instanceof ConnectorLinkLabelSourceMultiplicityEditPart) {
            return true;
        }
        if (childEditPart instanceof ConnectorLinkLabelTargetMultiplicityEditPart) {
            return true;
        }
        return super.removeFixedChild(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new ConnectorEdgeFigure();
    }

    public ConnectorEdgeFigure getPrimaryShape() {
        return (ConnectorEdgeFigure)this.getFigure();
    }

    protected void refreshLineWidth() {
        int width = this.getLineWidth();
        if (width < 1) {
            width = 1;
        }
        if (UMLUtil.getStereotypeApplication((Element)((Element)this.resolveSemanticElement()), BindingConnector.class) != null) {
            this.setLineWidth(width * 2);
        } else {
            this.setLineWidth(width);
        }
    }
}

